"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.getJsonFromString = void 0;
var _stream = require("stream");
var _csvParser = _interopRequireDefault(require("csv-parser"));
function _interopRequireDefault(e) { return e && e.__esModule ? e : { default: e }; }
/*
 * Copyright OpenSearch Contributors
 * SPDX-License-Identifier: Apache-2.0
 */

const getJsonFromString = (csvString, options) => {
  const results = [];
  return new Promise((resolve, reject) => {
    _stream.Readable.from(csvString).pipe((0, _csvParser.default)(options)).on('data', data => results.push(data)).on('end', () => {
      resolve(results);
    }).on('error', err => {
      reject(err);
    });
  });
};
exports.getJsonFromString = getJsonFromString;
//# sourceMappingURL=data:application/json;charset=utf-8;base64,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