/*
 * Decompiled with CFR 0.152.
 */
package org.traccar.protocol;

import io.netty.channel.Channel;
import java.net.SocketAddress;
import java.util.regex.Pattern;
import org.traccar.BaseProtocolDecoder;
import org.traccar.NetworkMessage;
import org.traccar.Protocol;
import org.traccar.helper.DateBuilder;
import org.traccar.helper.Parser;
import org.traccar.helper.PatternBuilder;
import org.traccar.helper.UnitsConverter;
import org.traccar.model.Position;
import org.traccar.session.DeviceSession;

public class MilesmateProtocolDecoder
extends BaseProtocolDecoder {
    private static final Pattern PATTERN = new PatternBuilder().text("ApiString={").number("A:(d+),").number("B:(d+.d+),").number("C:(d+.d+),").number("D:(dd)(dd)(dd),").number("E:(dd)(dd.d+)([NS]),").number("F:(ddd)(dd.d+)([EW]),").number("G:(d+.d+),").number("H:(dd)(dd)(dd),").expression("I:[GL],").number("J:(d{8}),").number("K:(d{7})").expression("([AV]),").number("L:d{4},").number("M:(d+.d+)").text("}").compile();

    public MilesmateProtocolDecoder(Protocol protocol) {
        super(protocol);
    }

    @Override
    protected Object decode(Channel channel, SocketAddress remoteAddress, Object msg) throws Exception {
        DeviceSession deviceSession;
        Parser parser = new Parser(PATTERN, (String)msg);
        if (!parser.matches()) {
            return null;
        }
        if (channel != null) {
            channel.writeAndFlush((Object)new NetworkMessage("+##Received OK\n", remoteAddress));
        }
        if ((deviceSession = this.getDeviceSession(channel, remoteAddress, parser.next())) == null) {
            return null;
        }
        Position position = new Position(this.getProtocolName());
        position.setDeviceId(deviceSession.getDeviceId());
        position.set("battery", parser.nextDouble());
        position.set("adc1", parser.nextDouble());
        DateBuilder dateBuilder = new DateBuilder().setTime(parser.nextInt(), parser.nextInt(), parser.nextInt());
        position.setLatitude(parser.nextCoordinate());
        position.setLongitude(parser.nextCoordinate());
        position.setSpeed(UnitsConverter.knotsFromKph(parser.nextDouble()));
        dateBuilder.setDateReverse(parser.nextInt(), parser.nextInt(), parser.nextInt());
        position.setTime(dateBuilder.getDate());
        String flags = parser.next();
        position.set("ignition", flags.charAt(0) == '1');
        position.addAlarm(flags.charAt(1) == '1' ? "sos" : null);
        position.set("charge", flags.charAt(5) == '1');
        position.addAlarm(flags.charAt(7) == '1' ? "overspeed" : null);
        flags = parser.next();
        position.set("blocked", flags.charAt(0) == '1');
        position.addAlarm(flags.charAt(1) == '1' ? "tow" : null);
        position.setValid(parser.next().equals("A"));
        position.setCourse(parser.nextDouble());
        return position;
    }
}

