/*
 * Decompiled with CFR 0.152.
 */
package org.traccar.protocol;

import io.netty.channel.Channel;
import java.net.SocketAddress;
import java.util.Date;
import java.util.LinkedList;
import java.util.regex.Pattern;
import org.traccar.BaseProtocolDecoder;
import org.traccar.NetworkMessage;
import org.traccar.Protocol;
import org.traccar.helper.DateBuilder;
import org.traccar.helper.Parser;
import org.traccar.helper.PatternBuilder;
import org.traccar.model.Position;
import org.traccar.session.DeviceSession;

public class RaceDynamicsProtocolDecoder
extends BaseProtocolDecoder {
    public static final int MSG_LOGIN = 12;
    public static final int MSG_LOCATION = 15;
    private static final Pattern PATTERN_LOGIN = new PatternBuilder().text("$GPRMC,").number("d+,").number("d{6},").number("d{6},").number("(d{15}),").compile();
    private static final Pattern PATTERN_LOCATION = new PatternBuilder().number("(dd)(dd)(dd),").expression("([AV]),").number("(dd)(dd.d+),").expression("([NS]),").number("(ddd)(dd.d+),").expression("([EW]),").number("(d+),").number("(dd)(dd)(dd),").number("(-?d+),").number("(d+),").number("([01]),").number("(d+),").text("%,").number("([^,]+),").number("d+,").number("d+,").number("[01],").number("[01],").number("[01],").number("(d+),").number("[01],").number("(d+),").number("([01]),").number("d+,").number("d+,").number("(d),").number("d+,").number("d+,").number("d+,d+,d+,").number("d+,").number("d+,").number("d+,").number("(d),").any().compile();
    private String imei;

    public RaceDynamicsProtocolDecoder(Protocol protocol) {
        super(protocol);
    }

    private void sendResponse(Channel channel, SocketAddress remoteAddress, int type) {
        if (channel != null) {
            String response = String.format("$GPRMC,%1$d,%2$td%2$tm%2$ty,%2$tH%2$tM%2$tS,%3$s,\r\n", type, new Date(), this.imei);
            channel.writeAndFlush((Object)new NetworkMessage(response, remoteAddress));
        }
    }

    @Override
    protected Object decode(Channel channel, SocketAddress remoteAddress, Object msg) throws Exception {
        String sentence = (String)msg;
        int type = Integer.parseInt(sentence.substring(7, 9));
        if (type == 12) {
            Parser parser = new Parser(PATTERN_LOGIN, sentence);
            if (parser.matches()) {
                this.imei = parser.next();
                this.getDeviceSession(channel, remoteAddress, this.imei);
                this.sendResponse(channel, remoteAddress, type);
            }
        } else if (type == 15) {
            DeviceSession deviceSession = this.getDeviceSession(channel, remoteAddress, new String[0]);
            if (deviceSession == null) {
                return null;
            }
            LinkedList<Position> positions = new LinkedList<Position>();
            for (String data : sentence.substring(17, sentence.length() - 3).split(",#,#,")) {
                Parser parser = new Parser(PATTERN_LOCATION, data);
                if (!parser.matches()) continue;
                Position position = new Position(this.getProtocolName());
                position.setDeviceId(deviceSession.getDeviceId());
                DateBuilder dateBuilder = new DateBuilder().setTime(parser.nextInt(), parser.nextInt(), parser.nextInt());
                position.setValid(parser.next().equals("A"));
                position.setLatitude(parser.nextCoordinate());
                position.setLongitude(parser.nextCoordinate());
                position.setSpeed(parser.nextDouble());
                dateBuilder.setDateReverse(parser.nextInt(), parser.nextInt(), parser.nextInt());
                position.setTime(dateBuilder.getDate());
                position.setAltitude(parser.nextInt().intValue());
                position.set("sat", parser.nextInt());
                position.set("ignition", parser.nextInt() == 1);
                position.set("index", parser.nextInt());
                position.set("driverUniqueId", parser.next());
                position.set("power", (double)parser.nextInt().intValue() * 0.01);
                position.set("battery", (double)parser.nextInt().intValue() * 0.01);
                position.addAlarm(parser.nextInt() > 0 ? "sos" : null);
                position.addAlarm(parser.nextInt() > 0 ? "overspeed" : null);
                int overDriver = parser.nextInt();
                if (overDriver > 0) {
                    position.set("overDriver", overDriver);
                }
                positions.add(position);
            }
            this.sendResponse(channel, remoteAddress, type);
            return positions;
        }
        return null;
    }
}

