/*
 * Decompiled with CFR 0.152.
 */
package ca.sqlpower.sqlobject.generated;

import ca.sqlpower.dao.PersistedSPOProperty;
import ca.sqlpower.dao.PersistedSPObject;
import ca.sqlpower.dao.SPPersistenceException;
import ca.sqlpower.dao.SPPersister;
import ca.sqlpower.dao.session.SessionPersisterSuperConverter;
import ca.sqlpower.object.SPObject;
import ca.sqlpower.sqlobject.SQLObject;
import ca.sqlpower.sqlobject.SQLSchema;
import ca.sqlpower.sqlobject.generated.SQLObjectPersisterHelper;
import com.google.common.collect.Multimap;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;

public class SQLSchemaPersisterHelper
extends SQLObjectPersisterHelper<SQLSchema> {
    @Override
    public SQLSchema commitObject(PersistedSPObject pso, Multimap<String, PersistedSPOProperty> persistedProperties, List<PersistedSPObject> persistedObjects, SessionPersisterSuperConverter converter) throws SPPersistenceException {
        SQLSchema o;
        String uuid = pso.getUUID();
        SQLObject parent = (SQLObject)converter.convertToComplexType(SQLSchemaPersisterHelper.findPropertyAndRemove(uuid, "parent", persistedProperties), SQLObject.class);
        String name = (String)converter.convertToComplexType(SQLSchemaPersisterHelper.findPropertyAndRemove(uuid, "name", persistedProperties), String.class);
        Boolean populated = (Boolean)converter.convertToComplexType(SQLSchemaPersisterHelper.findPropertyAndRemove(uuid, "populated", persistedProperties), Boolean.class);
        try {
            o = new SQLSchema(parent, name, populated);
        }
        catch (Exception e) {
            throw new SPPersistenceException(null, e);
        }
        o.setUUID(uuid);
        pso.setLoaded(true);
        return o;
    }

    @Override
    public void commitProperty(SPObject o, String propertyName, Object newValue, SPPersister.DataType dataType, SessionPersisterSuperConverter converter) throws SPPersistenceException {
        SQLSchema castedObject = (SQLSchema)o;
        if (propertyName.equals("parent")) {
            castedObject.setParent((SQLObject)converter.convertToComplexType(newValue, SQLObject.class));
        } else if (propertyName.equals("nativeTerm")) {
            castedObject.setNativeTerm((String)converter.convertToComplexType(newValue, String.class));
        } else {
            super.commitProperty(o, propertyName, newValue, dataType, converter);
        }
    }

    @Override
    public Object findProperty(SPObject o, String propertyName, SessionPersisterSuperConverter converter) throws SPPersistenceException {
        SQLSchema castedObject = (SQLSchema)o;
        if (propertyName.equals("parent")) {
            return converter.convertToBasicType(castedObject.getParent(), new Object[0]);
        }
        if (propertyName.equals("nativeTerm")) {
            return converter.convertToBasicType(castedObject.getNativeTerm(), new Object[0]);
        }
        return super.findProperty(o, propertyName, converter);
    }

    @Override
    public void persistObject(SPObject o, int index, SPPersister persister, SessionPersisterSuperConverter converter) throws SPPersistenceException {
        SQLSchema castedObject = (SQLSchema)o;
        String uuid = castedObject.getUUID();
        String parentUUID = null;
        if (castedObject.getParent() != null) {
            parentUUID = castedObject.getParent().getUUID();
        }
        persister.persistObject(parentUUID, "ca.sqlpower.sqlobject.SQLSchema", uuid, index);
        ArrayList<String> preProcessedProperties = new ArrayList<String>();
        try {
            SPPersister.DataType dataType = SPPersister.DataType.REFERENCE;
            persister.persistProperty(uuid, "parent", dataType, converter.convertToBasicType(castedObject.getParent(), new Object[0]));
            preProcessedProperties.add("parent");
            dataType = SPPersister.DataType.STRING;
            persister.persistProperty(uuid, "name", dataType, converter.convertToBasicType(castedObject.getName(), new Object[0]));
            preProcessedProperties.add("name");
            dataType = SPPersister.DataType.BOOLEAN;
            persister.persistProperty(uuid, "populated", dataType, converter.convertToBasicType(castedObject.isPopulated(), new Object[0]));
            preProcessedProperties.add("populated");
            this.persistObjectProperties(o, persister, converter, preProcessedProperties);
        }
        catch (Exception e) {
            throw new SPPersistenceException(uuid, e);
        }
    }

    @Override
    public void persistObjectProperties(SPObject o, SPPersister persister, SessionPersisterSuperConverter converter, List<String> staticPreProcessedProps) throws SPPersistenceException {
        ArrayList<String> preProcessedProps = new ArrayList<String>(staticPreProcessedProps);
        String uuid = o.getUUID();
        SQLSchema castedObject = (SQLSchema)o;
        try {
            SPPersister.DataType dataType;
            if (!preProcessedProps.contains("parent")) {
                dataType = SPPersister.DataType.REFERENCE;
                persister.persistProperty(uuid, "parent", dataType, converter.convertToBasicType(castedObject.getParent(), new Object[0]));
                preProcessedProps.add("parent");
            }
            if (!preProcessedProps.contains("nativeTerm")) {
                dataType = SPPersister.DataType.STRING;
                persister.persistProperty(uuid, "nativeTerm", dataType, converter.convertToBasicType(castedObject.getNativeTerm(), new Object[0]));
                preProcessedProps.add("nativeTerm");
            }
        }
        catch (Exception e) {
            throw new SPPersistenceException(uuid, e);
        }
        super.persistObjectProperties(o, persister, converter, preProcessedProps);
    }

    @Override
    public List<String> getPersistedProperties() throws SPPersistenceException {
        String[] persistedPropertiesArray = new String[]{"parent", "nativeTerm"};
        ArrayList<String> persistedPropertiesList = new ArrayList<String>(Arrays.asList(persistedPropertiesArray));
        persistedPropertiesList.addAll(super.getPersistedProperties());
        return persistedPropertiesList;
    }
}

