/*
 * Decompiled with CFR 0.152.
 */
package ua_parser;

import java.io.InputStream;
import java.util.Map;
import org.apache.commons.collections4.map.LRUMap;
import ua_parser.Client;
import ua_parser.Device;
import ua_parser.OS;
import ua_parser.Parser;
import ua_parser.UserAgent;

public class CachingParser
extends Parser {
    private static final String INVALID_CACHE_SIZE_ERROR_MESSAGE = "Invalid cache size provided - Should be greater than 0";
    private int cacheSize = 1000;
    private Map<String, Client> cacheClient = null;
    private Map<String, UserAgent> cacheUserAgent = null;
    private Map<String, Device> cacheDevice = null;
    private Map<String, OS> cacheOS = null;

    public CachingParser() {
    }

    public CachingParser(InputStream regexYaml) {
        super(regexYaml);
    }

    public CachingParser(int cacheSize) {
        assert (cacheSize > 0) : "Invalid cache size provided - Should be greater than 0";
        this.cacheSize = cacheSize;
    }

    public CachingParser(InputStream regexYaml, int cacheSize) {
        super(regexYaml);
        assert (cacheSize > 0) : "Invalid cache size provided - Should be greater than 0";
        this.cacheSize = cacheSize;
    }

    @Override
    public Client parse(String agentString) {
        Client client;
        if (agentString == null) {
            return null;
        }
        if (this.cacheClient == null) {
            this.cacheClient = new LRUMap(this.cacheSize);
        }
        if ((client = this.cacheClient.get(agentString)) != null) {
            return client;
        }
        client = super.parse(agentString);
        this.cacheClient.put(agentString, client);
        return client;
    }

    @Override
    public UserAgent parseUserAgent(String agentString) {
        UserAgent userAgent;
        if (agentString == null) {
            return null;
        }
        if (this.cacheUserAgent == null) {
            this.cacheUserAgent = new LRUMap(this.cacheSize);
        }
        if ((userAgent = this.cacheUserAgent.get(agentString)) != null) {
            return userAgent;
        }
        userAgent = super.parseUserAgent(agentString);
        this.cacheUserAgent.put(agentString, userAgent);
        return userAgent;
    }

    @Override
    public Device parseDevice(String agentString) {
        Device device;
        if (agentString == null) {
            return null;
        }
        if (this.cacheDevice == null) {
            this.cacheDevice = new LRUMap(this.cacheSize);
        }
        if ((device = this.cacheDevice.get(agentString)) != null) {
            return device;
        }
        device = super.parseDevice(agentString);
        this.cacheDevice.put(agentString, device);
        return device;
    }

    @Override
    public OS parseOS(String agentString) {
        OS os;
        if (agentString == null) {
            return null;
        }
        if (this.cacheOS == null) {
            this.cacheOS = new LRUMap(this.cacheSize);
        }
        if ((os = this.cacheOS.get(agentString)) != null) {
            return os;
        }
        os = super.parseOS(agentString);
        this.cacheOS.put(agentString, os);
        return os;
    }
}

