/*
 * Decompiled with CFR 0.152.
 */
package org.wildfly.security.sasl.util;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Iterator;
import java.util.Map;
import javax.security.auth.callback.Callback;
import javax.security.auth.callback.CallbackHandler;
import javax.security.sasl.SaslException;
import javax.security.sasl.SaslServer;
import javax.security.sasl.SaslServerFactory;
import org.wildfly.common.Assert;
import org.wildfly.common.iteration.CodePointIterator;
import org.wildfly.security.auth.callback.AvailableRealmsCallback;
import org.wildfly.security.sasl.util.AbstractDelegatingSaslServerFactory;

public final class AvailableRealmsSaslServerFactory
extends AbstractDelegatingSaslServerFactory {
    public static final int DEFAULT_DELIMITER = 32;
    public static final int DEFAULT_ESCAPE_CHARACTER = 92;
    private final int escapeCharacter;
    private final int[] delims;

    public AvailableRealmsSaslServerFactory(SaslServerFactory delegate) {
        this(delegate, 92, 32);
    }

    public AvailableRealmsSaslServerFactory(SaslServerFactory delegate, int escapeCharacter, int ... delims) {
        super(delegate);
        this.escapeCharacter = (Integer)Assert.checkNotNullParam((String)"escapeCharacter", (Object)escapeCharacter);
        this.delims = (int[])Assert.checkNotNullParam((String)"delims", (Object)delims);
    }

    @Override
    public SaslServer createSaslServer(String mechanism, String protocol, String serverName, Map<String, ?> props, CallbackHandler cbh) throws SaslException {
        String realmList = (String)props.get("com.sun.security.sasl.digest.realm");
        if (realmList == null) {
            return this.delegate.createSaslServer(mechanism, protocol, serverName, props, cbh);
        }
        return this.delegate.createSaslServer(mechanism, protocol, serverName, props, callbacks -> {
            ArrayList<Callback> list = new ArrayList<Callback>(Arrays.asList(callbacks));
            Iterator<Callback> iterator = list.iterator();
            while (iterator.hasNext()) {
                Callback callback = iterator.next();
                if (!(callback instanceof AvailableRealmsCallback)) continue;
                String[] realms = AvailableRealmsSaslServerFactory.realmListPropertyToArray(realmList, this.escapeCharacter, this.delims);
                ((AvailableRealmsCallback)callback).setRealmNames(realms);
                iterator.remove();
            }
            if (!list.isEmpty()) {
                cbh.handle(list.toArray(new Callback[list.size()]));
            }
        });
    }

    static String[] realmListPropertyToArray(String realmList) {
        return AvailableRealmsSaslServerFactory.realmListPropertyToArray(realmList, 92, 32);
    }

    static String[] realmListPropertyToArray(String realmList, int escapeCharacter, int ... delims) {
        if (realmList == null) {
            return null;
        }
        int[] escapeCharacterAndDelims = Arrays.copyOf(delims, delims.length + 1);
        escapeCharacterAndDelims[escapeCharacterAndDelims.length - 1] = escapeCharacter;
        CodePointIterator cpi = CodePointIterator.ofString((String)realmList);
        CodePointIterator di = cpi.delimitedBy(escapeCharacterAndDelims);
        ArrayList<String> realms = new ArrayList<String>();
        StringBuilder realm = new StringBuilder();
        while (cpi.hasNext()) {
            if (di.hasNext()) {
                di.drainTo(realm);
                continue;
            }
            if (cpi.peekNext() == escapeCharacter) {
                cpi.next();
                if (!cpi.hasNext()) continue;
                realm.append((char)cpi.next());
                continue;
            }
            realms.add(realm.toString());
            AvailableRealmsSaslServerFactory.skipDelims(di, cpi, delims);
            realm = new StringBuilder();
        }
        realms.add(realm.toString());
        return realms.toArray(new String[realms.size()]);
    }

    private static boolean isDelim(int c, int ... delims) {
        for (int delim : delims) {
            if (delim != c) continue;
            return true;
        }
        return false;
    }

    private static void skipDelims(CodePointIterator di, CodePointIterator cpi, int ... delims) {
        while (!di.hasNext() && cpi.hasNext() && AvailableRealmsSaslServerFactory.isDelim(cpi.peekNext(), delims)) {
            cpi.next();
        }
    }
}

