/*
 * Decompiled with CFR 0.152.
 */
package org.openhab.core.io.websocket;

import java.io.IOException;
import java.util.Base64;
import java.util.HashMap;
import java.util.Map;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import javax.servlet.Servlet;
import javax.servlet.ServletException;
import javax.ws.rs.core.SecurityContext;
import org.eclipse.jdt.annotation.NonNullByDefault;
import org.eclipse.jdt.annotation.Nullable;
import org.eclipse.jetty.websocket.server.WebSocketServerFactory;
import org.eclipse.jetty.websocket.servlet.ServletUpgradeRequest;
import org.eclipse.jetty.websocket.servlet.ServletUpgradeResponse;
import org.eclipse.jetty.websocket.servlet.WebSocketCreator;
import org.eclipse.jetty.websocket.servlet.WebSocketServlet;
import org.eclipse.jetty.websocket.servlet.WebSocketServletFactory;
import org.openhab.core.auth.AuthenticationException;
import org.openhab.core.io.rest.auth.AuthFilter;
import org.openhab.core.io.websocket.WebSocketAdapter;
import org.osgi.service.component.annotations.Activate;
import org.osgi.service.component.annotations.Component;
import org.osgi.service.component.annotations.Reference;
import org.osgi.service.component.annotations.ReferenceCardinality;
import org.osgi.service.component.annotations.ReferencePolicy;
import org.osgi.service.http.NamespaceException;
import org.osgi.service.http.whiteboard.propertytypes.HttpWhiteboardServletName;
import org.osgi.service.http.whiteboard.propertytypes.HttpWhiteboardServletPattern;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@NonNullByDefault
@HttpWhiteboardServletName(value="/ws")
@HttpWhiteboardServletPattern(value={"/ws/*"})
@Component(immediate=true, service={Servlet.class})
public class CommonWebSocketServlet
extends WebSocketServlet {
    private static final long serialVersionUID = 1L;
    public static final String SEC_WEBSOCKET_PROTOCOL_HEADER = "Sec-WebSocket-Protocol";
    public static final String WEBSOCKET_PROTOCOL_DEFAULT = "org.openhab.ws.protocol.default";
    private static final Pattern WEBSOCKET_ACCESS_TOKEN_PATTERN = Pattern.compile("org.openhab.ws.accessToken.base64.(?<base64>[A-Za-z0-9+/]*)");
    public static final String SERVLET_PATH = "/ws";
    public static final String DEFAULT_ADAPTER_ID = "events";
    private final Map<String, WebSocketAdapter> connectionHandlers = new HashMap<String, WebSocketAdapter>();
    private final AuthFilter authFilter;
    private @Nullable WebSocketServerFactory importNeeded;

    @Activate
    public CommonWebSocketServlet(@Reference AuthFilter authFilter) throws ServletException, NamespaceException {
        this.authFilter = authFilter;
    }

    public void configure(@NonNullByDefault(value={}) WebSocketServletFactory webSocketServletFactory) {
        webSocketServletFactory.getPolicy().setIdleTimeout(10000L);
        webSocketServletFactory.setCreator((WebSocketCreator)new CommonWebSocketCreator());
    }

    @Reference(cardinality=ReferenceCardinality.MULTIPLE, policy=ReferencePolicy.DYNAMIC)
    protected void addWebSocketAdapter(WebSocketAdapter wsAdapter) {
        this.connectionHandlers.put(wsAdapter.getId(), wsAdapter);
    }

    protected void removeWebSocketAdapter(WebSocketAdapter wsAdapter) {
        this.connectionHandlers.remove(wsAdapter.getId());
    }

    private class CommonWebSocketCreator
    implements WebSocketCreator {
        private final Logger logger = LoggerFactory.getLogger(CommonWebSocketCreator.class);

        private CommonWebSocketCreator() {
        }

        public @Nullable Object createWebSocket(@Nullable ServletUpgradeRequest servletUpgradeRequest, @Nullable ServletUpgradeResponse servletUpgradeResponse) {
            if (servletUpgradeRequest == null || servletUpgradeResponse == null) {
                return null;
            }
            String accessToken = null;
            String secWebSocketProtocolHeader = servletUpgradeRequest.getHeader(CommonWebSocketServlet.SEC_WEBSOCKET_PROTOCOL_HEADER);
            if (secWebSocketProtocolHeader != null) {
                servletUpgradeResponse.setHeader(CommonWebSocketServlet.SEC_WEBSOCKET_PROTOCOL_HEADER, CommonWebSocketServlet.WEBSOCKET_PROTOCOL_DEFAULT);
                Matcher matcher = WEBSOCKET_ACCESS_TOKEN_PATTERN.matcher(secWebSocketProtocolHeader);
                if (matcher.find() && matcher.group("base64") != null) {
                    String base64 = matcher.group("base64");
                    try {
                        accessToken = new String(Base64.getDecoder().decode(base64));
                    }
                    catch (IllegalArgumentException e) {
                        this.logger.warn("Invalid base64 encoded access token in Sec-WebSocket-Protocol header from {}.", (Object)servletUpgradeRequest.getRemoteAddress());
                        return null;
                    }
                } else {
                    this.logger.warn("Invalid use of Sec-WebSocket-Protocol header from {}.", (Object)servletUpgradeRequest.getRemoteAddress());
                    return null;
                }
            }
            if (accessToken != null ? this.isAuthorizedRequest(accessToken) : this.isAuthorizedRequest(servletUpgradeRequest)) {
                WebSocketAdapter wsAdapter;
                boolean useDefaultAdapter;
                String requestPath = servletUpgradeRequest.getRequestURI().getPath();
                String pathPrefix = "/ws/";
                boolean bl = useDefaultAdapter = requestPath.equals(pathPrefix) || !requestPath.startsWith(pathPrefix);
                if (!useDefaultAdapter) {
                    String adapterId = requestPath.substring(pathPrefix.length());
                    wsAdapter = CommonWebSocketServlet.this.connectionHandlers.get(adapterId);
                    if (wsAdapter == null) {
                        this.logger.warn("Missing WebSocket adapter for path {}", (Object)adapterId);
                        return null;
                    }
                } else {
                    wsAdapter = CommonWebSocketServlet.this.connectionHandlers.get(CommonWebSocketServlet.DEFAULT_ADAPTER_ID);
                    if (wsAdapter == null) {
                        this.logger.warn("Default WebSocket adapter is missing");
                        return null;
                    }
                }
                this.logger.debug("New connection handled by {}", (Object)wsAdapter.getId());
                return wsAdapter.createWebSocket(servletUpgradeRequest, servletUpgradeResponse);
            }
            this.logger.warn("Unauthenticated request to create a websocket from {}.", (Object)servletUpgradeRequest.getRemoteAddress());
            return null;
        }

        private boolean isAuthorizedRequest(String bearerToken) {
            try {
                SecurityContext securityContext = CommonWebSocketServlet.this.authFilter.getSecurityContext(bearerToken);
                return securityContext != null && (securityContext.isUserInRole("user") || securityContext.isUserInRole("administrator"));
            }
            catch (AuthenticationException e) {
                this.logger.warn("Error handling WebSocket authorization", (Throwable)e);
                return false;
            }
        }

        private boolean isAuthorizedRequest(ServletUpgradeRequest servletUpgradeRequest) {
            try {
                SecurityContext securityContext = CommonWebSocketServlet.this.authFilter.getSecurityContext(servletUpgradeRequest.getHttpServletRequest(), true);
                return securityContext != null && (securityContext.isUserInRole("user") || securityContext.isUserInRole("administrator"));
            }
            catch (IOException | AuthenticationException e) {
                this.logger.warn("Error handling WebSocket authorization", e);
                return false;
            }
        }
    }
}

