/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.californium.scandium.dtls;

import org.eclipse.californium.elements.util.DatagramReader;
import org.eclipse.californium.elements.util.DatagramWriter;
import org.eclipse.californium.elements.util.StringUtil;
import org.eclipse.californium.scandium.dtls.AlertMessage;
import org.eclipse.californium.scandium.dtls.CompressionMethod;
import org.eclipse.californium.scandium.dtls.HandshakeException;
import org.eclipse.californium.scandium.dtls.HandshakeMessage;
import org.eclipse.californium.scandium.dtls.HandshakeType;
import org.eclipse.californium.scandium.dtls.HelloHandshakeMessage;
import org.eclipse.californium.scandium.dtls.ProtocolVersion;
import org.eclipse.californium.scandium.dtls.SessionId;
import org.eclipse.californium.scandium.dtls.cipher.CipherSuite;

public final class ServerHello
extends HelloHandshakeMessage {
    private final CipherSuite cipherSuite;
    private final CompressionMethod compressionMethod;

    public ServerHello(ProtocolVersion version, SessionId sessionId, CipherSuite cipherSuite, CompressionMethod compressionMethod) {
        super(version, sessionId);
        if (cipherSuite == null) {
            throw new NullPointerException("Negotiated cipher suite must not be null");
        }
        if (compressionMethod == null) {
            throw new NullPointerException("Negotiated compression method must not be null");
        }
        this.cipherSuite = cipherSuite;
        this.compressionMethod = compressionMethod;
    }

    private ServerHello(DatagramReader reader) throws HandshakeException {
        super(reader);
        int code = reader.read(16);
        this.cipherSuite = CipherSuite.getTypeByCode(code);
        if (this.cipherSuite == null) {
            throw new HandshakeException(String.format("Server selected unknown cipher suite [%s]", Integer.toHexString(code)), new AlertMessage(AlertMessage.AlertLevel.FATAL, AlertMessage.AlertDescription.HANDSHAKE_FAILURE));
        }
        if (!this.cipherSuite.isValidForNegotiation()) {
            throw new HandshakeException("Server tries to negotiate a cipher suite invalid for negotiation", new AlertMessage(AlertMessage.AlertLevel.FATAL, AlertMessage.AlertDescription.HANDSHAKE_FAILURE));
        }
        this.compressionMethod = CompressionMethod.getMethodByCode(reader.read(8));
        this.extensions.readFrom(reader);
    }

    @Override
    public byte[] fragmentToByteArray() {
        DatagramWriter writer = new DatagramWriter();
        this.writeHeader(writer);
        writer.write(this.cipherSuite.getCode(), 16);
        writer.write(this.compressionMethod.getCode(), 8);
        this.extensions.writeTo(writer);
        return writer.toByteArray();
    }

    public static HandshakeMessage fromReader(DatagramReader reader) throws HandshakeException {
        return new ServerHello(reader);
    }

    @Override
    public HandshakeType getMessageType() {
        return HandshakeType.SERVER_HELLO;
    }

    @Override
    public int getMessageLength() {
        return 38 + this.sessionId.length() + this.extensions.getLength();
    }

    public CipherSuite getCipherSuite() {
        return this.cipherSuite;
    }

    public CompressionMethod getCompressionMethod() {
        return this.compressionMethod;
    }

    @Override
    public String toString(int indent) {
        StringBuilder sb = new StringBuilder(super.toString(indent));
        String indentation = StringUtil.indentation((int)(indent + 1));
        sb.append(indentation).append("Cipher Suite: ").append((Object)this.cipherSuite).append(StringUtil.lineSeparator());
        sb.append(indentation).append("Compression Method: ").append((Object)this.compressionMethod).append(StringUtil.lineSeparator());
        sb.append(this.extensions.toString(indent + 1));
        return sb.toString();
    }
}

