/*
 * Decompiled with CFR 0.152.
 */
package org.openhab.core.model.thing.internal.fileconverter;

import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.math.BigDecimal;
import java.util.Collection;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.ConcurrentHashMap;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.jdt.annotation.NonNullByDefault;
import org.eclipse.jdt.annotation.Nullable;
import org.openhab.core.config.core.ConfigDescriptionRegistry;
import org.openhab.core.model.core.ModelRepository;
import org.openhab.core.model.thing.internal.GenericItemChannelLinkProvider;
import org.openhab.core.model.thing.internal.GenericThingProvider;
import org.openhab.core.model.thing.thing.ModelBridge;
import org.openhab.core.model.thing.thing.ModelChannel;
import org.openhab.core.model.thing.thing.ModelProperty;
import org.openhab.core.model.thing.thing.ModelThing;
import org.openhab.core.model.thing.thing.ThingFactory;
import org.openhab.core.model.thing.thing.ThingModel;
import org.openhab.core.thing.Bridge;
import org.openhab.core.thing.Channel;
import org.openhab.core.thing.Thing;
import org.openhab.core.thing.ThingUID;
import org.openhab.core.thing.fileconverter.AbstractThingFileGenerator;
import org.openhab.core.thing.fileconverter.ThingFileGenerator;
import org.openhab.core.thing.fileconverter.ThingFileParser;
import org.openhab.core.thing.link.ItemChannelLink;
import org.openhab.core.thing.type.ChannelKind;
import org.openhab.core.thing.type.ChannelTypeRegistry;
import org.openhab.core.thing.type.ChannelTypeUID;
import org.openhab.core.thing.type.ThingTypeRegistry;
import org.osgi.service.component.annotations.Activate;
import org.osgi.service.component.annotations.Component;
import org.osgi.service.component.annotations.Reference;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@NonNullByDefault
@Component(immediate=true, service={ThingFileGenerator.class, ThingFileParser.class})
public class DslThingFileConverter
extends AbstractThingFileGenerator
implements ThingFileParser {
    private final Logger logger = LoggerFactory.getLogger(DslThingFileConverter.class);
    private final ModelRepository modelRepository;
    private final GenericThingProvider thingProvider;
    private final GenericItemChannelLinkProvider itemChannelLinkProvider;
    private final Map<String, ThingModel> elementsToGenerate = new ConcurrentHashMap<String, ThingModel>();

    @Activate
    public DslThingFileConverter(@Reference ModelRepository modelRepository, @Reference GenericThingProvider thingProvider, @Reference GenericItemChannelLinkProvider itemChannelLinkProvider, @Reference ThingTypeRegistry thingTypeRegistry, @Reference ChannelTypeRegistry channelTypeRegistry, @Reference ConfigDescriptionRegistry configDescRegistry) {
        super(thingTypeRegistry, channelTypeRegistry, configDescRegistry);
        this.modelRepository = modelRepository;
        this.thingProvider = thingProvider;
        this.itemChannelLinkProvider = itemChannelLinkProvider;
    }

    public String getFileFormatGenerator() {
        return "DSL";
    }

    public void setThingsToBeGenerated(String id, List<Thing> things, boolean hideDefaultChannels, boolean hideDefaultParameters) {
        if (things.isEmpty()) {
            return;
        }
        ThingModel model = ThingFactory.eINSTANCE.createThingModel();
        HashSet<Thing> handledThings = new HashSet<Thing>();
        for (Thing thing : things) {
            if (handledThings.contains(thing)) continue;
            model.getThings().add((Object)this.buildModelThing(thing, hideDefaultChannels, hideDefaultParameters, things.size() > 1, true, things, handledThings));
        }
        this.elementsToGenerate.put(id, model);
    }

    public void generateFileFormat(String id, OutputStream out) {
        ThingModel model = this.elementsToGenerate.remove(id);
        if (model != null) {
            ByteArrayOutputStream outputStream = new ByteArrayOutputStream();
            this.modelRepository.generateFileFormat((OutputStream)outputStream, "things", (EObject)model);
            String syntax = new String(outputStream.toByteArray()).replaceAll(":\"([a-zA-Z0-9_][a-zA-Z0-9_-]*)\"", ":$1");
            try {
                out.write(syntax.getBytes());
            }
            catch (IOException e) {
                this.logger.warn("Exception when writing the generated syntax {}", (Object)e.getMessage());
            }
        }
    }

    private ModelThing buildModelThing(Thing thing, boolean hideDefaultChannels, boolean hideDefaultParameters, boolean preferPresentationAsTree, boolean topLevel, List<Thing> onlyThings, Set<Thing> handledThings) {
        ModelThing model;
        ModelBridge modelBridge;
        List childThings = this.getChildThings(thing, onlyThings);
        if (preferPresentationAsTree && thing instanceof Bridge && !childThings.isEmpty()) {
            modelBridge = ThingFactory.eINSTANCE.createModelBridge();
            modelBridge.setBridge(true);
            model = modelBridge;
        } else {
            modelBridge = null;
            model = ThingFactory.eINSTANCE.createModelThing();
        }
        if (!preferPresentationAsTree || topLevel) {
            model.setId(thing.getUID().getAsString());
            ThingUID bridgeUID = thing.getBridgeUID();
            if (bridgeUID != null && modelBridge == null) {
                model.setBridgeUID(bridgeUID.getAsString());
            }
        } else {
            model.setThingTypeId(thing.getThingTypeUID().getId());
            model.setThingId(thing.getUID().getId());
        }
        if (thing.getLabel() != null) {
            model.setLabel(thing.getLabel());
        }
        if (thing.getLocation() != null) {
            model.setLocation(thing.getLocation());
        }
        for (AbstractThingFileGenerator.ConfigParameter param : this.getConfigurationParameters(thing, hideDefaultParameters)) {
            ModelProperty property = this.buildModelProperty(param.name(), param.value());
            if (property == null) continue;
            model.getProperties().add((Object)property);
        }
        if (preferPresentationAsTree && modelBridge != null) {
            modelBridge.setThingsHeader(false);
            for (Thing child : childThings) {
                if (handledThings.contains(child)) continue;
                modelBridge.getThings().add((Object)this.buildModelThing(child, hideDefaultChannels, hideDefaultParameters, true, false, onlyThings, handledThings));
            }
        }
        List channels = hideDefaultChannels ? this.getNonDefaultChannels(thing) : thing.getChannels();
        model.setChannelsHeader(!channels.isEmpty());
        for (Channel channel : channels) {
            model.getChannels().add((Object)this.buildModelChannel(channel, hideDefaultParameters));
        }
        handledThings.add(thing);
        return model;
    }

    private ModelChannel buildModelChannel(Channel channel, boolean hideDefaultParameters) {
        ModelChannel modelChannel = ThingFactory.eINSTANCE.createModelChannel();
        ChannelTypeUID channelTypeUID = channel.getChannelTypeUID();
        if (channelTypeUID != null) {
            modelChannel.setChannelType(channelTypeUID.getId());
        } else {
            modelChannel.setChannelKind(channel.getKind() == ChannelKind.STATE ? "State" : "Trigger");
            modelChannel.setType(channel.getAcceptedItemType());
        }
        modelChannel.setId(channel.getUID().getId());
        if (channel.getLabel() != null) {
            modelChannel.setLabel(channel.getLabel());
        }
        for (AbstractThingFileGenerator.ConfigParameter param : this.getConfigurationParameters(channel, hideDefaultParameters)) {
            ModelProperty property = this.buildModelProperty(param.name(), param.value());
            if (property == null) continue;
            modelChannel.getProperties().add((Object)property);
        }
        return modelChannel;
    }

    private @Nullable ModelProperty buildModelProperty(String key, Object value) {
        ModelProperty property = ThingFactory.eINSTANCE.createModelProperty();
        property.setKey(key);
        if (value instanceof List) {
            List list = (List)value;
            if (!list.isEmpty()) {
                property.getValue().addAll((Collection)list);
            } else {
                property = null;
            }
        } else if (value instanceof Double) {
            Double doubleValue = (Double)value;
            this.logger.debug("Configuration parameter {} with value {} is provided unexpectedly as Double type", (Object)key, value);
            property.getValue().add((Object)BigDecimal.valueOf(doubleValue));
        } else {
            property.getValue().add(value);
        }
        return property;
    }

    public String getFileFormatParser() {
        return "DSL";
    }

    public @Nullable String startParsingFileFormat(String syntax, List<String> errors, List<String> warnings) {
        ByteArrayInputStream inputStream = new ByteArrayInputStream(syntax.getBytes());
        return this.modelRepository.createIsolatedModel("things", (InputStream)inputStream, errors, warnings);
    }

    public Collection<Thing> getParsedThings(String modelName) {
        return this.thingProvider.getAllFromModel(modelName);
    }

    public Collection<ItemChannelLink> getParsedChannelLinks(String modelName) {
        return this.itemChannelLinkProvider.getAllFromContext(modelName);
    }

    public void finishParsingFileFormat(String modelName) {
        this.modelRepository.removeModel(modelName);
    }
}

