/*
 * Decompiled with CFR 0.152.
 */
package ca.sqlpower.sqlobject;

import ca.sqlpower.object.SPObject;
import ca.sqlpower.object.annotation.Accessor;
import ca.sqlpower.object.annotation.Constructor;
import ca.sqlpower.object.annotation.ConstructorParameter;
import ca.sqlpower.object.annotation.Mutator;
import ca.sqlpower.object.annotation.Transient;
import ca.sqlpower.sqlobject.SQLCatalog;
import ca.sqlpower.sqlobject.SQLDatabase;
import ca.sqlpower.sqlobject.SQLObject;
import ca.sqlpower.sqlobject.SQLObjectException;
import ca.sqlpower.sqlobject.SQLTable;
import ca.sqlpower.util.SQLPowerUtils;
import java.sql.Connection;
import java.sql.DatabaseMetaData;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import org.apache.log4j.Logger;

public class SQLSchema
extends SQLObject {
    public static final List<Class<? extends SPObject>> allowedChildTypes = Collections.singletonList(SQLTable.class);
    private static final Logger logger = Logger.getLogger(SQLSchema.class);
    private final List<SQLTable> tables = new ArrayList<SQLTable>();
    protected String nativeTerm;

    public static List<SQLSchema> fetchSchemas(DatabaseMetaData dbmd, String catalogName) throws SQLObjectException {
        ResultSet rs = null;
        String oldCatalog = null;
        try {
            if (catalogName != null) {
                oldCatalog = dbmd.getConnection().getCatalog();
                try {
                    dbmd.getConnection().setCatalog(catalogName);
                }
                catch (SQLException ex) {
                    logger.info((Object)("populate: Could not setCatalog(" + catalogName + "). Assuming it's a permission problem.  Stack trace:"), (Throwable)ex);
                    List<SQLSchema> list = Collections.emptyList();
                    try {
                        if (rs != null) {
                            rs.close();
                        }
                    }
                    catch (SQLException e) {
                        logger.warn((Object)"Couldn't close result set. Squishing this exception:", (Throwable)e);
                    }
                    try {
                        if (oldCatalog != null) {
                            dbmd.getConnection().setCatalog(oldCatalog);
                        }
                    }
                    catch (SQLException e) {
                        logger.warn((Object)("Couldn't set catalog back to '" + oldCatalog + "'. Squishing this exception:"), (Throwable)e);
                    }
                    return list;
                }
            }
            ArrayList<SQLSchema> schemas = new ArrayList<SQLSchema>();
            rs = dbmd.getSchemas();
            while (rs.next()) {
                String schemaName = rs.getString(1);
                if (schemaName == null) continue;
                SQLSchema schema = new SQLSchema(null, schemaName, false);
                schema.setNativeTerm(dbmd.getSchemaTerm());
                logger.debug((Object)("Set schema term to " + schema.getNativeTerm()));
                schemas.add(schema);
            }
            ArrayList<SQLSchema> arrayList = schemas;
            return arrayList;
        }
        catch (SQLException ex) {
            throw new SQLObjectException("Failed to get schema names from source database", ex);
        }
        finally {
            try {
                if (rs != null) {
                    rs.close();
                }
            }
            catch (SQLException e) {
                logger.warn((Object)"Couldn't close result set. Squishing this exception:", (Throwable)e);
            }
            try {
                if (oldCatalog != null) {
                    dbmd.getConnection().setCatalog(oldCatalog);
                }
            }
            catch (SQLException e) {
                logger.warn((Object)("Couldn't set catalog back to '" + oldCatalog + "'. Squishing this exception:"), (Throwable)e);
            }
        }
    }

    public SQLSchema(boolean populated) {
        this(null, null, populated);
    }

    @Constructor
    public SQLSchema(@ConstructorParameter(propertyName="parent") SQLObject parent, @ConstructorParameter(propertyName="name") String name, @ConstructorParameter(propertyName="populated") boolean populated) {
        if (parent != null && !(parent instanceof SQLCatalog) && !(parent instanceof SQLDatabase)) {
            throw new IllegalArgumentException("Parent to SQLSchema must be SQLCatalog or SQLDatabase");
        }
        this.setParent(parent);
        this.setName(name);
        this.nativeTerm = "schema";
        this.populated = populated;
    }

    @Override
    public void updateToMatch(SQLObject source) throws SQLObjectException {
        SQLSchema s = (SQLSchema)source;
        this.setName(s.getName());
        this.setNativeTerm(s.getNativeTerm());
        this.setPhysicalName(s.getPhysicalName());
    }

    public SQLTable findTableByName(String tableName) throws SQLObjectException {
        this.populate();
        for (SQLTable child : this.tables) {
            logger.debug((Object)("getTableByName: is child '" + child.getName() + "' equal to '" + tableName + "'?"));
            if (!child.getName().equalsIgnoreCase(tableName)) continue;
            return child;
        }
        return null;
    }

    @Override
    public String toString() {
        return this.getShortDisplayName();
    }

    @Transient
    @Accessor
    public boolean isParentTypeDatabase() {
        return this.getParent() instanceof SQLDatabase;
    }

    @Override
    @Transient
    @Accessor
    public String getShortDisplayName() {
        return this.getName();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    protected void populateImpl() throws SQLObjectException {
        List<SQLTable> fetchedTables;
        if (this.populated) {
            return;
        }
        logger.debug((Object)"SQLSchema: populate starting");
        SQLDatabase parentDatabase = SQLPowerUtils.getAncestor(this, SQLDatabase.class);
        if (parentDatabase == null) {
            throw new IllegalStateException("Schema does not have a SQLDatabase ancestor. Can't populate.");
        }
        Connection con = null;
        ResultSet rs = null;
        try {
            SQLDatabase sQLDatabase = parentDatabase;
            synchronized (sQLDatabase) {
                con = parentDatabase.getConnection();
                DatabaseMetaData dbmd = con.getMetaData();
                if (this.getParent() instanceof SQLDatabase) {
                    fetchedTables = SQLTable.fetchTablesForTableContainer(dbmd, null, this.getName());
                } else if (this.getParent() instanceof SQLCatalog) {
                    fetchedTables = SQLTable.fetchTablesForTableContainer(dbmd, this.getParent().getName(), this.getName());
                } else {
                    throw new RuntimeException("Invalid parent " + this.getParent());
                }
            }
        }
        catch (SQLException e) {
            throw new SQLObjectException("schema.populate.fail", e);
        }
        finally {
            try {
                if (rs != null) {
                    rs.close();
                }
            }
            catch (SQLException e2) {
                logger.error((Object)"Could not close result set", (Throwable)e2);
            }
            try {
                if (con != null) {
                    con.close();
                }
            }
            catch (SQLException e2) {
                logger.error((Object)"Could not close connection", (Throwable)e2);
            }
        }
        this.runInForeground(new Runnable(){

            @Override
            public void run() {
                if (SQLSchema.this.populated) {
                    return;
                }
                SQLSchema.populateSchemaWithList(SQLSchema.this, fetchedTables);
            }
        });
        logger.debug((Object)"SQLSchema: populate finished");
    }

    static void populateSchemaWithList(SQLSchema schema, List<SQLTable> children) {
        try {
            for (SQLTable table : children) {
                schema.tables.add(table);
                table.setParent(schema);
            }
            schema.populated = true;
            schema.begin("Populating schema");
            for (SQLTable table : children) {
                schema.fireChildAdded(SQLTable.class, table, schema.tables.indexOf(table));
            }
            schema.firePropertyChange("populated", false, true);
            schema.commit();
        }
        catch (Exception e) {
            schema.rollback(e.getMessage());
            for (SQLTable table : children) {
                schema.tables.remove(table);
            }
            schema.populated = false;
            throw new RuntimeException(e);
        }
    }

    @Accessor(isInteresting=true)
    public String getNativeTerm() {
        return this.nativeTerm;
    }

    @Override
    @Accessor
    public SQLObject getParent() {
        return (SQLObject)super.getParent();
    }

    @Mutator
    public void setParent(SQLObject parent) {
        super.setParent(parent);
    }

    @Mutator
    public void setNativeTerm(String argNativeTerm) {
        String oldValue = this.nativeTerm;
        if (argNativeTerm != null) {
            argNativeTerm = argNativeTerm.toLowerCase();
        }
        this.nativeTerm = argNativeTerm;
        this.firePropertyChange("nativeTerm", oldValue, argNativeTerm);
    }

    public List<SQLTable> getChildrenWithoutPopulating() {
        return Collections.unmodifiableList(new ArrayList<SQLTable>(this.tables));
    }

    @Override
    protected boolean removeChildImpl(SPObject child) {
        if (child instanceof SQLTable) {
            return this.removeTable((SQLTable)child);
        }
        throw new IllegalArgumentException("Cannot remove children of type " + child.getClass() + " from " + this.getName());
    }

    public boolean removeTable(SQLTable table) {
        if (this.isMagicEnabled() && table.getParent() != this) {
            throw new IllegalStateException("Cannot remove child " + table.getName() + " of type " + table.getClass() + " as its parent is not " + this.getName());
        }
        table.removeNotify();
        int index = this.tables.indexOf(table);
        if (index != -1) {
            this.tables.remove(index);
            this.fireChildRemoved(SQLTable.class, table, index);
            table.setParent(null);
            return true;
        }
        return false;
    }

    @Override
    public List<? extends SPObject> getDependencies() {
        return Collections.emptyList();
    }

    @Override
    public void removeDependency(SPObject dependency) {
        for (SQLObject sQLObject : this.getChildren()) {
            sQLObject.removeDependency(dependency);
        }
    }

    @Override
    protected void addChildImpl(SPObject child, int index) {
        if (!(child instanceof SQLTable)) {
            throw new IllegalArgumentException("The child " + child.getName() + " of type " + child.getClass() + " is not a valid child type of " + this.getClass() + ".");
        }
        this.addTable((SQLTable)child, index);
    }

    public void addTable(SQLTable table) {
        this.addTable(table, this.tables.size());
    }

    public void addTable(SQLTable table, int index) {
        this.tables.add(index, table);
        table.setParent(this);
        this.fireChildAdded(SQLTable.class, table, index);
    }

    @Override
    public List<Class<? extends SPObject>> getAllowedChildTypes() {
        return allowedChildTypes;
    }
}

