/*
 * Decompiled with CFR 0.152.
 */
package ca.sqlpower.swingui;

import ca.sqlpower.swingui.Messages;
import ca.sqlpower.swingui.SPSUtils;
import ca.sqlpower.util.UserPrompter;
import com.jgoodies.forms.builder.ButtonBarBuilder;
import com.jgoodies.forms.builder.DefaultFormBuilder;
import com.jgoodies.forms.layout.FormLayout;
import java.awt.Component;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.lang.reflect.InvocationTargetException;
import java.util.List;
import javax.swing.JButton;
import javax.swing.JCheckBox;
import javax.swing.JComboBox;
import javax.swing.JComponent;
import javax.swing.JDialog;
import javax.swing.JFrame;
import javax.swing.JPanel;
import javax.swing.JTextArea;
import javax.swing.SwingUtilities;

public class ModalDialogListUserPrompter<T>
implements UserPrompter {
    private final T defaultResponse;
    private final JFrame parentFrame;
    private JDialog confirmDialog;
    private JCheckBox applyToAll;
    private JTextArea questionField;
    private JComboBox optionBox;
    private T response;
    private UserPrompter.UserPromptResponse responseButton;
    private boolean firstPrompt = true;

    public ModalDialogListUserPrompter(JFrame parentFrame, String question, List<T> responses, T defaultResponse) {
        this.parentFrame = parentFrame;
        this.defaultResponse = defaultResponse;
        this.applyToAll = new JCheckBox(Messages.getString("ModalDialogUserPrompter.applyToAllOption"));
        this.confirmDialog = new JDialog(parentFrame);
        this.confirmDialog.setTitle("");
        this.questionField = new JTextArea(question);
        this.questionField.setEditable(false);
        this.questionField.setBackground(null);
        JPanel confirmPanel = new JPanel();
        FormLayout formLayout = new FormLayout("pref:grow", "");
        this.optionBox = new JComboBox();
        for (T item : responses) {
            this.optionBox.addItem(item);
        }
        this.optionBox.setSelectedItem(defaultResponse);
        DefaultFormBuilder builder = new DefaultFormBuilder(formLayout, confirmPanel);
        builder.setDefaultDialogBorder();
        builder.append((Component)this.questionField);
        builder.nextLine();
        builder.append((Component)this.optionBox);
        builder.nextLine();
        ButtonBarBuilder buttonBar = new ButtonBarBuilder();
        buttonBar.addGlue();
        JButton okButton = new JButton();
        okButton.setText("Ok");
        buttonBar.addGridded((JComponent)okButton);
        buttonBar.addGlue();
        okButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                ModalDialogListUserPrompter.this.responseButton = UserPrompter.UserPromptResponse.OK;
                ModalDialogListUserPrompter.this.response = ModalDialogListUserPrompter.this.optionBox.getSelectedItem();
                ModalDialogListUserPrompter.this.confirmDialog.dispose();
            }
        });
        builder.append("");
        builder.append((Component)buttonBar.getPanel());
        builder.nextLine();
        builder.append("");
        builder.append((Component)this.applyToAll);
        okButton.requestFocusInWindow();
        this.confirmDialog.setModal(true);
        this.confirmDialog.add(builder.getPanel());
    }

    public T getUserSelectedResponse() {
        return this.response;
    }

    @Override
    public UserPrompter.UserPromptResponse promptUser(Object ... formatArgs) {
        try {
            if (this.applyToAll.isSelected()) {
                return UserPrompter.UserPromptResponse.OK;
            }
            Runnable runner = new Runnable(){

                @Override
                public void run() {
                    if (ModalDialogListUserPrompter.this.firstPrompt) {
                        ModalDialogListUserPrompter.this.confirmDialog.pack();
                        ModalDialogListUserPrompter.this.confirmDialog.setLocationRelativeTo(ModalDialogListUserPrompter.this.parentFrame);
                        ModalDialogListUserPrompter.this.firstPrompt = false;
                    }
                    ModalDialogListUserPrompter.this.confirmDialog.setVisible(true);
                }
            };
            if (SwingUtilities.isEventDispatchThread()) {
                runner.run();
            } else {
                SwingUtilities.invokeAndWait(runner);
            }
        }
        catch (InterruptedException e) {
            SPSUtils.showExceptionDialogNoReport(this.parentFrame, Messages.getString("ModalDialogUserPrompter.showPromptDialogFailed"), e);
        }
        catch (InvocationTargetException e) {
            SPSUtils.showExceptionDialogNoReport(this.parentFrame, Messages.getString("ModalDialogUserPrompter.showPromptDialogFailed"), e);
        }
        return this.responseButton;
    }
}

