/*
 * Decompiled with CFR 0.152.
 */
package dotty.tools.dotc.util;

import dotty.tools.dotc.util.PerfectHashing$;
import scala.Array$;
import scala.Predef$;
import scala.collection.ArrayOps$;
import scala.collection.Iterator;
import scala.runtime.RichInt$;

public class PerfectHashing<Key> {
    private final int initialCapacity;
    private final int capacityMultiple;
    private int used;
    private int[] table;
    private Object[] keys;

    public static <Key> int $lessinit$greater$default$1() {
        return PerfectHashing$.MODULE$.$lessinit$greater$default$1();
    }

    public static <Key> int $lessinit$greater$default$2() {
        return PerfectHashing$.MODULE$.$lessinit$greater$default$2();
    }

    public PerfectHashing(int initialCapacity, int capacityMultiple) {
        this.initialCapacity = initialCapacity;
        this.capacityMultiple = capacityMultiple;
        this.clear();
    }

    public void allocate(int capacity) {
        this.keys = new Object[capacity];
        if (!this.isDense()) {
            this.table = new int[capacity * this.roundToPower(this.capacityMultiple)];
            return;
        }
    }

    private int roundToPower(int n) {
        if (Integer.bitCount(n) == 1) {
            return n;
        }
        return 1 << 32 - Integer.numberOfLeadingZeros(n);
    }

    public void clear() {
        this.used = 0;
        this.allocate(this.roundToPower(RichInt$.MODULE$.max$extension(Predef$.MODULE$.intWrapper(this.initialCapacity), 4)));
    }

    public final int size() {
        return this.used;
    }

    public final int capacity() {
        return this.keys.length;
    }

    private final boolean isDense() {
        return this.capacity() <= 16;
    }

    public int hash(Key k) {
        int h = k.hashCode();
        int i = (h ^ h >>> 16) * -2048144789;
        int j = (i ^ i >>> 13) & Integer.MAX_VALUE;
        if (j == 0) {
            return 1091049865;
        }
        return j;
    }

    public boolean isEqual(Key x, Key y) {
        return x.equals(y);
    }

    private boolean matches(int entry, Key k) {
        return this.isEqual(this.key(entry), k);
    }

    private int tableIndex(int x) {
        return x & this.table.length - 1;
    }

    private int firstIndex(Key k) {
        return this.tableIndex(this.hash(k));
    }

    private int nextIndex(int idx) {
        return this.tableIndex(idx + 1);
    }

    public Key key(int idx) {
        return (Key)this.keys[idx];
    }

    private void setKey(int e, Key k) {
        this.keys[e] = k;
    }

    private int entry(int idx) {
        return this.table[idx] - 1;
    }

    private void setEntry(int idx, int entry) {
        this.table[idx] = entry + 1;
    }

    public int index(Key k) {
        if (this.isDense()) {
            for (int e = 0; e < this.used; ++e) {
                if (!this.matches(e, k)) continue;
                return e;
            }
            return -1;
        }
        int idx = this.firstIndex(k);
        int e = this.entry(idx);
        while (e >= 0 && !this.matches(e, k)) {
            idx = this.nextIndex(idx);
            e = this.entry(idx);
        }
        return e;
    }

    public int add(Key k) {
        if (this.isDense()) {
            for (int e = 0; e < this.used; ++e) {
                if (!this.matches(e, k)) continue;
                return e;
            }
        } else {
            int idx = this.firstIndex(k);
            int e = this.entry(idx);
            while (e >= 0) {
                if (this.matches(e, k)) {
                    return e;
                }
                idx = this.nextIndex(idx);
                e = this.entry(idx);
            }
            this.setEntry(idx, this.used);
        }
        this.setKey(this.used, k);
        ++this.used;
        if (this.used == this.capacity()) {
            this.growTable();
        }
        return this.used - 1;
    }

    private void rehash() {
        for (int e = 0; e < this.used; ++e) {
            int idx = this.firstIndex(this.key(e));
            while (this.entry(idx) >= 0) {
                idx = this.nextIndex(idx);
            }
            this.setEntry(idx, e);
        }
    }

    public void growTable() {
        Object[] oldKeys = this.keys;
        this.allocate(this.capacity() * 2);
        Array$.MODULE$.copy((Object)oldKeys, 0, (Object)this.keys, 0, oldKeys.length);
        if (!this.isDense()) {
            this.rehash();
            return;
        }
    }

    public Iterator<Key> keysIterator() {
        Object object = Predef$.MODULE$.refArrayOps(this.keys);
        return ArrayOps$.MODULE$.iterator$extension(object).take(this.used);
    }
}

