/*
 * Decompiled with CFR 0.152.
 */
package io.opentelemetry.sdk.metrics.internal.exemplar;

import io.opentelemetry.api.common.Attributes;
import io.opentelemetry.context.Context;
import io.opentelemetry.sdk.common.Clock;
import io.opentelemetry.sdk.metrics.data.DoubleExemplarData;
import io.opentelemetry.sdk.metrics.data.ExemplarData;
import io.opentelemetry.sdk.metrics.data.LongExemplarData;
import io.opentelemetry.sdk.metrics.internal.exemplar.ExemplarFilter;
import io.opentelemetry.sdk.metrics.internal.exemplar.FilteredExemplarReservoir;
import io.opentelemetry.sdk.metrics.internal.exemplar.HistogramExemplarReservoir;
import io.opentelemetry.sdk.metrics.internal.exemplar.LongToDoubleExemplarReservoir;
import io.opentelemetry.sdk.metrics.internal.exemplar.NoopExemplarReservoir;
import io.opentelemetry.sdk.metrics.internal.exemplar.RandomFixedSizeExemplarReservoir;
import java.util.List;
import java.util.Random;
import java.util.function.Supplier;

public interface ExemplarReservoir<T extends ExemplarData> {
    public static <T extends ExemplarData> ExemplarReservoir<T> longToDouble(ExemplarReservoir<T> delegate) {
        return new LongToDoubleExemplarReservoir<T>(delegate);
    }

    public static <T extends ExemplarData> ExemplarReservoir<T> filtered(ExemplarFilter filter, ExemplarReservoir<T> original) {
        return new FilteredExemplarReservoir<T>(filter, original);
    }

    public static ExemplarReservoir<DoubleExemplarData> doubleNoSamples() {
        return NoopExemplarReservoir.DOUBLE_INSTANCE;
    }

    public static ExemplarReservoir<LongExemplarData> longNoSamples() {
        return NoopExemplarReservoir.LONG_INSTANCE;
    }

    public static ExemplarReservoir<DoubleExemplarData> doubleFixedSizeReservoir(Clock clock, int size, Supplier<Random> randomSupplier) {
        return RandomFixedSizeExemplarReservoir.createDouble(clock, size, randomSupplier);
    }

    public static ExemplarReservoir<LongExemplarData> longFixedSizeReservoir(Clock clock, int size, Supplier<Random> randomSupplier) {
        return RandomFixedSizeExemplarReservoir.createLong(clock, size, randomSupplier);
    }

    public static ExemplarReservoir<DoubleExemplarData> histogramBucketReservoir(Clock clock, List<Double> boundaries) {
        return new HistogramExemplarReservoir(clock, boundaries);
    }

    public void offerDoubleMeasurement(double var1, Attributes var3, Context var4);

    public void offerLongMeasurement(long var1, Attributes var3, Context var4);

    public List<T> collectAndReset(Attributes var1);
}

