/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jetty.websocket.common;

import java.io.IOException;
import java.io.InputStream;
import java.io.Reader;
import java.lang.annotation.Annotation;
import java.lang.invoke.MethodHandle;
import java.lang.invoke.MethodHandles;
import java.lang.reflect.Method;
import java.lang.reflect.Modifier;
import java.nio.ByteBuffer;
import java.util.Arrays;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import org.eclipse.jetty.util.component.ContainerLifeCycle;
import org.eclipse.jetty.websocket.api.Callback;
import org.eclipse.jetty.websocket.api.Frame;
import org.eclipse.jetty.websocket.api.Session;
import org.eclipse.jetty.websocket.api.WebSocketContainer;
import org.eclipse.jetty.websocket.api.annotations.OnWebSocketClose;
import org.eclipse.jetty.websocket.api.annotations.OnWebSocketError;
import org.eclipse.jetty.websocket.api.annotations.OnWebSocketFrame;
import org.eclipse.jetty.websocket.api.annotations.OnWebSocketMessage;
import org.eclipse.jetty.websocket.api.annotations.OnWebSocketOpen;
import org.eclipse.jetty.websocket.api.annotations.OnWebSocketPing;
import org.eclipse.jetty.websocket.api.annotations.OnWebSocketPong;
import org.eclipse.jetty.websocket.api.annotations.WebSocket;
import org.eclipse.jetty.websocket.api.exceptions.InvalidWebSocketException;
import org.eclipse.jetty.websocket.common.JettyWebSocketFrameHandler;
import org.eclipse.jetty.websocket.common.JettyWebSocketFrameHandlerMetadata;
import org.eclipse.jetty.websocket.common.internal.ByteBufferMessageSink;
import org.eclipse.jetty.websocket.common.internal.PartialByteBufferMessageSink;
import org.eclipse.jetty.websocket.core.WebSocketComponents;
import org.eclipse.jetty.websocket.core.exception.InvalidSignatureException;
import org.eclipse.jetty.websocket.core.messages.InputStreamMessageSink;
import org.eclipse.jetty.websocket.core.messages.PartialStringMessageSink;
import org.eclipse.jetty.websocket.core.messages.ReaderMessageSink;
import org.eclipse.jetty.websocket.core.messages.StringMessageSink;
import org.eclipse.jetty.websocket.core.util.InvokerUtils;
import org.eclipse.jetty.websocket.core.util.MethodHolder;
import org.eclipse.jetty.websocket.core.util.ReflectUtils;

public class JettyWebSocketFrameHandlerFactory
extends ContainerLifeCycle {
    private static final InvokerUtils.Arg[] textCallingArgs = new InvokerUtils.Arg[]{new InvokerUtils.Arg(Session.class), new InvokerUtils.Arg(String.class).required()};
    private static final InvokerUtils.Arg[] binaryBufferCallingArgs = new InvokerUtils.Arg[]{new InvokerUtils.Arg(Session.class), new InvokerUtils.Arg(ByteBuffer.class).required(), new InvokerUtils.Arg(Callback.class).required()};
    private static final InvokerUtils.Arg[] inputStreamCallingArgs = new InvokerUtils.Arg[]{new InvokerUtils.Arg(Session.class), new InvokerUtils.Arg(InputStream.class).required()};
    private static final InvokerUtils.Arg[] readerCallingArgs = new InvokerUtils.Arg[]{new InvokerUtils.Arg(Session.class), new InvokerUtils.Arg(Reader.class).required()};
    private static final InvokerUtils.Arg[] textPartialCallingArgs = new InvokerUtils.Arg[]{new InvokerUtils.Arg(Session.class), new InvokerUtils.Arg(String.class).required(), new InvokerUtils.Arg(Boolean.TYPE).required()};
    private static final InvokerUtils.Arg[] binaryPartialBufferCallingArgs = new InvokerUtils.Arg[]{new InvokerUtils.Arg(Session.class), new InvokerUtils.Arg(ByteBuffer.class).required(), new InvokerUtils.Arg(Boolean.TYPE).required(), new InvokerUtils.Arg(Callback.class).required()};
    private final WebSocketContainer container;
    private final WebSocketComponents components;
    private final Map<Class<?>, JettyWebSocketFrameHandlerMetadata> metadataMap = new ConcurrentHashMap();

    public JettyWebSocketFrameHandlerFactory(WebSocketContainer container, WebSocketComponents components) {
        this.container = container;
        this.components = components;
    }

    public WebSocketComponents getWebSocketComponents() {
        return this.components;
    }

    public JettyWebSocketFrameHandlerMetadata getMetadata(Class<?> endpointClass) {
        JettyWebSocketFrameHandlerMetadata metadata = this.metadataMap.get(endpointClass);
        if (metadata == null) {
            metadata = this.createMetadata(endpointClass);
            this.metadataMap.put(endpointClass, metadata);
        }
        return metadata;
    }

    public JettyWebSocketFrameHandlerMetadata createMetadata(Class<?> endpointClass) {
        if (Session.Listener.class.isAssignableFrom(endpointClass)) {
            return this.createListenerMetadata(endpointClass);
        }
        WebSocket websocket = endpointClass.getAnnotation(WebSocket.class);
        if (websocket != null) {
            return this.createAnnotatedMetadata(websocket, endpointClass);
        }
        throw new InvalidWebSocketException("Unrecognized WebSocket endpoint: " + endpointClass.getName());
    }

    public JettyWebSocketFrameHandler newJettyFrameHandler(Object endpointInstance) {
        JettyWebSocketFrameHandlerMetadata metadata = this.getMetadata(endpointInstance.getClass());
        this.components.getObjectFactory().decorate(endpointInstance);
        return new JettyWebSocketFrameHandler(this.container, endpointInstance, metadata);
    }

    private MethodHolder toMethodHolder(MethodHandles.Lookup lookup, Method method) {
        return MethodHolder.from((MethodHandle)this.toMethodHandle(lookup, method));
    }

    private MethodHandle toMethodHandle(MethodHandles.Lookup lookup, Method method) {
        try {
            return lookup.unreflect(method);
        }
        catch (IllegalAccessException e) {
            throw new RuntimeException("Unable to access method " + String.valueOf(method), e);
        }
    }

    private JettyWebSocketFrameHandlerMetadata createListenerMetadata(Class<?> endpointClass) {
        Method errorMethod;
        Method binaryMethod;
        Method textMethod;
        Method partialBinaryMethod;
        Method partialTextMethod;
        Method pongMethod;
        Method pingMethod;
        Method frameMethod;
        JettyWebSocketFrameHandlerMetadata metadata = new JettyWebSocketFrameHandlerMetadata();
        metadata.setAutoDemand(Session.Listener.AutoDemanding.class.isAssignableFrom(endpointClass));
        MethodHandles.Lookup lookup = JettyWebSocketFrameHandlerFactory.getApplicationMethodHandleLookup(endpointClass);
        Method openMethod = this.findMethod(endpointClass, "onWebSocketOpen", Session.class);
        if (openMethod != null) {
            MethodHolder connectHandle = this.toMethodHolder(lookup, openMethod);
            metadata.setOpenHandle(connectHandle, openMethod);
        }
        if ((frameMethod = this.findMethod(endpointClass, "onWebSocketFrame", Frame.class, Callback.class)) != null) {
            MethodHolder frameHandle = this.toMethodHolder(lookup, frameMethod);
            metadata.setFrameHandle(frameHandle, frameMethod);
        }
        if ((pingMethod = this.findMethod(endpointClass, "onWebSocketPing", ByteBuffer.class)) != null) {
            MethodHolder pingHandle = this.toMethodHolder(lookup, pingMethod);
            metadata.setPingHandle(pingHandle, pingMethod);
        }
        if ((pongMethod = this.findMethod(endpointClass, "onWebSocketPong", ByteBuffer.class)) != null) {
            MethodHolder pongHandle = this.toMethodHolder(lookup, pongMethod);
            metadata.setPongHandle(pongHandle, pongMethod);
        }
        if ((partialTextMethod = this.findMethod(endpointClass, "onWebSocketPartialText", String.class, Boolean.TYPE)) != null) {
            MethodHolder partialTextHandle = this.toMethodHolder(lookup, partialTextMethod);
            metadata.setTextHandle(PartialStringMessageSink.class, partialTextHandle, partialTextMethod);
        }
        if ((partialBinaryMethod = this.findMethod(endpointClass, "onWebSocketPartialBinary", ByteBuffer.class, Boolean.TYPE, Callback.class)) != null) {
            MethodHolder partialBinaryHandle = this.toMethodHolder(lookup, partialBinaryMethod);
            metadata.setBinaryHandle(PartialByteBufferMessageSink.class, partialBinaryHandle, partialBinaryMethod);
        }
        if ((textMethod = this.findMethod(endpointClass, "onWebSocketText", String.class)) != null) {
            MethodHolder textHandle = this.toMethodHolder(lookup, textMethod);
            metadata.setTextHandle(StringMessageSink.class, textHandle, textMethod);
        }
        if ((binaryMethod = this.findMethod(endpointClass, "onWebSocketBinary", ByteBuffer.class, Callback.class)) != null) {
            MethodHolder binaryHandle = this.toMethodHolder(lookup, binaryMethod);
            metadata.setBinaryHandle(ByteBufferMessageSink.class, binaryHandle, binaryMethod);
        }
        if ((errorMethod = this.findMethod(endpointClass, "onWebSocketError", Throwable.class)) != null) {
            MethodHolder errorHandle = this.toMethodHolder(lookup, errorMethod);
            metadata.setErrorHandle(errorHandle, errorMethod);
        }
        Method deprecatedCloseMethod = this.findMethod(endpointClass, "onWebSocketClose", Integer.TYPE, String.class);
        Method closeMethod = this.findMethod(endpointClass, "onWebSocketClose", Integer.TYPE, String.class, Callback.class);
        if (closeMethod != null) {
            if (deprecatedCloseMethod != null) {
                throw new InvalidWebSocketException("Cannot use two versions of onWebSocketClose");
            }
            MethodHolder closeHandle = this.toMethodHolder(lookup, closeMethod);
            metadata.setCloseHandle(closeHandle, closeMethod);
        } else if (deprecatedCloseMethod != null) {
            MethodHandle deprecatedCloseHandle = this.toMethodHandle(lookup, deprecatedCloseMethod);
            deprecatedCloseHandle = MethodHandles.dropArguments(deprecatedCloseHandle, 3, new Class[]{Callback.class});
            CallbackCompletingCloseHolder closeHandle = new CallbackCompletingCloseHolder(MethodHolder.from((MethodHandle)deprecatedCloseHandle));
            metadata.setCloseHandle((MethodHolder)closeHandle, deprecatedCloseMethod);
        }
        return metadata;
    }

    private Method findMethod(Class<?> klass, String name, Class<?> ... parameters) {
        Method method = ReflectUtils.findMethod(klass, (String)name, (Class[])parameters);
        if (method == null) {
            return null;
        }
        if (this.isOverridden(method)) {
            return method;
        }
        return null;
    }

    private boolean isOverridden(Method method) {
        return method.getDeclaringClass() != Session.Listener.class;
    }

    private JettyWebSocketFrameHandlerMetadata createAnnotatedMetadata(WebSocket anno, Class<?> endpointClass) {
        Method[] onMessages;
        InvokerUtils.Arg BUFFER;
        MethodHandle methodHandle;
        InvokerUtils.Arg SESSION;
        JettyWebSocketFrameHandlerMetadata metadata = new JettyWebSocketFrameHandlerMetadata();
        metadata.setAutoDemand(anno.autoDemand());
        MethodHandles.Lookup lookup = JettyWebSocketFrameHandlerFactory.getApplicationMethodHandleLookup(endpointClass);
        Method onmethod = ReflectUtils.findAnnotatedMethod(endpointClass, OnWebSocketOpen.class);
        if (onmethod != null) {
            this.assertSignatureValid(endpointClass, onmethod, OnWebSocketOpen.class);
            SESSION = new InvokerUtils.Arg(Session.class).required();
            MethodHandle methodHandle2 = InvokerUtils.mutatedInvoker((MethodHandles.Lookup)lookup, endpointClass, (Method)onmethod, (InvokerUtils.Arg[])new InvokerUtils.Arg[]{SESSION});
            metadata.setOpenHandle(MethodHolder.from((MethodHandle)methodHandle2), onmethod);
        }
        if ((onmethod = ReflectUtils.findAnnotatedMethod(endpointClass, OnWebSocketClose.class)) != null) {
            this.assertSignatureValid(endpointClass, onmethod, OnWebSocketClose.class);
            SESSION = new InvokerUtils.Arg(Session.class);
            InvokerUtils.Arg STATUS_CODE = new InvokerUtils.Arg(Integer.TYPE);
            InvokerUtils.Arg REASON = new InvokerUtils.Arg(String.class);
            InvokerUtils.Arg CALLBACK = new InvokerUtils.Arg(Callback.class);
            MethodHandle methodHandle3 = InvokerUtils.mutatedInvoker((MethodHandles.Lookup)lookup, endpointClass, (Method)onmethod, (InvokerUtils.Arg[])new InvokerUtils.Arg[]{SESSION, STATUS_CODE, REASON, CALLBACK});
            Object methodHolder = MethodHolder.from((MethodHandle)methodHandle3);
            boolean containsCallback = false;
            for (Class<?> paramType : onmethod.getParameterTypes()) {
                if (!Callback.class.isAssignableFrom(paramType)) continue;
                containsCallback = true;
                break;
            }
            if (!containsCallback) {
                methodHolder = new CallbackCompletingCloseHolder((MethodHolder)methodHolder);
            }
            metadata.setCloseHandle((MethodHolder)methodHolder, onmethod);
        }
        if ((onmethod = ReflectUtils.findAnnotatedMethod(endpointClass, OnWebSocketError.class)) != null) {
            this.assertSignatureValid(endpointClass, onmethod, OnWebSocketError.class);
            SESSION = new InvokerUtils.Arg(Session.class);
            InvokerUtils.Arg CAUSE = new InvokerUtils.Arg(Throwable.class).required();
            methodHandle = InvokerUtils.mutatedInvoker((MethodHandles.Lookup)lookup, endpointClass, (Method)onmethod, (InvokerUtils.Arg[])new InvokerUtils.Arg[]{SESSION, CAUSE});
            metadata.setErrorHandle(MethodHolder.from((MethodHandle)methodHandle), onmethod);
        }
        if ((onmethod = ReflectUtils.findAnnotatedMethod(endpointClass, OnWebSocketFrame.class)) != null) {
            this.assertSignatureValid(endpointClass, onmethod, OnWebSocketFrame.class);
            SESSION = new InvokerUtils.Arg(Session.class);
            InvokerUtils.Arg FRAME = new InvokerUtils.Arg(Frame.class).required();
            InvokerUtils.Arg CALLBACK = new InvokerUtils.Arg(Callback.class).required();
            MethodHandle methodHandle4 = InvokerUtils.mutatedInvoker((MethodHandles.Lookup)lookup, endpointClass, (Method)onmethod, (InvokerUtils.Arg[])new InvokerUtils.Arg[]{SESSION, FRAME, CALLBACK});
            metadata.setFrameHandle(MethodHolder.from((MethodHandle)methodHandle4), onmethod);
        }
        if ((onmethod = ReflectUtils.findAnnotatedMethod(endpointClass, OnWebSocketPing.class)) != null) {
            this.assertSignatureValid(endpointClass, onmethod, OnWebSocketPing.class);
            SESSION = new InvokerUtils.Arg(Session.class);
            BUFFER = new InvokerUtils.Arg(ByteBuffer.class).required();
            methodHandle = InvokerUtils.mutatedInvoker((MethodHandles.Lookup)lookup, endpointClass, (Method)onmethod, (InvokerUtils.Arg[])new InvokerUtils.Arg[]{SESSION, BUFFER});
            metadata.setPingHandle(MethodHolder.from((MethodHandle)methodHandle), onmethod);
        }
        if ((onmethod = ReflectUtils.findAnnotatedMethod(endpointClass, OnWebSocketPong.class)) != null) {
            this.assertSignatureValid(endpointClass, onmethod, OnWebSocketPong.class);
            SESSION = new InvokerUtils.Arg(Session.class);
            BUFFER = new InvokerUtils.Arg(ByteBuffer.class).required();
            methodHandle = InvokerUtils.mutatedInvoker((MethodHandles.Lookup)lookup, endpointClass, (Method)onmethod, (InvokerUtils.Arg[])new InvokerUtils.Arg[]{SESSION, BUFFER});
            metadata.setPongHandle(MethodHolder.from((MethodHandle)methodHandle), onmethod);
        }
        if ((onMessages = ReflectUtils.findAnnotatedMethods(endpointClass, OnWebSocketMessage.class)) != null) {
            for (Method onMsg : onMessages) {
                this.assertSignatureValid(endpointClass, onMsg, OnWebSocketMessage.class);
                MethodHandle methodHandle5 = InvokerUtils.optionalMutatedInvoker((MethodHandles.Lookup)lookup, endpointClass, (Method)onMsg, (InvokerUtils.Arg[])textCallingArgs);
                if (methodHandle5 != null) {
                    this.assertSignatureValid(endpointClass, onMsg, OnWebSocketMessage.class);
                    metadata.setTextHandle(StringMessageSink.class, MethodHolder.from((MethodHandle)methodHandle5), onMsg);
                    continue;
                }
                methodHandle5 = InvokerUtils.optionalMutatedInvoker((MethodHandles.Lookup)lookup, endpointClass, (Method)onMsg, (InvokerUtils.Arg[])binaryBufferCallingArgs);
                if (methodHandle5 != null) {
                    this.assertSignatureValid(endpointClass, onMsg, OnWebSocketMessage.class);
                    metadata.setBinaryHandle(ByteBufferMessageSink.class, MethodHolder.from((MethodHandle)methodHandle5), onMsg);
                    continue;
                }
                methodHandle5 = InvokerUtils.optionalMutatedInvoker((MethodHandles.Lookup)lookup, endpointClass, (Method)onMsg, (InvokerUtils.Arg[])inputStreamCallingArgs);
                if (methodHandle5 != null) {
                    if (!metadata.isAutoDemand()) {
                        throw new InvalidWebSocketException("InputStream methods require auto-demanding WebSocket endpoints");
                    }
                    this.assertSignatureValid(endpointClass, onMsg, OnWebSocketMessage.class);
                    metadata.setBinaryHandle(InputStreamMessageSink.class, MethodHolder.from((MethodHandle)methodHandle5), onMsg);
                    continue;
                }
                methodHandle5 = InvokerUtils.optionalMutatedInvoker((MethodHandles.Lookup)lookup, endpointClass, (Method)onMsg, (InvokerUtils.Arg[])readerCallingArgs);
                if (methodHandle5 != null) {
                    if (!metadata.isAutoDemand()) {
                        throw new InvalidWebSocketException("Reader methods require auto-demanding WebSocket endpoints");
                    }
                    this.assertSignatureValid(endpointClass, onMsg, OnWebSocketMessage.class);
                    metadata.setTextHandle(ReaderMessageSink.class, MethodHolder.from((MethodHandle)methodHandle5), onMsg);
                    continue;
                }
                methodHandle5 = InvokerUtils.optionalMutatedInvoker((MethodHandles.Lookup)lookup, endpointClass, (Method)onMsg, (InvokerUtils.Arg[])textPartialCallingArgs);
                if (methodHandle5 != null) {
                    this.assertSignatureValid(endpointClass, onMsg, OnWebSocketMessage.class);
                    metadata.setTextHandle(PartialStringMessageSink.class, MethodHolder.from((MethodHandle)methodHandle5), onMsg);
                    continue;
                }
                methodHandle5 = InvokerUtils.optionalMutatedInvoker((MethodHandles.Lookup)lookup, endpointClass, (Method)onMsg, (InvokerUtils.Arg[])binaryPartialBufferCallingArgs);
                if (methodHandle5 != null) {
                    this.assertSignatureValid(endpointClass, onMsg, OnWebSocketMessage.class);
                    metadata.setBinaryHandle(PartialByteBufferMessageSink.class, MethodHolder.from((MethodHandle)methodHandle5), onMsg);
                    continue;
                }
                throw InvalidSignatureException.build(endpointClass, OnWebSocketMessage.class, (Method)onMsg);
            }
        }
        return metadata;
    }

    private void assertSignatureValid(Class<?> endpointClass, Method method, Class<? extends Annotation> annotationClass) {
        int mods = method.getModifiers();
        if (!Modifier.isPublic(mods)) {
            StringBuilder err = new StringBuilder();
            err.append("@").append(annotationClass.getSimpleName());
            err.append(" method must be public: ");
            ReflectUtils.append((StringBuilder)err, endpointClass, (Method)method);
            throw new InvalidSignatureException(err.toString());
        }
        if (Modifier.isStatic(mods)) {
            StringBuilder err = new StringBuilder();
            err.append("@").append(annotationClass.getSimpleName());
            err.append(" method must not be static: ");
            ReflectUtils.append((StringBuilder)err, endpointClass, (Method)method);
            throw new InvalidSignatureException(err.toString());
        }
        Class<?> returnType = method.getReturnType();
        if (returnType == Void.TYPE || returnType == Void.class) {
            return;
        }
        StringBuilder err = new StringBuilder();
        err.append("@").append(annotationClass.getSimpleName());
        err.append(" return must be void: ");
        ReflectUtils.append((StringBuilder)err, endpointClass, (Method)method);
        throw new InvalidSignatureException(err.toString());
    }

    public static MethodHandles.Lookup getServerMethodHandleLookup() {
        return MethodHandles.lookup();
    }

    public static MethodHandles.Lookup getApplicationMethodHandleLookup(Class<?> lookupClass) {
        return MethodHandles.publicLookup().in(lookupClass);
    }

    public void dump(Appendable out, String indent) throws IOException {
        this.dumpObjects(out, indent, new Object[]{this.metadataMap});
    }

    private static class CallbackCompletingCloseHolder
    extends MethodHolder.Wrapper {
        public CallbackCompletingCloseHolder(MethodHolder methodHolder) {
            super(methodHolder);
        }

        public Object invoke(Object ... args) {
            Callback callback = (Callback)Arrays.stream(args).filter(o -> o instanceof Callback).findFirst().orElseThrow(IllegalArgumentException::new);
            try {
                Object value = super.invoke(args);
                callback.succeed();
                return value;
            }
            catch (Throwable t) {
                callback.fail(t);
                return null;
            }
        }

        public MethodHolder bindTo(Object arg) {
            return new CallbackCompletingCloseHolder(this.getWrapped().bindTo(arg));
        }

        public MethodHolder bindTo(Object arg, int idx) {
            return new CallbackCompletingCloseHolder(this.getWrapped().bindTo(arg, idx));
        }
    }
}

