/*
 * Decompiled with CFR 0.152.
 */
package org.graalvm.visualvm.lib.profiler.heapwalk.details.jdk;

import org.graalvm.visualvm.lib.jfluid.heap.Instance;
import org.graalvm.visualvm.lib.profiler.heapwalk.details.spi.DetailsProvider;
import org.graalvm.visualvm.lib.profiler.heapwalk.details.spi.DetailsUtils;
import org.graalvm.visualvm.lib.profiler.heapwalk.model.BrowserUtils;

public final class AtomicDetailsProvider
extends DetailsProvider.Basic {
    private static final String BOOLEAN_MASK = "java.util.concurrent.atomic.AtomicBoolean+";
    private static final String INTEGER_MASK = "java.util.concurrent.atomic.AtomicInteger+";
    private static final String LONG_MASK = "java.util.concurrent.atomic.AtomicLong+";
    private static final String REFERENCE_MASK = "java.util.concurrent.atomic.AtomicReference+";

    public AtomicDetailsProvider() {
        super(BOOLEAN_MASK, INTEGER_MASK, LONG_MASK, REFERENCE_MASK);
    }

    @Override
    public String getDetailsString(String className, Instance instance) {
        switch (className) {
            case "java.util.concurrent.atomic.AtomicBoolean+": {
                int value = DetailsUtils.getIntFieldValue(instance, "value", 0);
                return Boolean.toString(value != 0);
            }
            case "java.util.concurrent.atomic.AtomicInteger+": {
                int value = DetailsUtils.getIntFieldValue(instance, "value", 0);
                return Integer.toString(value);
            }
            case "java.util.concurrent.atomic.AtomicLong+": {
                long value = DetailsUtils.getLongFieldValue(instance, "value", 0L);
                return Long.toString(value);
            }
            case "java.util.concurrent.atomic.AtomicReference+": {
                Object value = instance.getValueOfField("value");
                if (!(value instanceof Instance)) break;
                Instance i = (Instance)value;
                String s = DetailsUtils.getInstanceString(i);
                s = s == null ? "#" + i.getInstanceNumber() : ": " + s;
                return BrowserUtils.getSimpleType(i.getJavaClass().getName()) + s;
            }
        }
        return null;
    }
}

