# -*- coding: utf-8 -*-
#---------------------------------------------------------------------------
# Copyright 2023 VMware, Inc.  All rights reserved.

# AUTO GENERATED FILE -- DO NOT MODIFY!
#
# vAPI stub file for package com.vmware.nsx.upgrade.pre_upgrade_checks.
#---------------------------------------------------------------------------

"""


"""

__author__ = 'VMware, Inc.'
__docformat__ = 'restructuredtext en'

import sys
from warnings import warn

from vmware.vapi.bindings import type
from vmware.vapi.bindings.converter import TypeConverter
from vmware.vapi.bindings.enum import Enum
from vmware.vapi.bindings.error import VapiError
from vmware.vapi.bindings.struct import VapiStruct
from vmware.vapi.bindings.stub import (
    ApiInterfaceStub, StubFactoryBase, VapiInterface)
from vmware.vapi.bindings.common import raise_core_exception
from vmware.vapi.data.validator import (UnionValidator, HasFieldsOfValidator)
from vmware.vapi.exception import CoreException
from vmware.vapi.lib.constants import TaskType
from vmware.vapi.lib.rest import OperationRestMetadata


class Failures(VapiInterface):
    """
    
    """
    LIST_ORIGIN_TYPE_COMPONENT = "COMPONENT"
    """
    Possible value for ``originType`` of method :func:`Failures.list`.

    """
    LIST_ORIGIN_TYPE_UPGRADE_UNIT = "UPGRADE_UNIT"
    """
    Possible value for ``originType`` of method :func:`Failures.list`.

    """
    LIST_TYPE_FAILURE = "FAILURE"
    """
    Possible value for ``type`` of method :func:`Failures.list`.

    """
    LIST_TYPE_WARNING = "WARNING"
    """
    Possible value for ``type`` of method :func:`Failures.list`.

    """

    _VAPI_SERVICE_ID = 'com.vmware.nsx.upgrade.pre_upgrade_checks.failures'
    """
    Identifier of the service in canonical form.
    """
    def __init__(self, config):
        """
        :type  config: :class:`vmware.vapi.bindings.stub.StubConfiguration`
        :param config: Configuration to be used for creating the stub.
        """
        VapiInterface.__init__(self, config, _FailuresStub)
        self._VAPI_OPERATION_IDS = {}


    def list(self,
             component_type=None,
             cursor=None,
             filter_text=None,
             group_id=None,
             group_name=None,
             included_fields=None,
             needs_ack=None,
             origin_type=None,
             page_size=None,
             sort_ascending=None,
             sort_by=None,
             type=None,
             unit_id=None,
             unit_name=None,
             ):
        """
        Get failures resulting from the last execution of pre-upgrade checks.
        If the execution of checks is in progress, the response has the list of
        failures observed so far.

        :type  component_type: :class:`str` or ``None``
        :param component_type: Component type (optional)
        :type  cursor: :class:`str` or ``None``
        :param cursor: Opaque cursor to be used for getting next page of records (supplied
            by current result page) (optional)
        :type  filter_text: :class:`str` or ``None``
        :param filter_text: Filter text (optional)
        :type  group_id: :class:`str` or ``None``
        :param group_id: Filter on the group id (optional)
        :type  group_name: :class:`str` or ``None``
        :param group_name: Filter on the group name (optional)
        :type  included_fields: :class:`str` or ``None``
        :param included_fields: Comma separated list of fields that should be included in query
            result (optional)
        :type  needs_ack: :class:`bool` or ``None``
        :param needs_ack: Filter based on acknowledgement required (optional)
        :type  origin_type: :class:`str` or ``None``
        :param origin_type: Type of origin of failure (optional)
        :type  page_size: :class:`long` or ``None``
        :param page_size: Maximum number of results to return in this page (server may return
            fewer) (optional, default to 1000)
        :type  sort_ascending: :class:`bool` or ``None``
        :param sort_ascending: (optional)
        :type  sort_by: :class:`str` or ``None``
        :param sort_by: Field by which records are sorted (optional)
        :type  type: :class:`str` or ``None``
        :param type: Status of the upgrade check (optional)
        :type  unit_id: :class:`str` or ``None``
        :param unit_id: Filter on the unit id (optional)
        :type  unit_name: :class:`str` or ``None``
        :param unit_name: Filter on the unit name (optional)
        :rtype: :class:`com.vmware.nsx.model_client.UpgradeCheckFailureListResult`
        :return: com.vmware.nsx.model.UpgradeCheckFailureListResult
        :raise: :class:`com.vmware.vapi.std.errors_client.InvalidRequest` 
            Bad Request, Precondition Failed
        :raise: :class:`com.vmware.vapi.std.errors_client.Unauthorized` 
            Forbidden
        :raise: :class:`com.vmware.vapi.std.errors_client.ServiceUnavailable` 
            Service Unavailable
        :raise: :class:`com.vmware.vapi.std.errors_client.InternalServerError` 
            Internal Server Error
        :raise: :class:`com.vmware.vapi.std.errors_client.NotFound` 
            Not Found
        """
        return self._invoke('list',
                            {
                            'component_type': component_type,
                            'cursor': cursor,
                            'filter_text': filter_text,
                            'group_id': group_id,
                            'group_name': group_name,
                            'included_fields': included_fields,
                            'needs_ack': needs_ack,
                            'origin_type': origin_type,
                            'page_size': page_size,
                            'sort_ascending': sort_ascending,
                            'sort_by': sort_by,
                            'type': type,
                            'unit_id': unit_id,
                            'unit_name': unit_name,
                            })
class Success(VapiInterface):
    """
    
    """
    LIST_ORIGIN_TYPE_COMPONENT = "COMPONENT"
    """
    Possible value for ``originType`` of method :func:`Success.list`.

    """
    LIST_ORIGIN_TYPE_UPGRADE_UNIT = "UPGRADE_UNIT"
    """
    Possible value for ``originType`` of method :func:`Success.list`.

    """
    LIST_TYPE_SUCCESS = "SUCCESS"
    """
    Possible value for ``type`` of method :func:`Success.list`.

    """

    _VAPI_SERVICE_ID = 'com.vmware.nsx.upgrade.pre_upgrade_checks.success'
    """
    Identifier of the service in canonical form.
    """
    def __init__(self, config):
        """
        :type  config: :class:`vmware.vapi.bindings.stub.StubConfiguration`
        :param config: Configuration to be used for creating the stub.
        """
        VapiInterface.__init__(self, config, _SuccessStub)
        self._VAPI_OPERATION_IDS = {}


    def list(self,
             component_type=None,
             cursor=None,
             filter_text=None,
             included_fields=None,
             origin_type=None,
             page_size=None,
             sort_ascending=None,
             sort_by=None,
             type=None,
             ):
        """
        Get success resulting from the last execution of pre-upgrade checks. If
        the execution of checks is in progress, the response has the list of
        successes observed so far.

        :type  component_type: :class:`str` or ``None``
        :param component_type: Component type (optional)
        :type  cursor: :class:`str` or ``None``
        :param cursor: Opaque cursor to be used for getting next page of records (supplied
            by current result page) (optional)
        :type  filter_text: :class:`str` or ``None``
        :param filter_text: Filter text (optional)
        :type  included_fields: :class:`str` or ``None``
        :param included_fields: Comma separated list of fields that should be included in query
            result (optional)
        :type  origin_type: :class:`str` or ``None``
        :param origin_type: Type of origin of success (optional)
        :type  page_size: :class:`long` or ``None``
        :param page_size: Maximum number of results to return in this page (server may return
            fewer) (optional, default to 1000)
        :type  sort_ascending: :class:`bool` or ``None``
        :param sort_ascending: (optional)
        :type  sort_by: :class:`str` or ``None``
        :param sort_by: Field by which records are sorted (optional)
        :type  type: :class:`str` or ``None``
        :param type: Status of the upgrade check (optional)
        :rtype: :class:`com.vmware.nsx.model_client.UpgradeCheckSuccessListResult`
        :return: com.vmware.nsx.model.UpgradeCheckSuccessListResult
        :raise: :class:`com.vmware.vapi.std.errors_client.InvalidRequest` 
            Bad Request, Precondition Failed
        :raise: :class:`com.vmware.vapi.std.errors_client.Unauthorized` 
            Forbidden
        :raise: :class:`com.vmware.vapi.std.errors_client.ServiceUnavailable` 
            Service Unavailable
        :raise: :class:`com.vmware.vapi.std.errors_client.InternalServerError` 
            Internal Server Error
        :raise: :class:`com.vmware.vapi.std.errors_client.NotFound` 
            Not Found
        """
        return self._invoke('list',
                            {
                            'component_type': component_type,
                            'cursor': cursor,
                            'filter_text': filter_text,
                            'included_fields': included_fields,
                            'origin_type': origin_type,
                            'page_size': page_size,
                            'sort_ascending': sort_ascending,
                            'sort_by': sort_by,
                            'type': type,
                            })
class _FailuresStub(ApiInterfaceStub):
    def __init__(self, config):
        # properties for list operation
        list_input_type = type.StructType('operation-input', {
            'component_type': type.OptionalType(type.StringType()),
            'cursor': type.OptionalType(type.StringType()),
            'filter_text': type.OptionalType(type.StringType()),
            'group_id': type.OptionalType(type.StringType()),
            'group_name': type.OptionalType(type.StringType()),
            'included_fields': type.OptionalType(type.StringType()),
            'needs_ack': type.OptionalType(type.BooleanType()),
            'origin_type': type.OptionalType(type.StringType()),
            'page_size': type.OptionalType(type.IntegerType()),
            'sort_ascending': type.OptionalType(type.BooleanType()),
            'sort_by': type.OptionalType(type.StringType()),
            'type': type.OptionalType(type.StringType()),
            'unit_id': type.OptionalType(type.StringType()),
            'unit_name': type.OptionalType(type.StringType()),
        })
        list_error_dict = {
            'com.vmware.vapi.std.errors.invalid_request':
                type.ReferenceType('com.vmware.vapi.std.errors_client', 'InvalidRequest'),
            'com.vmware.vapi.std.errors.unauthorized':
                type.ReferenceType('com.vmware.vapi.std.errors_client', 'Unauthorized'),
            'com.vmware.vapi.std.errors.service_unavailable':
                type.ReferenceType('com.vmware.vapi.std.errors_client', 'ServiceUnavailable'),
            'com.vmware.vapi.std.errors.internal_server_error':
                type.ReferenceType('com.vmware.vapi.std.errors_client', 'InternalServerError'),
            'com.vmware.vapi.std.errors.not_found':
                type.ReferenceType('com.vmware.vapi.std.errors_client', 'NotFound'),

        }
        list_input_value_validator_list = [
        ]
        list_output_validator_list = [
        ]
        list_rest_metadata = OperationRestMetadata(
            http_method='GET',
            url_template='/api/v1/upgrade/pre-upgrade-checks/failures',
            path_variables={
            },
             header_parameters={
                                         },
            query_parameters={
                'component_type': 'component_type',
                'cursor': 'cursor',
                'filter_text': 'filter_text',
                'group_id': 'group_id',
                'group_name': 'group_name',
                'included_fields': 'included_fields',
                'needs_ack': 'needs_ack',
                'origin_type': 'origin_type',
                'page_size': 'page_size',
                'sort_ascending': 'sort_ascending',
                'sort_by': 'sort_by',
                'type': 'type',
                'unit_id': 'unit_id',
                'unit_name': 'unit_name',
            },
            content_type='application/json'
        )

        operations = {
            'list': {
                'input_type': list_input_type,
                'output_type': type.ReferenceType('com.vmware.nsx.model_client', 'UpgradeCheckFailureListResult'),
                'errors': list_error_dict,
                'input_value_validator_list': list_input_value_validator_list,
                'output_validator_list': list_output_validator_list,
                'task_type': TaskType.NONE,
            },
        }
        rest_metadata = {
            'list': list_rest_metadata,
        }
        ApiInterfaceStub.__init__(
            self, iface_name='com.vmware.nsx.upgrade.pre_upgrade_checks.failures',
            config=config, operations=operations, rest_metadata=rest_metadata,
            is_vapi_rest=False)

class _SuccessStub(ApiInterfaceStub):
    def __init__(self, config):
        # properties for list operation
        list_input_type = type.StructType('operation-input', {
            'component_type': type.OptionalType(type.StringType()),
            'cursor': type.OptionalType(type.StringType()),
            'filter_text': type.OptionalType(type.StringType()),
            'included_fields': type.OptionalType(type.StringType()),
            'origin_type': type.OptionalType(type.StringType()),
            'page_size': type.OptionalType(type.IntegerType()),
            'sort_ascending': type.OptionalType(type.BooleanType()),
            'sort_by': type.OptionalType(type.StringType()),
            'type': type.OptionalType(type.StringType()),
        })
        list_error_dict = {
            'com.vmware.vapi.std.errors.invalid_request':
                type.ReferenceType('com.vmware.vapi.std.errors_client', 'InvalidRequest'),
            'com.vmware.vapi.std.errors.unauthorized':
                type.ReferenceType('com.vmware.vapi.std.errors_client', 'Unauthorized'),
            'com.vmware.vapi.std.errors.service_unavailable':
                type.ReferenceType('com.vmware.vapi.std.errors_client', 'ServiceUnavailable'),
            'com.vmware.vapi.std.errors.internal_server_error':
                type.ReferenceType('com.vmware.vapi.std.errors_client', 'InternalServerError'),
            'com.vmware.vapi.std.errors.not_found':
                type.ReferenceType('com.vmware.vapi.std.errors_client', 'NotFound'),

        }
        list_input_value_validator_list = [
        ]
        list_output_validator_list = [
        ]
        list_rest_metadata = OperationRestMetadata(
            http_method='GET',
            url_template='/api/v1/upgrade/pre-upgrade-checks/success',
            path_variables={
            },
             header_parameters={
                               },
            query_parameters={
                'component_type': 'component_type',
                'cursor': 'cursor',
                'filter_text': 'filter_text',
                'included_fields': 'included_fields',
                'origin_type': 'origin_type',
                'page_size': 'page_size',
                'sort_ascending': 'sort_ascending',
                'sort_by': 'sort_by',
                'type': 'type',
            },
            content_type='application/json'
        )

        operations = {
            'list': {
                'input_type': list_input_type,
                'output_type': type.ReferenceType('com.vmware.nsx.model_client', 'UpgradeCheckSuccessListResult'),
                'errors': list_error_dict,
                'input_value_validator_list': list_input_value_validator_list,
                'output_validator_list': list_output_validator_list,
                'task_type': TaskType.NONE,
            },
        }
        rest_metadata = {
            'list': list_rest_metadata,
        }
        ApiInterfaceStub.__init__(
            self, iface_name='com.vmware.nsx.upgrade.pre_upgrade_checks.success',
            config=config, operations=operations, rest_metadata=rest_metadata,
            is_vapi_rest=False)


class StubFactory(StubFactoryBase):
    _attrs = {
        'Failures': Failures,
        'Success': Success,
    }

