/*
 * Decompiled with CFR 0.152.
 */
package net.sf.freecol.common.networking;

import javax.xml.stream.XMLStreamException;
import net.sf.freecol.common.io.FreeColXMLReader;
import net.sf.freecol.common.model.Direction;
import net.sf.freecol.common.model.Game;
import net.sf.freecol.common.model.IndianSettlement;
import net.sf.freecol.common.model.Tile;
import net.sf.freecol.common.model.Unit;
import net.sf.freecol.common.networking.AttributeMessage;
import net.sf.freecol.common.networking.ChangeSet;
import net.sf.freecol.common.networking.Message;
import net.sf.freecol.server.FreeColServer;
import net.sf.freecol.server.model.ServerPlayer;
import net.sf.freecol.server.model.ServerUnit;

public class ScoutIndianSettlementMessage
extends AttributeMessage {
    public static final String TAG = "scoutIndianSettlement";
    private static final String DIRECTION_TAG = "direction";
    private static final String UNIT_TAG = "unit";

    public ScoutIndianSettlementMessage(Unit unit, Direction direction) {
        super(TAG, UNIT_TAG, unit.getId(), DIRECTION_TAG, String.valueOf(direction));
    }

    public ScoutIndianSettlementMessage(Game game, FreeColXMLReader xr) throws XMLStreamException {
        super(TAG, xr, UNIT_TAG, DIRECTION_TAG);
    }

    @Override
    public boolean currentPlayerMessage() {
        return true;
    }

    @Override
    public Message.MessagePriority getPriority() {
        return Message.MessagePriority.NORMAL;
    }

    @Override
    public ChangeSet serverHandler(FreeColServer freeColServer, ServerPlayer serverPlayer) {
        Tile tile;
        ServerUnit unit;
        String unitId = this.getStringAttribute(UNIT_TAG);
        String directionString = this.getStringAttribute(DIRECTION_TAG);
        try {
            unit = serverPlayer.getOurFreeColGameObject(unitId, ServerUnit.class);
        }
        catch (Exception e) {
            return serverPlayer.clientError(e.getMessage());
        }
        if (!unit.hasAbility("model.ability.speakWithChief")) {
            return serverPlayer.clientError("Unit lacks ability to speak to chief: " + unitId);
        }
        try {
            tile = unit.getNeighbourTile(directionString);
        }
        catch (Exception e) {
            return serverPlayer.clientError(e.getMessage());
        }
        IndianSettlement is = tile.getIndianSettlement();
        if (is == null) {
            return serverPlayer.clientError("There is no native settlement at: " + tile.getId());
        }
        Unit.MoveType type = unit.getMoveType(is.getTile());
        if (type != Unit.MoveType.ENTER_INDIAN_SETTLEMENT_WITH_SCOUT) {
            return serverPlayer.clientError("Unable to enter " + is.getName() + ": " + type.whyIllegal());
        }
        return this.igc(freeColServer).scoutIndianSettlement(serverPlayer, unit, is);
    }
}

