untrusted comment: signature from openbsd 6.1 base secret key
RWQEQa33SgQSEjYjXn46hCSef4gnL7ZdXsro9TyScj+5d0azVJ1/bPQ8aR6tGWGCtIPsQN9r8P1Zw3bsXN13fyGXxLWnFf0LnAg=

OpenBSD 6.1 errata 024, August 3, 2017:

A race condition in sosplice() may result in a kernel memory leak.

Apply by doing:
    signify -Vep /etc/signify/openbsd-61-base.pub -x 024_sosplice.patch.sig \
        -m - | (cd /usr/src && patch -p0)

And then rebuild and install a new kernel:
    KK=`sysctl -n kern.osversion | cut -d# -f1`
    cd /usr/src/sys/arch/`machine`/compile/$KK
    make obj
    make config
    make
    make install

Index: sys/kern/uipc_socket.c
===================================================================
RCS file: /cvs/src/sys/kern/uipc_socket.c,v
--- sys/kern/uipc_socket.c	20 Jul 2017 08:23:43 -0000	1.195
+++ sys/kern/uipc_socket.c	20 Jul 2017 09:49:45 -0000	1.196
@@ -1069,6 +1069,7 @@ sosplice(struct socket *so, int fd, off_
 {
 	struct file	*fp;
 	struct socket	*sosp;
+	struct sosplice	*sp;
 	int		 s, error = 0;
 
 	if (sosplice_taskq == NULL)
@@ -1083,8 +1084,13 @@ sosplice(struct socket *so, int fd, off_
 	if ((so->so_state & (SS_ISCONNECTED|SS_ISCONNECTING)) == 0 &&
 	    (so->so_proto->pr_flags & PR_CONNREQUIRED))
 		return (ENOTCONN);
-	if (so->so_sp == NULL)
-		so->so_sp = pool_get(&sosplice_pool, PR_WAITOK | PR_ZERO);
+	if (so->so_sp == NULL) {
+		sp = pool_get(&sosplice_pool, PR_WAITOK | PR_ZERO);
+		if (so->so_sp == NULL)
+			so->so_sp = sp;
+		else
+			pool_put(&sosplice_pool, sp);
+	}
 
 	/* If no fd is given, unsplice by removing existing link. */
 	if (fd < 0) {
@@ -1110,8 +1116,13 @@ sosplice(struct socket *so, int fd, off_
 	if ((error = getsock(curproc, fd, &fp)) != 0)
 		return (error);
 	sosp = fp->f_data;
-	if (sosp->so_sp == NULL)
-		sosp->so_sp = pool_get(&sosplice_pool, PR_WAITOK | PR_ZERO);
+	if (sosp->so_sp == NULL) {
+		sp = pool_get(&sosplice_pool, PR_WAITOK | PR_ZERO);
+		if (sosp->so_sp == NULL)
+			sosp->so_sp = sp;
+		else
+			pool_put(&sosplice_pool, sp);
+	}
 
 	/* Lock both receive and send buffer. */
 	if ((error = sblock(&so->so_rcv,
