untrusted comment: verify with openbsd-73-base.pub
RWQS90bYzZ4XFuayg4XQ/GG0F/c6/8zF9Vd7F3ZGur3WSiofqI9iUOyTPJf4HoFFA0mLShj6b8dkuJsAT3XVZk6sR2/PIchszgU=

OpenBSD 7.3 errata 006, July 12, 2023:

Incorrect length handling of path attributes in bgpd(8) can lead to a
session reset.

Apply by doing:
    signify -Vep /etc/signify/openbsd-73-base.pub -x 006_bgpd.patch.sig \
        -m - | (cd /usr/src && patch -p0)

And then rebuild and install bgpd(8):
    cd /usr/src/usr.sbin/bgpd
    make obj
    make
    make install

Index: usr.sbin/bgpd/rde.c
===================================================================
RCS file: /cvs/src/usr.sbin/bgpd/rde.c,v
diff -u -p -u -r1.597.4.1 rde.c
--- usr.sbin/bgpd/rde.c	1 May 2023 05:13:59 -0000	1.597.4.1
+++ usr.sbin/bgpd/rde.c	10 Jul 2023 12:44:02 -0000
@@ -1995,7 +1995,7 @@ bad_flags:
 			goto bad_flags;
 		if (peer->conf.ebgp) {
 			/* ignore local-pref attr on non ibgp peers */
-			plen += 4;
+			plen += attr_len;
 			break;
 		}
 		if (a->flags & F_ATTR_LOCALPREF)
@@ -2019,7 +2019,7 @@ bad_flags:
 			 * RFC 7606
 			 */
 			log_peer_warnx(&peer->conf, "bad AGGREGATOR, "
-			    "partial attribute ignored");
+			    "attribute discarded");
 			plen += attr_len;
 			break;
 		}
@@ -2067,7 +2067,6 @@ bad_flags:
 			a->flags |= F_ATTR_PARSE_ERR;
 			log_peer_warnx(&peer->conf, "bad COMMUNITIES, "
 			    "path invalidated and prefix withdrawn");
-			break;
 		}
 		plen += attr_len;
 		break;
@@ -2084,7 +2083,6 @@ bad_flags:
 			a->flags |= F_ATTR_PARSE_ERR;
 			log_peer_warnx(&peer->conf, "bad LARGE COMMUNITIES, "
 			    "path invalidated and prefix withdrawn");
-			break;
 		}
 		plen += attr_len;
 		break;
@@ -2101,7 +2099,6 @@ bad_flags:
 			a->flags |= F_ATTR_PARSE_ERR;
 			log_peer_warnx(&peer->conf, "bad EXT_COMMUNITIES, "
 			    "path invalidated and prefix withdrawn");
-			break;
 		}
 		plen += attr_len;
 		break;
@@ -2148,10 +2145,8 @@ bad_flags:
 	case ATTR_AS4_AGGREGATOR:
 		if (attr_len != 8) {
 			/* see ATTR_AGGREGATOR ... */
-			if ((flags & ATTR_PARTIAL) == 0)
-				goto bad_len;
 			log_peer_warnx(&peer->conf, "bad AS4_AGGREGATOR, "
-			    "partial attribute ignored");
+			    "attribute discarded");
 			plen += attr_len;
 			break;
 		}
@@ -2187,6 +2182,7 @@ bad_flags:
 			a->flags |= F_ATTR_PARSE_ERR;
 			log_peer_warnx(&peer->conf, "bad OTC, "
 			    "path invalidated and prefix withdrawn");
+			plen += attr_len;
 			break;
 		}
 		if (!CHECK_FLAGS(flags, ATTR_OPTIONAL|ATTR_TRANSITIVE,
