untrusted comment: verify with openbsd-73-base.pub
RWQS90bYzZ4XFt1e27Qzdj+l6gE2tG5CvsUdswq6CGtuejEJvuRrTpzYJYAZFVZ0yNwmuc+2Li7rcXcyqJKdu01UF4uvrRmZHwQ=

OpenBSD 7.3 errata 016, September 21, 2023:

npppd(8) could crash by a l2tp message which has an AVP with wrong
length.

Apply by doing:
    signify -Vep /etc/signify/openbsd-73-base.pub \
        -x 016_npppd.patch.sig -m - | (cd /usr/src && patch -p0)

And then rebuild and install npppd:
    cd /usr/src/usr.sbin/npppd
    make obj
    make
    make install

Index: usr.sbin/npppd/l2tp/l2tp_subr.c
===================================================================
RCS file: /cvs/src/usr.sbin/npppd/l2tp/l2tp_subr.c,v
diff -u -p -r1.4 l2tp_subr.c
--- usr.sbin/npppd/l2tp/l2tp_subr.c	8 May 2012 13:15:11 -0000	1.4
+++ usr.sbin/npppd/l2tp/l2tp_subr.c	18 Sep 2023 17:06:34 -0000
@@ -80,10 +80,10 @@ avp_enum(struct l2tp_avp *avp, const u_c
 	avp->attr_type |= *(pkt + 1);
 	pkt += 2;
 
-	if (avp->length > pktlen)
+	if (avp->length < 6 || avp->length > pktlen)
 		return -1;
 
-	if (filldata != 0)
+	if (avp->length > 6 && filldata != 0)
 		memcpy(avp->attr_value, pkt, avp->length - 6);
 
 	return avp->length;
@@ -285,9 +285,8 @@ avp_find(struct l2tp_avp *avp, const u_c
 
 	while (pktlen >= 6 &&
 	    (avpsz = avp_enum(avp, pkt, pktlen, fill_data)) > 0) {
+		L2TP_SUBR_ASSERT(avpsz >= 6);
 		if (avp->vendor_id != vendor_id || avp->attr_type != attr_type) {
-			if (avpsz < 6)
-				return NULL;
 			pkt += avpsz;
 			pktlen -= avpsz;
 			continue;
