untrusted comment: verify with openbsd-74-base.pub
RWRoyQmAD08ajX5tbrf+ReCMBmCuTsDWZz7ZRBz1TqdJWfrb6AMBEp9lEK6l+h25l85rvckJN17+oQ8MLZLHJs08AFdca1XDmg8=

OpenBSD 7.4 errata 020, September 17, 2024:

In libexpat add integer range checks.
CVE-2024-45490 CVE-2024-45491 CVE-2024-45492

Apply by doing:
    signify -Vep /etc/signify/openbsd-74-base.pub -x 020_expat.patch.sig \
        -m - | (cd /usr/src && patch -p0)

And then rebuild and install libexpat:
    cd /usr/src/lib/libexpat
    make obj
    make
    make install

Index: lib/libexpat/Changes
===================================================================
RCS file: /cvs/src/lib/libexpat/Changes,v
diff -u -p -r1.23.2.1 Changes
--- lib/libexpat/Changes	18 Mar 2024 11:02:25 -0000	1.23.2.1
+++ lib/libexpat/Changes	4 Sep 2024 20:59:21 -0000
@@ -3,6 +3,27 @@ NOTE: We are looking for help with a few
       If you can help, please get in touch.  Thanks!
 
         Security fixes:
+       #887 #890  CVE-2024-45490 -- Calling function XML_ParseBuffer with
+                    len < 0 without noticing and then calling XML_GetBuffer
+                    will have XML_ParseBuffer fail to recognize the problem
+                    and XML_GetBuffer corrupt memory.
+                    With the fix, XML_ParseBuffer now complains with error
+                    XML_ERROR_INVALID_ARGUMENT just like sibling XML_Parse
+                    has been doing since Expat 2.2.1, and now documented.
+                    Impact is denial of service to potentially artitrary code
+                    execution.
+       #888 #891  CVE-2024-45491 -- Internal function dtdCopy can have an
+                    integer overflow for nDefaultAtts on 32-bit platforms
+                    (where UINT_MAX equals SIZE_MAX).
+                    Impact is denial of service to potentially artitrary code
+                    execution.
+       #889 #892  CVE-2024-45492 -- Internal function nextScaffoldPart can
+                    have an integer overflow for m_groupSize on 32-bit
+                    platforms (where UINT_MAX equals SIZE_MAX).
+                    Impact is denial of service to potentially artitrary code
+                    execution.
+
+        Security fixes:
        #839 #842  CVE-2024-28757 -- Prevent billion laughs attacks with
                     isolated use of external parsers.  Please see the commit
                     message of commit 1d50b80cf31de87750103656f6eb693746854aa8
Index: lib/libexpat/lib/xmlparse.c
===================================================================
RCS file: /cvs/src/lib/libexpat/lib/xmlparse.c,v
diff -u -p -r1.35.2.1 xmlparse.c
--- lib/libexpat/lib/xmlparse.c	18 Mar 2024 11:02:25 -0000	1.35.2.1
+++ lib/libexpat/lib/xmlparse.c	4 Sep 2024 20:59:22 -0000
@@ -1985,6 +1985,12 @@ XML_ParseBuffer(XML_Parser parser, int l
 
   if (parser == NULL)
     return XML_STATUS_ERROR;
+
+  if (len < 0) {
+    parser->m_errorCode = XML_ERROR_INVALID_ARGUMENT;
+    return XML_STATUS_ERROR;
+  }
+
   switch (parser->m_parsingStatus.parsing) {
   case XML_SUSPENDED:
     parser->m_errorCode = XML_ERROR_SUSPENDED;
@@ -6884,6 +6890,16 @@ dtdCopy(XML_Parser oldParser, DTD *newDt
     if (! newE)
       return 0;
     if (oldE->nDefaultAtts) {
+      /* Detect and prevent integer overflow.
+       * The preprocessor guard addresses the "always false" warning
+       * from -Wtype-limits on platforms where
+       * sizeof(int) < sizeof(size_t), e.g. on x86_64. */
+#if UINT_MAX >= SIZE_MAX
+      if ((size_t)oldE->nDefaultAtts
+          > ((size_t)(-1) / sizeof(DEFAULT_ATTRIBUTE))) {
+        return 0;
+      }
+#endif
       newE->defaultAtts
           = ms->malloc_fcn(oldE->nDefaultAtts * sizeof(DEFAULT_ATTRIBUTE));
       if (! newE->defaultAtts) {
@@ -7426,6 +7442,15 @@ nextScaffoldPart(XML_Parser parser) {
   int next;
 
   if (! dtd->scaffIndex) {
+    /* Detect and prevent integer overflow.
+     * The preprocessor guard addresses the "always false" warning
+     * from -Wtype-limits on platforms where
+     * sizeof(unsigned int) < sizeof(size_t), e.g. on x86_64. */
+#if UINT_MAX >= SIZE_MAX
+    if (parser->m_groupSize > ((size_t)(-1) / sizeof(int))) {
+      return -1;
+    }
+#endif
     dtd->scaffIndex = (int *)MALLOC(parser, parser->m_groupSize * sizeof(int));
     if (! dtd->scaffIndex)
       return -1;
