/*
 * Decompiled with CFR 0.152.
 */
package com.thinkaurelius.titan.core.attribute;

import com.google.common.base.Preconditions;
import com.thinkaurelius.titan.core.attribute.Geoshape;
import com.thinkaurelius.titan.graphdb.query.TitanPredicate;

public enum Geo implements TitanPredicate
{
    INTERSECT{

        @Override
        public boolean evaluate(Object value, Object condition) {
            Preconditions.checkArgument((boolean)(condition instanceof Geoshape));
            if (value == null) {
                return false;
            }
            Preconditions.checkArgument((boolean)(value instanceof Geoshape));
            return ((Geoshape)value).intersect((Geoshape)condition);
        }

        public String toString() {
            return "intersect";
        }

        @Override
        public boolean hasNegation() {
            return true;
        }

        @Override
        public TitanPredicate negate() {
            return DISJOINT;
        }
    }
    ,
    DISJOINT{

        @Override
        public boolean evaluate(Object value, Object condition) {
            Preconditions.checkArgument((boolean)(condition instanceof Geoshape));
            if (value == null) {
                return false;
            }
            Preconditions.checkArgument((boolean)(value instanceof Geoshape));
            return ((Geoshape)value).disjoint((Geoshape)condition);
        }

        public String toString() {
            return "disjoint";
        }

        @Override
        public boolean hasNegation() {
            return true;
        }

        @Override
        public TitanPredicate negate() {
            return INTERSECT;
        }
    }
    ,
    WITHIN{

        @Override
        public boolean evaluate(Object value, Object condition) {
            Preconditions.checkArgument((boolean)(condition instanceof Geoshape));
            if (value == null) {
                return false;
            }
            Preconditions.checkArgument((boolean)(value instanceof Geoshape));
            return ((Geoshape)value).within((Geoshape)condition);
        }

        public String toString() {
            return "within";
        }

        @Override
        public boolean hasNegation() {
            return false;
        }

        @Override
        public TitanPredicate negate() {
            throw new UnsupportedOperationException();
        }
    };


    @Override
    public boolean isValidCondition(Object condition) {
        return condition != null && condition instanceof Geoshape;
    }

    @Override
    public boolean isValidValueType(Class<?> clazz) {
        Preconditions.checkNotNull(clazz);
        return clazz.equals(Geoshape.class);
    }

    @Override
    public boolean isQNF() {
        return true;
    }
}

