/*
 * Decompiled with CFR 0.152.
 */
package com.thinkaurelius.titan.diskstorage.util.time;

import com.thinkaurelius.titan.core.attribute.Duration;
import com.thinkaurelius.titan.diskstorage.util.time.StandardDuration;
import com.thinkaurelius.titan.diskstorage.util.time.StandardTimepoint;
import com.thinkaurelius.titan.diskstorage.util.time.Timepoint;
import com.thinkaurelius.titan.diskstorage.util.time.Timer;
import com.thinkaurelius.titan.diskstorage.util.time.TimestampProvider;
import java.util.concurrent.TimeUnit;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public enum Timestamps implements TimestampProvider
{
    NANO{
        private final long t0NanoTime;
        private final long t0NanosSinceEpoch;
        {
            long t0ms = System.currentTimeMillis();
            long t0ns = System.nanoTime();
            this.t0NanosSinceEpoch = t0ms * 1000L * 1000L;
            this.t0NanoTime = t0ns;
            LoggerFactory.getLogger(Timestamps.class).trace("Initialized nanotime. currentTimeMillis component: {} ms. nanoTime component: {} ns.", (Object)t0ms, (Object)t0ns);
        }

        @Override
        public Timepoint getTime() {
            return new StandardTimepoint(this.getTimeInternal(), NANO);
        }

        @Override
        public TimeUnit getUnit() {
            return TimeUnit.NANOSECONDS;
        }

        private final long getTimeInternal() {
            return System.nanoTime() - this.t0NanoTime + this.t0NanosSinceEpoch;
        }
    }
    ,
    MICRO{

        @Override
        public Timepoint getTime() {
            return new StandardTimepoint(System.currentTimeMillis() * 1000L, MICRO);
        }

        @Override
        public TimeUnit getUnit() {
            return TimeUnit.MICROSECONDS;
        }
    }
    ,
    MILLI{

        @Override
        public Timepoint getTime() {
            return new StandardTimepoint(System.currentTimeMillis(), MILLI);
        }

        @Override
        public TimeUnit getUnit() {
            return TimeUnit.MILLISECONDS;
        }
    };

    private static final Logger log;

    @Override
    public Timepoint sleepPast(Timepoint futureTime) throws InterruptedException {
        Timepoint now;
        TimeUnit unit = this.getUnit();
        if (unit.equals((Object)TimeUnit.MILLISECONDS)) {
            futureTime = futureTime.add(new StandardDuration(1L, TimeUnit.MILLISECONDS));
        }
        while ((now = this.getTime()).compareTo(futureTime) <= 0) {
            long delta = futureTime.getTimestamp(unit) - now.getTimestamp(unit);
            if (0L == delta) {
                delta = 1L;
            }
            if (log.isTraceEnabled()) {
                log.trace("Sleeping: now={} targettime={} delta={} {}", new Object[]{now, futureTime, delta, unit});
            }
            unit.sleep(delta);
        }
        return now;
    }

    @Override
    public void sleepFor(Duration duration) throws InterruptedException {
        if (duration.isZeroLength()) {
            return;
        }
        TimeUnit unit = duration.getNativeUnit();
        unit.sleep(duration.getLength(unit));
    }

    @Override
    public Timer getTimer() {
        return new Timer(this);
    }

    public String toString() {
        return this.name();
    }

    @Override
    public Timepoint getTime(long sinceEpoch, TimeUnit unit) {
        return new StandardTimepoint(this.getUnit().convert(sinceEpoch, unit), this);
    }

    static {
        log = LoggerFactory.getLogger(Timestamps.class);
    }
}

