/*
 * Decompiled with CFR 0.152.
 */
package com.thinkaurelius.titan.graphdb.query.condition;

import com.thinkaurelius.titan.core.TitanElement;
import com.thinkaurelius.titan.core.TitanRelation;
import com.thinkaurelius.titan.core.TitanVertex;
import com.thinkaurelius.titan.core.schema.TitanSchemaElement;
import com.thinkaurelius.titan.graphdb.internal.InternalElement;
import com.thinkaurelius.titan.graphdb.query.condition.Literal;
import com.thinkaurelius.titan.graphdb.types.system.SystemRelationType;
import org.apache.commons.lang.builder.HashCodeBuilder;

public class VisibilityFilterCondition<E extends TitanElement>
extends Literal<E> {
    private final Visibility visibility;

    public VisibilityFilterCondition(Visibility visibility) {
        this.visibility = visibility;
    }

    @Override
    public boolean evaluate(E element) {
        switch (this.visibility) {
            case NORMAL: {
                return !((InternalElement)element).isHidden();
            }
            case SYSTEM: {
                return element instanceof TitanRelation && ((TitanRelation)element).getType() instanceof SystemRelationType || element instanceof TitanVertex && element instanceof TitanSchemaElement;
            }
        }
        throw new AssertionError((Object)("Unrecognized visibility: " + (Object)((Object)this.visibility)));
    }

    @Override
    public int hashCode() {
        return new HashCodeBuilder().append((Object)this.getType()).append((Object)this.visibility).toHashCode();
    }

    @Override
    public boolean equals(Object other) {
        return this == other || other != null && this.getClass().isInstance(other);
    }

    @Override
    public String toString() {
        return "visibility:" + this.visibility.toString().toLowerCase();
    }

    public static enum Visibility {
        NORMAL,
        SYSTEM;

    }
}

