/*
 * Decompiled with CFR 0.152.
 */
package com.thinkaurelius.titan.graphdb.types;

import com.google.common.base.Preconditions;
import com.thinkaurelius.titan.core.Cardinality;
import com.thinkaurelius.titan.core.Multiplicity;
import com.thinkaurelius.titan.core.Order;
import com.thinkaurelius.titan.core.PropertyKey;
import com.thinkaurelius.titan.core.RelationType;
import com.thinkaurelius.titan.core.schema.PropertyKeyMaker;
import com.thinkaurelius.titan.graphdb.database.IndexSerializer;
import com.thinkaurelius.titan.graphdb.database.serialize.AttributeHandling;
import com.thinkaurelius.titan.graphdb.transaction.StandardTitanTx;
import com.thinkaurelius.titan.graphdb.types.StandardRelationTypeMaker;
import com.thinkaurelius.titan.graphdb.types.TypeDefinitionCategory;
import com.thinkaurelius.titan.graphdb.types.TypeDefinitionMap;
import java.lang.reflect.Modifier;

public class StandardPropertyKeyMaker
extends StandardRelationTypeMaker
implements PropertyKeyMaker {
    private Class<?> dataType = null;

    public StandardPropertyKeyMaker(StandardTitanTx tx, IndexSerializer indexSerializer, AttributeHandling attributeHandler) {
        super(tx, indexSerializer, attributeHandler);
        this.cardinality(Cardinality.SINGLE);
    }

    @Override
    public StandardPropertyKeyMaker dataType(Class<?> clazz) {
        Preconditions.checkArgument((clazz != null ? 1 : 0) != 0, (Object)"Need to specify a data type");
        this.dataType = clazz;
        return this;
    }

    @Override
    public StandardPropertyKeyMaker cardinality(Cardinality cardinality) {
        super.multiplicity(Multiplicity.convert(cardinality));
        return this;
    }

    @Override
    public StandardPropertyKeyMaker hidden() {
        super.hidden();
        return this;
    }

    @Override
    public StandardPropertyKeyMaker signature(RelationType ... types) {
        super.signature(types);
        return this;
    }

    @Override
    public StandardPropertyKeyMaker sortKey(RelationType ... types) {
        super.sortKey(types);
        return this;
    }

    @Override
    public StandardPropertyKeyMaker sortOrder(Order order) {
        super.sortOrder(order);
        return this;
    }

    @Override
    public PropertyKey make() {
        Preconditions.checkArgument((this.dataType != null ? 1 : 0) != 0, (Object)"Need to specify a datatype");
        Preconditions.checkArgument((!this.dataType.isPrimitive() ? 1 : 0) != 0, (String)"Primitive types are not supported. Use the corresponding object type, e.g. Integer.class instead of int.class [%s]", (Object[])new Object[]{this.dataType});
        Preconditions.checkArgument((!this.dataType.isInterface() ? 1 : 0) != 0, (String)"Datatype must be a class and not an interface: %s", (Object[])new Object[]{this.dataType});
        Preconditions.checkArgument((this.dataType.isArray() || !Modifier.isAbstract(this.dataType.getModifiers()) ? 1 : 0) != 0, (String)"Datatype cannot be an abstract class: %s", (Object[])new Object[]{this.dataType});
        TypeDefinitionMap definition = this.makeDefinition();
        definition.setValue(TypeDefinitionCategory.DATATYPE, this.dataType);
        return this.tx.makePropertyKey(this.getName(), definition);
    }
}

