/*
 * Decompiled with CFR 0.152.
 */
package com.thinkaurelius.titan.util.system;

import com.google.common.base.Preconditions;
import java.lang.reflect.Constructor;
import java.lang.reflect.InvocationTargetException;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import org.apache.commons.configuration.Configuration;

public class ConfigurationUtil {
    private static final char CONFIGURATION_SEPARATOR = '.';

    public static List<String> getUnqiuePrefixes(Configuration config) {
        HashSet<String> nameSet = new HashSet<String>();
        ArrayList<String> names = new ArrayList<String>();
        Iterator keyiter = config.getKeys();
        while (keyiter.hasNext()) {
            String name;
            String key = (String)keyiter.next();
            int pos = key.indexOf(46);
            if (pos <= 0 || !nameSet.add(name = key.substring(0, pos))) continue;
            names.add(name);
        }
        return names;
    }

    public static final <T> T instantiate(String clazzname) {
        return ConfigurationUtil.instantiate(clazzname, new Object[0], new Class[0]);
    }

    public static final <T> T instantiate(String clazzname, Object[] constructorArgs, Class[] classes) {
        Preconditions.checkArgument((constructorArgs != null && classes != null ? 1 : 0) != 0);
        Preconditions.checkArgument((constructorArgs.length == classes.length ? 1 : 0) != 0);
        try {
            Class<?> clazz = Class.forName(clazzname);
            Constructor<?> constructor = clazz.getConstructor(classes);
            Object instance = constructor.newInstance(constructorArgs);
            return (T)instance;
        }
        catch (ClassNotFoundException e) {
            throw new IllegalArgumentException("Could not find implementation class: " + clazzname, e);
        }
        catch (NoSuchMethodException e) {
            throw new IllegalArgumentException("Implementation class does not have required constructor: " + clazzname, e);
        }
        catch (InstantiationException e) {
            throw new IllegalArgumentException("Could not instantiate implementation: " + clazzname, e);
        }
        catch (IllegalAccessException e) {
            throw new IllegalArgumentException("Could not instantiate implementation: " + clazzname, e);
        }
        catch (InvocationTargetException e) {
            throw new IllegalArgumentException("Could not instantiate implementation: " + clazzname, e);
        }
        catch (ClassCastException e) {
            throw new IllegalArgumentException("Could not instantiate implementation: " + clazzname, e);
        }
    }
}

