/*
 * Decompiled with CFR 0.152.
 */
package org.apache.distributedlog;

import com.google.common.base.Ticker;
import java.io.File;
import java.io.IOException;
import java.net.URI;
import java.util.ArrayList;
import java.util.List;
import java.util.Optional;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.TimeUnit;
import org.apache.bookkeeper.client.LedgerHandle;
import org.apache.bookkeeper.common.concurrent.FutureUtils;
import org.apache.bookkeeper.common.util.OrderedScheduler;
import org.apache.bookkeeper.feature.FeatureProvider;
import org.apache.bookkeeper.feature.SettableFeatureProvider;
import org.apache.bookkeeper.shims.zk.ZooKeeperServerShim;
import org.apache.bookkeeper.stats.NullStatsLogger;
import org.apache.bookkeeper.stats.StatsLogger;
import org.apache.bookkeeper.util.IOUtils;
import org.apache.commons.io.FileUtils;
import org.apache.commons.lang3.tuple.Pair;
import org.apache.distributedlog.BKDistributedLogManager;
import org.apache.distributedlog.BKLogSegmentWriter;
import org.apache.distributedlog.BookKeeperClient;
import org.apache.distributedlog.DLMTestUtil;
import org.apache.distributedlog.DistributedLogConfiguration;
import org.apache.distributedlog.LocalDLMEmulator;
import org.apache.distributedlog.LogRecord;
import org.apache.distributedlog.LogRecordWithDLSN;
import org.apache.distributedlog.LogSegmentMetadata;
import org.apache.distributedlog.ZooKeeperClient;
import org.apache.distributedlog.api.LogReader;
import org.apache.distributedlog.api.namespace.Namespace;
import org.apache.distributedlog.api.namespace.NamespaceBuilder;
import org.apache.distributedlog.common.util.PermitLimiter;
import org.apache.distributedlog.common.util.SchedulerUtils;
import org.apache.distributedlog.impl.BKNamespaceDriver;
import org.apache.distributedlog.impl.logsegment.BKLogSegmentEntryWriter;
import org.apache.distributedlog.injector.AsyncFailureInjector;
import org.apache.distributedlog.injector.AsyncRandomFailureInjector;
import org.apache.distributedlog.io.AsyncCloseable;
import org.apache.distributedlog.logsegment.LogSegmentEntryWriter;
import org.apache.distributedlog.logsegment.LogSegmentMetadataCache;
import org.apache.distributedlog.logsegment.LogSegmentMetadataStore;
import org.apache.distributedlog.namespace.NamespaceDriver;
import org.apache.distributedlog.util.ConfUtils;
import org.apache.zookeeper.CreateMode;
import org.apache.zookeeper.KeeperException;
import org.apache.zookeeper.ZooDefs;
import org.apache.zookeeper.ZooKeeper;
import org.junit.After;
import org.junit.AfterClass;
import org.junit.Assert;
import org.junit.Before;
import org.junit.BeforeClass;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class TestDistributedLogBase {
    static final Logger LOG = LoggerFactory.getLogger(TestDistributedLogBase.class);
    protected static DistributedLogConfiguration conf;
    protected ZooKeeper zkc;
    protected static LocalDLMEmulator bkutil;
    protected static ZooKeeperServerShim zks;
    protected static String zkServers;
    protected static int zkPort;
    protected static int numBookies;
    protected static final List<File> TMP_DIRS;

    @BeforeClass
    public static void setupCluster() throws Exception {
        File zkTmpDir = IOUtils.createTempDir((String)"zookeeper", (String)"distrlog");
        TMP_DIRS.add(zkTmpDir);
        Pair serverAndPort = LocalDLMEmulator.runZookeeperOnAnyPort((File)zkTmpDir);
        zks = (ZooKeeperServerShim)serverAndPort.getLeft();
        zkPort = (Integer)serverAndPort.getRight();
        bkutil = LocalDLMEmulator.newBuilder().numBookies(numBookies).zkHost("127.0.0.1").zkPort(zkPort).serverConf(DLMTestUtil.loadTestBkConf()).shouldStartZK(false).build();
        bkutil.start();
        zkServers = "127.0.0.1:" + zkPort;
        Thread.setDefaultUncaughtExceptionHandler(new Thread.UncaughtExceptionHandler(){

            @Override
            public void uncaughtException(Thread t, Throwable e) {
                LOG.warn("Uncaught exception at Thread {} : ", (Object)t.getName(), (Object)e);
            }
        });
    }

    @AfterClass
    public static void teardownCluster() throws Exception {
        bkutil.teardown();
        zks.stop();
        for (File dir : TMP_DIRS) {
            FileUtils.forceDeleteOnExit((File)dir);
        }
    }

    @Before
    public void setup() throws Exception {
        try {
            this.zkc = LocalDLMEmulator.connectZooKeeper((String)"127.0.0.1", (int)zkPort);
        }
        catch (Exception ex) {
            LOG.error("hit exception connecting to zookeeper at {}:{}", new Object[]{"127.0.0.1", zkPort, ex});
            throw ex;
        }
    }

    @After
    public void teardown() throws Exception {
        if (null != this.zkc) {
            this.zkc.close();
        }
    }

    protected LogRecord waitForNextRecord(LogReader reader) throws Exception {
        LogRecordWithDLSN record = reader.readNext(false);
        while (null == record) {
            record = reader.readNext(false);
        }
        return record;
    }

    public URI createDLMURI(String path) throws Exception {
        return DLMTestUtil.createDLMURI(zkPort, path);
    }

    protected void ensureURICreated(URI uri) throws Exception {
        this.ensureURICreated(this.zkc, uri);
    }

    protected void ensureURICreated(ZooKeeper zkc, URI uri) throws Exception {
        try {
            zkc.create(uri.getPath(), new byte[0], (List)ZooDefs.Ids.OPEN_ACL_UNSAFE, CreateMode.PERSISTENT);
        }
        catch (KeeperException.NodeExistsException nodeExistsException) {
            // empty catch block
        }
    }

    public BKDistributedLogManager createNewDLM(DistributedLogConfiguration conf, String name) throws Exception {
        return this.createNewDLM(conf, name, PermitLimiter.NULL_PERMIT_LIMITER);
    }

    public BKDistributedLogManager createNewDLM(DistributedLogConfiguration conf, String name, PermitLimiter writeLimiter) throws Exception {
        URI uri = this.createDLMURI("/" + name);
        this.ensureURICreated(uri);
        final Namespace namespace = NamespaceBuilder.newBuilder().uri(uri).conf(conf).build();
        final OrderedScheduler scheduler = (OrderedScheduler)OrderedScheduler.newSchedulerBuilder().numThreads(1).name("test-scheduler").build();
        AsyncCloseable resourcesCloseable = new AsyncCloseable(){

            public CompletableFuture<Void> asyncClose() {
                LOG.info("Shutting down the scheduler");
                SchedulerUtils.shutdownScheduler((ExecutorService)scheduler, (long)1L, (TimeUnit)TimeUnit.SECONDS);
                LOG.info("Shut down the scheduler");
                LOG.info("Closing the namespace");
                namespace.close();
                LOG.info("Closed the namespace");
                return FutureUtils.Void();
            }
        };
        AsyncFailureInjector failureInjector = AsyncRandomFailureInjector.newBuilder().injectDelays(conf.getEIInjectReadAheadDelay(), conf.getEIInjectReadAheadDelayPercent(), conf.getEIInjectMaxReadAheadDelayMs()).injectErrors(false, 10).injectStops(conf.getEIInjectReadAheadStall(), 10).injectCorruption(conf.getEIInjectReadAheadBrokenEntries()).build();
        return new BKDistributedLogManager(name, conf, ConfUtils.getConstDynConf((DistributedLogConfiguration)conf), uri, namespace.getNamespaceDriver(), new LogSegmentMetadataCache(conf, Ticker.systemTicker()), scheduler, "Unknown-ClientId", Integer.valueOf(0), writeLimiter, (FeatureProvider)new SettableFeatureProvider("", 0), failureInjector, (StatsLogger)NullStatsLogger.INSTANCE, (StatsLogger)NullStatsLogger.INSTANCE, Optional.of(resourcesCloseable));
    }

    protected LogSegmentMetadataStore getLogSegmentMetadataStore(Namespace namespace) throws IOException {
        return namespace.getNamespaceDriver().getLogStreamMetadataStore(NamespaceDriver.Role.READER).getLogSegmentMetadataStore();
    }

    protected ZooKeeperClient getZooKeeperClient(Namespace namespace) throws Exception {
        NamespaceDriver driver = namespace.getNamespaceDriver();
        Assert.assertTrue((boolean)(driver instanceof BKNamespaceDriver));
        return ((BKNamespaceDriver)driver).getWriterZKC();
    }

    protected BookKeeperClient getBookKeeperClient(Namespace namespace) throws Exception {
        NamespaceDriver driver = namespace.getNamespaceDriver();
        Assert.assertTrue((boolean)(driver instanceof BKNamespaceDriver));
        return ((BKNamespaceDriver)driver).getReaderBKC();
    }

    protected LedgerHandle getLedgerHandle(BKLogSegmentWriter segmentWriter) {
        LogSegmentEntryWriter entryWriter = segmentWriter.getEntryWriter();
        Assert.assertTrue((boolean)(entryWriter instanceof BKLogSegmentEntryWriter));
        return ((BKLogSegmentEntryWriter)entryWriter).getLedgerHandle();
    }

    static {
        System.setProperty("zookeeper.4lw.commands.whitelist", "*");
        conf = new DistributedLogConfiguration().setEnableReadAhead(true).setReadAheadMaxRecords(1000).setReadAheadBatchSize(10).setLockTimeout(1L).setNumWorkerThreads(1).setReadAheadNoSuchLedgerExceptionOnReadLACErrorThresholdMillis(20L).setSchedulerShutdownTimeoutMs(0).setDLLedgerMetadataLayoutVersion(LogSegmentMetadata.LEDGER_METADATA_CURRENT_LAYOUT_VERSION);
        numBookies = 3;
        TMP_DIRS = new ArrayList<File>();
    }
}

