/*
 * Decompiled with CFR 0.152.
 */
package io.vertx.core.http.impl;

import io.netty.buffer.ByteBuf;
import io.netty.buffer.ByteBufAllocator;
import io.netty.buffer.CompositeByteBuf;
import io.netty.buffer.Unpooled;
import io.netty.channel.ChannelHandlerContext;
import io.netty.handler.codec.http2.Http2Connection;
import io.netty.handler.codec.http2.Http2Exception;
import io.netty.handler.codec.http2.Http2Flags;
import io.netty.handler.codec.http2.Http2FrameListener;
import io.netty.handler.codec.http2.Http2Headers;
import io.netty.handler.codec.http2.Http2LocalFlowController;
import io.netty.handler.codec.http2.Http2Stream;
import io.netty.util.collection.IntObjectHashMap;
import io.netty.util.collection.IntObjectMap;
import io.vertx.codegen.annotations.Nullable;
import io.vertx.core.AsyncResult;
import io.vertx.core.Future;
import io.vertx.core.Handler;
import io.vertx.core.VertxException;
import io.vertx.core.buffer.Buffer;
import io.vertx.core.http.GoAway;
import io.vertx.core.http.Http2Settings;
import io.vertx.core.http.HttpConnection;
import io.vertx.core.http.impl.HttpUtils;
import io.vertx.core.http.impl.VertxHttp2ConnectionHandler;
import io.vertx.core.http.impl.VertxHttp2NetSocket;
import io.vertx.core.http.impl.VertxHttp2Stream;
import io.vertx.core.impl.ContextImpl;
import io.vertx.core.impl.VertxInternal;
import io.vertx.core.net.NetSocket;
import io.vertx.core.net.impl.ConnectionBase;
import java.util.ArrayDeque;
import java.util.Map;
import java.util.Objects;

abstract class Http2ConnectionBase
extends ConnectionBase
implements Http2FrameListener,
HttpConnection {
    protected final IntObjectMap<VertxHttp2Stream> streams = new IntObjectHashMap();
    protected final ChannelHandlerContext handlerContext;
    protected final VertxHttp2ConnectionHandler handler;
    private boolean shutdown;
    private Handler<Http2Settings> remoteSettingsHandler;
    private final ArrayDeque<Runnable> updateSettingsHandlers = new ArrayDeque(4);
    private final ArrayDeque<Handler<AsyncResult<Buffer>>> pongHandlers = new ArrayDeque();
    private io.netty.handler.codec.http2.Http2Settings localSettings = new io.netty.handler.codec.http2.Http2Settings();
    private io.netty.handler.codec.http2.Http2Settings remoteSettings;
    private Handler<GoAway> goAwayHandler;
    private Handler<Void> shutdownHandler;
    private Handler<Buffer> pingHandler;
    private boolean closed;
    private boolean goneAway;
    private int windowSize;
    private long maxConcurrentStreams;

    static ByteBuf safeBuffer(ByteBuf buf, ByteBufAllocator allocator) {
        if (buf == Unpooled.EMPTY_BUFFER) {
            return buf;
        }
        if (buf.isDirect() || buf instanceof CompositeByteBuf) {
            if (buf.isReadable()) {
                ByteBuf buffer = allocator.heapBuffer(buf.readableBytes());
                buffer.writeBytes(buf);
                return buffer;
            }
            return Unpooled.EMPTY_BUFFER;
        }
        return buf.retain();
    }

    public Http2ConnectionBase(ContextImpl context, VertxHttp2ConnectionHandler handler) {
        super(context.owner(), handler.context(), context);
        this.handler = handler;
        this.handlerContext = this.chctx;
        this.windowSize = ((Http2LocalFlowController)handler.connection().local().flowController()).windowSize(handler.connection().connectionStream());
        this.maxConcurrentStreams = 0xFFFFFFFFL;
    }

    VertxInternal vertx() {
        return this.vertx;
    }

    NetSocket toNetSocket(VertxHttp2Stream stream) {
        VertxHttp2NetSocket<Http2ConnectionBase> rempl = new VertxHttp2NetSocket<Http2ConnectionBase>(this, stream.stream, !stream.isNotWritable());
        this.streams.put(stream.stream.id(), rempl);
        return rempl;
    }

    @Override
    public synchronized void handleClosed() {
        this.closed = true;
        super.handleClosed();
    }

    @Override
    public ContextImpl getContext() {
        return super.getContext();
    }

    @Override
    protected void handleInterestedOpsChanged() {
    }

    synchronized boolean isClosed() {
        return this.closed;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    synchronized void onConnectionError(Throwable cause) {
        Http2ConnectionBase http2ConnectionBase = this;
        synchronized (http2ConnectionBase) {
            for (VertxHttp2Stream stream : this.streams.values()) {
                this.context.runOnContext(v -> {
                    Http2ConnectionBase http2ConnectionBase = this;
                    synchronized (http2ConnectionBase) {
                        stream.handleException(cause);
                    }
                });
            }
            this.handleException(cause);
        }
    }

    synchronized void onStreamError(int streamId, Throwable cause) {
        VertxHttp2Stream stream = (VertxHttp2Stream)this.streams.get(streamId);
        if (stream != null) {
            stream.handleException(cause);
        }
    }

    synchronized void onStreamwritabilityChanged(Http2Stream s) {
        VertxHttp2Stream stream = (VertxHttp2Stream)this.streams.get(s.id());
        if (stream != null) {
            this.context.executeFromIO(stream::onWritabilityChanged);
        }
    }

    synchronized void onStreamClosed(Http2Stream stream) {
        this.checkShutdownHandler();
        VertxHttp2Stream removed = (VertxHttp2Stream)this.streams.remove(stream.id());
        if (removed != null) {
            this.context.executeFromIO(() -> removed.handleClose());
        }
    }

    synchronized void onGoAwaySent(int lastStreamId, long errorCode, ByteBuf debugData) {
        if (!this.goneAway) {
            this.goneAway = true;
            this.checkShutdownHandler();
        }
    }

    synchronized void onGoAwayReceived(int lastStreamId, long errorCode, ByteBuf debugData) {
        if (!this.goneAway) {
            this.goneAway = true;
            Handler<GoAway> handler = this.goAwayHandler;
            if (handler != null) {
                Buffer buffer = Buffer.buffer(debugData);
                this.context.executeFromIO(() -> handler.handle(new GoAway().setErrorCode(errorCode).setLastStreamId(lastStreamId).setDebugData(buffer)));
            }
            this.checkShutdownHandler();
        }
    }

    public void onPriorityRead(ChannelHandlerContext ctx, int streamId, int streamDependency, short weight, boolean exclusive) {
    }

    public void onHeadersRead(ChannelHandlerContext ctx, int streamId, Http2Headers headers, int streamDependency, short weight, boolean exclusive, int padding, boolean endOfStream) throws Http2Exception {
        this.onHeadersRead(ctx, streamId, headers, padding, endOfStream);
    }

    public synchronized void onSettingsAckRead(ChannelHandlerContext ctx) {
        Runnable handler = this.updateSettingsHandlers.poll();
        if (handler != null) {
            handler.run();
        }
    }

    protected void concurrencyChanged(long concurrency) {
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void onSettingsRead(ChannelHandlerContext ctx, io.netty.handler.codec.http2.Http2Settings settings) {
        boolean changed;
        Long val = settings.maxConcurrentStreams();
        if (val != null) {
            changed = this.remoteSettings != null ? val != this.maxConcurrentStreams : false;
            this.maxConcurrentStreams = val;
        } else {
            changed = false;
        }
        this.remoteSettings = settings;
        Http2ConnectionBase http2ConnectionBase = this;
        synchronized (http2ConnectionBase) {
            Handler<Http2Settings> handler = this.remoteSettingsHandler;
            if (handler != null) {
                this.context.executeFromIO(() -> handler.handle(HttpUtils.toVertxSettings(settings)));
            }
        }
        if (changed) {
            this.concurrencyChanged(this.maxConcurrentStreams);
        }
    }

    public synchronized void onPingRead(ChannelHandlerContext ctx, ByteBuf data) {
        Handler<Buffer> handler = this.pingHandler;
        if (handler != null) {
            Buffer buff = Buffer.buffer(Http2ConnectionBase.safeBuffer(data, ctx.alloc()));
            this.context.executeFromIO(() -> handler.handle(buff));
        }
    }

    public synchronized void onPingAckRead(ChannelHandlerContext ctx, ByteBuf data) {
        Handler<AsyncResult<Buffer>> handler = this.pongHandlers.poll();
        if (handler != null) {
            this.context.executeFromIO(() -> {
                Buffer buff = Buffer.buffer(Http2ConnectionBase.safeBuffer(data, ctx.alloc()));
                handler.handle(Future.succeededFuture(buff));
            });
        }
    }

    public void onPushPromiseRead(ChannelHandlerContext ctx, int streamId, int promisedStreamId, Http2Headers headers, int padding) throws Http2Exception {
    }

    public void onGoAwayRead(ChannelHandlerContext ctx, int lastStreamId, long errorCode, ByteBuf debugData) {
    }

    public void onWindowUpdateRead(ChannelHandlerContext ctx, int streamId, int windowSizeIncrement) {
    }

    public synchronized void onUnknownFrame(ChannelHandlerContext ctx, byte frameType, int streamId, Http2Flags flags, ByteBuf payload) {
        VertxHttp2Stream req = (VertxHttp2Stream)this.streams.get(streamId);
        if (req != null) {
            Buffer buff = Buffer.buffer(Http2ConnectionBase.safeBuffer(payload, ctx.alloc()));
            this.context.executeFromIO(() -> req.handleCustomFrame(frameType, flags.value(), buff));
        }
    }

    public synchronized void onRstStreamRead(ChannelHandlerContext ctx, int streamId, long errorCode) {
        VertxHttp2Stream req = (VertxHttp2Stream)this.streams.get(streamId);
        if (req != null) {
            this.context.executeFromIO(() -> req.onResetRead(errorCode));
        }
    }

    public synchronized int onDataRead(ChannelHandlerContext ctx, int streamId, ByteBuf data, int padding, boolean endOfStream) {
        int[] consumed = new int[]{padding};
        VertxHttp2Stream req = (VertxHttp2Stream)this.streams.get(streamId);
        if (req != null) {
            data = Http2ConnectionBase.safeBuffer(data, ctx.alloc());
            Buffer buff = Buffer.buffer(data);
            this.context.executeFromIO(() -> {
                int len = buff.length();
                if (req.onDataRead(buff)) {
                    consumed[0] = consumed[0] + len;
                }
            });
            if (endOfStream) {
                this.context.executeFromIO(req::onEnd);
            }
        }
        return consumed[0];
    }

    @Override
    public int getWindowSize() {
        return this.windowSize;
    }

    @Override
    public HttpConnection setWindowSize(int windowSize) {
        try {
            Http2Stream stream = this.handler.encoder().connection().connectionStream();
            int delta = windowSize - this.windowSize;
            this.handler.decoder().flowController().incrementWindowSize(stream, delta);
            this.windowSize = windowSize;
            return this;
        }
        catch (Http2Exception e) {
            throw new VertxException(e);
        }
    }

    @Override
    public synchronized HttpConnection goAway(long errorCode, int lastStreamId, Buffer debugData) {
        if (errorCode < 0L) {
            throw new IllegalArgumentException();
        }
        if (lastStreamId < 0) {
            lastStreamId = this.handler.connection().remote().lastStreamCreated();
        }
        this.handler.writeGoAway(errorCode, lastStreamId, debugData != null ? debugData.getByteBuf() : Unpooled.EMPTY_BUFFER);
        return this;
    }

    @Override
    public synchronized HttpConnection goAwayHandler(Handler<GoAway> handler) {
        this.goAwayHandler = handler;
        return this;
    }

    @Override
    public synchronized HttpConnection shutdownHandler(Handler<Void> handler) {
        this.shutdownHandler = handler;
        return this;
    }

    @Override
    public synchronized HttpConnection shutdown(long timeout) {
        if (timeout < 0L) {
            throw new IllegalArgumentException("Invalid timeout value " + timeout);
        }
        this.handler.gracefulShutdownTimeoutMillis(timeout);
        this.channel().close();
        return this;
    }

    @Override
    public HttpConnection shutdown() {
        return this.shutdown(30000L);
    }

    @Override
    public Http2ConnectionBase closeHandler(Handler<Void> handler) {
        return (Http2ConnectionBase)super.closeHandler(handler);
    }

    @Override
    public void close() {
        this.endReadAndFlush();
        this.shutdown(0L);
    }

    @Override
    public synchronized HttpConnection remoteSettingsHandler(Handler<Http2Settings> handler) {
        this.remoteSettingsHandler = handler;
        return this;
    }

    @Override
    public synchronized Http2Settings remoteSettings() {
        return HttpUtils.toVertxSettings(this.remoteSettings);
    }

    @Override
    public synchronized Http2Settings settings() {
        return HttpUtils.toVertxSettings(this.localSettings);
    }

    @Override
    public HttpConnection updateSettings(Http2Settings settings) {
        return this.updateSettings(settings, null);
    }

    @Override
    public HttpConnection updateSettings(Http2Settings settings, @Nullable Handler<AsyncResult<Void>> completionHandler) {
        io.netty.handler.codec.http2.Http2Settings settingsUpdate = HttpUtils.fromVertxSettings(settings);
        this.updateSettings(settingsUpdate, completionHandler);
        return this;
    }

    protected synchronized void updateSettings(io.netty.handler.codec.http2.Http2Settings settingsUpdate, Handler<AsyncResult<Void>> completionHandler) {
        ContextImpl completionContext = completionHandler != null ? this.context.owner().getOrCreateContext() : null;
        io.netty.handler.codec.http2.Http2Settings current = this.handler.decoder().localSettings();
        for (Map.Entry entry : current.entrySet()) {
            Character key = (Character)entry.getKey();
            if (!Objects.equals(settingsUpdate.get((Object)key), entry.getValue())) continue;
            settingsUpdate.remove((Object)key);
        }
        this.handler.writeSettings(settingsUpdate).addListener(fut -> {
            if (fut.isSuccess()) {
                Http2ConnectionBase http2ConnectionBase = this;
                synchronized (http2ConnectionBase) {
                    this.updateSettingsHandlers.add(() -> {
                        this.localSettings.putAll((Map)settingsUpdate);
                        if (completionHandler != null) {
                            completionContext.runOnContext(v -> completionHandler.handle(Future.succeededFuture()));
                        }
                    });
                }
            } else if (completionHandler != null) {
                completionContext.runOnContext(v -> completionHandler.handle(Future.failedFuture(fut.cause())));
            }
        });
    }

    @Override
    public synchronized HttpConnection ping(Buffer data, Handler<AsyncResult<Buffer>> pongHandler) {
        if (data.length() != 8) {
            throw new IllegalArgumentException("Ping data must be exactly 8 bytes");
        }
        this.handler.writePing(data.getByteBuf()).addListener(fut -> {
            if (fut.isSuccess()) {
                this.pongHandlers.add(pongHandler);
            } else {
                pongHandler.handle(Future.failedFuture(fut.cause()));
            }
        });
        return this;
    }

    @Override
    public synchronized HttpConnection pingHandler(Handler<Buffer> handler) {
        this.pingHandler = handler;
        return this;
    }

    @Override
    public synchronized Http2ConnectionBase exceptionHandler(Handler<Throwable> handler) {
        return (Http2ConnectionBase)super.exceptionHandler(handler);
    }

    private void checkShutdownHandler() {
        Http2Connection conn;
        if (!this.shutdown && ((conn = this.handler.connection()).goAwayReceived() || conn.goAwaySent()) && conn.numActiveStreams() == 0) {
            this.shutdown = true;
            Handler<Void> handler = this.shutdownHandler;
            if (handler != null) {
                this.context.executeFromIO(() -> this.shutdownHandler.handle(null));
            }
        }
    }
}

