/*
 * Decompiled with CFR 0.152.
 */
package org.apache.distributedlog;

import com.google.common.annotations.VisibleForTesting;
import com.google.common.base.Stopwatch;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import java.util.concurrent.CompletableFuture;
import java.util.function.BiConsumer;
import java.util.function.Function;
import org.apache.bookkeeper.common.concurrent.FutureEventListener;
import org.apache.bookkeeper.common.concurrent.FutureUtils;
import org.apache.bookkeeper.feature.Feature;
import org.apache.bookkeeper.feature.FeatureProvider;
import org.apache.bookkeeper.stats.Counter;
import org.apache.bookkeeper.stats.OpStatsLogger;
import org.apache.bookkeeper.stats.StatsLogger;
import org.apache.distributedlog.BKAbstractLogWriter;
import org.apache.distributedlog.BKDistributedLogManager;
import org.apache.distributedlog.BKLogSegmentWriter;
import org.apache.distributedlog.BKLogWriteHandler;
import org.apache.distributedlog.DLSN;
import org.apache.distributedlog.DistributedLogConfiguration;
import org.apache.distributedlog.DistributedLogConstants;
import org.apache.distributedlog.LogRecord;
import org.apache.distributedlog.LogSegmentMetadata;
import org.apache.distributedlog.api.AsyncLogWriter;
import org.apache.distributedlog.config.DynamicDistributedLogConfiguration;
import org.apache.distributedlog.exceptions.StreamNotReadyException;
import org.apache.distributedlog.exceptions.WriteCancelledException;
import org.apache.distributedlog.exceptions.WriteException;
import org.apache.distributedlog.feature.CoreFeatureKeys;
import org.apache.distributedlog.util.FailpointUtils;
import org.apache.distributedlog.util.Utils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

class BKAsyncLogWriter
extends BKAbstractLogWriter
implements AsyncLogWriter {
    static final Logger LOG = LoggerFactory.getLogger(BKAsyncLogWriter.class);
    static Function<List<LogSegmentMetadata>, Boolean> truncationResultConverter = segments -> true;
    private final boolean streamFailFast;
    private final boolean disableRollOnSegmentError;
    private LinkedList<PendingLogRecord> pendingRequests = null;
    private volatile boolean encounteredError = false;
    private CompletableFuture<BKLogSegmentWriter> rollingFuture = null;
    private long lastTxId = -999L;
    private final StatsLogger statsLogger;
    private final OpStatsLogger writeOpStatsLogger;
    private final OpStatsLogger markEndOfStreamOpStatsLogger;
    private final OpStatsLogger bulkWriteOpStatsLogger;
    private final OpStatsLogger getWriterOpStatsLogger;
    private final Counter pendingRequestDispatch;
    private final Feature disableLogSegmentRollingFeature;

    BKAsyncLogWriter(DistributedLogConfiguration conf, DynamicDistributedLogConfiguration dynConf, BKDistributedLogManager bkdlm, BKLogWriteHandler writeHandler, FeatureProvider featureProvider, StatsLogger dlmStatsLogger) {
        super(conf, dynConf, bkdlm);
        this.writeHandler = writeHandler;
        this.streamFailFast = conf.getFailFastOnStreamNotReady();
        this.disableRollOnSegmentError = conf.getDisableRollingOnLogSegmentError();
        this.disableLogSegmentRollingFeature = featureProvider.getFeature(CoreFeatureKeys.DISABLE_LOGSEGMENT_ROLLING.name().toLowerCase());
        this.statsLogger = dlmStatsLogger.scope("log_writer");
        this.writeOpStatsLogger = this.statsLogger.getOpStatsLogger("write");
        this.markEndOfStreamOpStatsLogger = this.statsLogger.getOpStatsLogger("mark_end_of_stream");
        this.bulkWriteOpStatsLogger = this.statsLogger.getOpStatsLogger("bulk_write");
        this.getWriterOpStatsLogger = this.statsLogger.getOpStatsLogger("get_writer");
        this.pendingRequestDispatch = this.statsLogger.getCounter("pending_request_dispatch");
    }

    @VisibleForTesting
    synchronized void setLastTxId(long txId) {
        this.lastTxId = Math.max(this.lastTxId, txId);
    }

    @Override
    public synchronized long getLastTxId() {
        return this.lastTxId;
    }

    public CompletableFuture<DLSN> writeControlRecord(LogRecord record) {
        record.setControl();
        return this.write(record);
    }

    private BKLogSegmentWriter getCachedLogSegmentWriter() throws WriteException {
        if (this.encounteredError) {
            throw new WriteException(this.bkDistributedLogManager.getStreamName(), "writer has been closed due to error.");
        }
        BKLogSegmentWriter segmentWriter = this.getCachedLogWriter();
        if (null != segmentWriter && segmentWriter.isLogSegmentInError() && !this.disableRollOnSegmentError) {
            return null;
        }
        return segmentWriter;
    }

    private CompletableFuture<BKLogSegmentWriter> getLogSegmentWriter(long firstTxid, boolean bestEffort, boolean rollLog, boolean allowMaxTxID) {
        Stopwatch stopwatch = Stopwatch.createStarted();
        return FutureUtils.stats(this.doGetLogSegmentWriter(firstTxid, bestEffort, rollLog, allowMaxTxID), (OpStatsLogger)this.getWriterOpStatsLogger, (Stopwatch)stopwatch);
    }

    private CompletableFuture<BKLogSegmentWriter> doGetLogSegmentWriter(long firstTxid, boolean bestEffort, boolean rollLog, boolean allowMaxTxID) {
        if (this.encounteredError) {
            return FutureUtils.exception((Throwable)new WriteException(this.bkDistributedLogManager.getStreamName(), "writer has been closed due to error."));
        }
        CompletableFuture<BKLogSegmentWriter> writerFuture = this.asyncGetLedgerWriter(!this.disableRollOnSegmentError);
        if (null == writerFuture) {
            return this.rollLogSegmentIfNecessary(null, firstTxid, bestEffort, allowMaxTxID);
        }
        if (rollLog) {
            return writerFuture.thenCompose(writer -> this.rollLogSegmentIfNecessary((BKLogSegmentWriter)writer, firstTxid, bestEffort, allowMaxTxID));
        }
        return writerFuture;
    }

    private CompletableFuture<BKLogSegmentWriter> getLogSegmentWriterForEndOfStream() {
        return this.getLogSegmentWriter(Long.MAX_VALUE, false, false, true);
    }

    private CompletableFuture<BKLogSegmentWriter> getLogSegmentWriter(long firstTxid, boolean bestEffort, boolean rollLog) {
        return this.getLogSegmentWriter(firstTxid, bestEffort, rollLog, false);
    }

    CompletableFuture<DLSN> queueRequest(LogRecord record, boolean flush) {
        PendingLogRecord pendingLogRecord = new PendingLogRecord(record, flush);
        this.pendingRequests.add(pendingLogRecord);
        return pendingLogRecord.promise;
    }

    boolean shouldRollLog(BKLogSegmentWriter w) {
        try {
            return null == w || !this.disableLogSegmentRollingFeature.isAvailable() && this.shouldStartNewSegment(w);
        }
        catch (IOException ioe) {
            return false;
        }
    }

    void startQueueingRequests() {
        assert (null == this.pendingRequests && null == this.rollingFuture);
        this.pendingRequests = new LinkedList();
        this.rollingFuture = new CompletableFuture();
    }

    private synchronized CompletableFuture<DLSN> asyncWrite(LogRecord record, boolean flush) {
        BKLogSegmentWriter w;
        CompletableFuture result = null;
        try {
            w = this.getCachedLogSegmentWriter();
        }
        catch (WriteException we) {
            return FutureUtils.exception((Throwable)we);
        }
        if (null != this.rollingFuture) {
            result = this.streamFailFast ? FutureUtils.exception((Throwable)new StreamNotReadyException("Rolling log segment")) : this.queueRequest(record, flush);
        } else if (this.shouldRollLog(w)) {
            this.startQueueingRequests();
            if (null != w) {
                LastPendingLogRecord lastLogRecordInCurrentSegment = new LastPendingLogRecord(record, flush);
                w.asyncWrite(record, true).whenComplete((BiConsumer)((Object)lastLogRecordInCurrentSegment));
                result = lastLogRecordInCurrentSegment.promise;
            } else {
                result = this.queueRequest(record, flush);
                this.rollLogSegmentAndIssuePendingRequests(record.getTransactionId());
            }
        } else {
            result = w.asyncWrite(record, flush);
        }
        return result.thenApply(dlsn -> {
            this.setLastTxId(record.getTransactionId());
            return dlsn;
        });
    }

    private List<CompletableFuture<DLSN>> asyncWriteBulk(List<LogRecord> records) {
        ArrayList<CompletableFuture<DLSN>> results = new ArrayList<CompletableFuture<DLSN>>(records.size());
        Iterator<LogRecord> iterator = records.iterator();
        while (iterator.hasNext()) {
            LogRecord record = iterator.next();
            CompletableFuture<DLSN> future = this.asyncWrite(record, !iterator.hasNext());
            results.add(future);
            if (!future.isDone() || !future.isCompletedExceptionally()) continue;
            break;
        }
        if (records.size() > results.size()) {
            this.appendCancelledFutures(results, records.size() - results.size());
        }
        return results;
    }

    private void appendCancelledFutures(List<CompletableFuture<DLSN>> futures, int numToAdd) {
        WriteCancelledException cre = new WriteCancelledException(this.getStreamName());
        for (int i = 0; i < numToAdd; ++i) {
            CompletableFuture cancelledFuture = FutureUtils.exception((Throwable)cre);
            futures.add(cancelledFuture);
        }
    }

    private void rollLogSegmentAndIssuePendingRequests(final long firstTxId) {
        this.getLogSegmentWriter(firstTxId, true, true).whenComplete((BiConsumer)new FutureEventListener<BKLogSegmentWriter>(){

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            public void onSuccess(BKLogSegmentWriter writer) {
                try {
                    BKAsyncLogWriter bKAsyncLogWriter = BKAsyncLogWriter.this;
                    synchronized (bKAsyncLogWriter) {
                        for (PendingLogRecord pendingLogRecord : BKAsyncLogWriter.this.pendingRequests) {
                            FailpointUtils.checkFailPoint(FailpointUtils.FailPointName.FP_LogWriterIssuePending);
                            writer.asyncWrite(pendingLogRecord.record, pendingLogRecord.flush).whenComplete((BiConsumer)((Object)pendingLogRecord));
                        }
                        if (BKAsyncLogWriter.this.pendingRequests.isEmpty()) {
                            LogRecord controlRecord = new LogRecord(firstTxId, DistributedLogConstants.CONTROL_RECORD_CONTENT);
                            controlRecord.setControl();
                            PendingLogRecord controlReq = new PendingLogRecord(controlRecord, false);
                            writer.asyncWrite(controlReq.record, controlReq.flush).whenComplete((BiConsumer)((Object)controlReq));
                        }
                        if (null != BKAsyncLogWriter.this.rollingFuture) {
                            FutureUtils.complete((CompletableFuture)BKAsyncLogWriter.this.rollingFuture, (Object)writer);
                        }
                        BKAsyncLogWriter.this.rollingFuture = null;
                        BKAsyncLogWriter.this.pendingRequestDispatch.add((long)BKAsyncLogWriter.this.pendingRequests.size());
                        BKAsyncLogWriter.this.pendingRequests = null;
                    }
                }
                catch (IOException ioe) {
                    BKAsyncLogWriter.this.errorOutPendingRequestsAndWriter(ioe);
                }
            }

            public void onFailure(Throwable cause) {
                BKAsyncLogWriter.this.errorOutPendingRequestsAndWriter(cause);
            }
        });
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @VisibleForTesting
    void errorOutPendingRequests(Throwable cause, boolean errorOutWriter) {
        LinkedList<PendingLogRecord> pendingRequestsSnapshot;
        BKAsyncLogWriter bKAsyncLogWriter = this;
        synchronized (bKAsyncLogWriter) {
            pendingRequestsSnapshot = this.pendingRequests;
            this.encounteredError = errorOutWriter;
            this.pendingRequests = null;
            if (null != this.rollingFuture) {
                FutureUtils.completeExceptionally(this.rollingFuture, (Throwable)cause);
            }
            this.rollingFuture = null;
        }
        this.pendingRequestDispatch.add((long)pendingRequestsSnapshot.size());
        for (PendingLogRecord pendingLogRecord : pendingRequestsSnapshot) {
            pendingLogRecord.promise.completeExceptionally(cause);
        }
    }

    void errorOutPendingRequestsAndWriter(Throwable cause) {
        this.errorOutPendingRequests(cause, true);
    }

    @Override
    public CompletableFuture<DLSN> write(LogRecord record) {
        Stopwatch stopwatch = Stopwatch.createStarted();
        return FutureUtils.stats(this.asyncWrite(record, true), (OpStatsLogger)this.writeOpStatsLogger, (Stopwatch)stopwatch);
    }

    @Override
    public CompletableFuture<List<CompletableFuture<DLSN>>> writeBulk(List<LogRecord> records) {
        Stopwatch stopwatch = Stopwatch.createStarted();
        return FutureUtils.stats((CompletableFuture)FutureUtils.value(this.asyncWriteBulk(records)), (OpStatsLogger)this.bulkWriteOpStatsLogger, (Stopwatch)stopwatch);
    }

    @Override
    public CompletableFuture<Boolean> truncate(DLSN dlsn) {
        BKLogWriteHandler writeHandler;
        if (DLSN.InvalidDLSN == dlsn) {
            return FutureUtils.value((Object)false);
        }
        try {
            writeHandler = this.getWriteHandler();
        }
        catch (IOException e) {
            return FutureUtils.exception((Throwable)e);
        }
        return writeHandler.setLogSegmentsOlderThanDLSNTruncated(dlsn).thenApply(truncationResultConverter);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    CompletableFuture<Long> flushAndCommit() {
        CompletableFuture<BKLogSegmentWriter> writerFuture;
        BKAsyncLogWriter bKAsyncLogWriter = this;
        synchronized (bKAsyncLogWriter) {
            writerFuture = null != this.rollingFuture ? this.rollingFuture : this.getCachedLogWriterFuture();
        }
        if (null == writerFuture) {
            return FutureUtils.value((Object)this.getLastTxId());
        }
        return writerFuture.thenCompose(writer -> writer.flushAndCommit());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public CompletableFuture<Long> markEndOfStream() {
        CompletableFuture<BKLogSegmentWriter> logSegmentWriterFuture;
        Stopwatch stopwatch = Stopwatch.createStarted();
        BKAsyncLogWriter bKAsyncLogWriter = this;
        synchronized (bKAsyncLogWriter) {
            logSegmentWriterFuture = this.rollingFuture;
        }
        if (null == logSegmentWriterFuture) {
            logSegmentWriterFuture = this.getLogSegmentWriterForEndOfStream();
        }
        return FutureUtils.stats((CompletableFuture)logSegmentWriterFuture.thenCompose(w -> w.markEndOfStream()), (OpStatsLogger)this.markEndOfStreamOpStatsLogger, (Stopwatch)stopwatch);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    protected CompletableFuture<Void> asyncCloseAndComplete() {
        CompletableFuture<BKLogSegmentWriter> logSegmentWriterFuture;
        BKAsyncLogWriter bKAsyncLogWriter = this;
        synchronized (bKAsyncLogWriter) {
            logSegmentWriterFuture = this.rollingFuture;
        }
        if (null == logSegmentWriterFuture) {
            return super.asyncCloseAndComplete();
        }
        return logSegmentWriterFuture.thenCompose(segmentWriter1 -> super.asyncCloseAndComplete());
    }

    @Override
    void closeAndComplete() throws IOException {
        Utils.ioResult(this.asyncCloseAndComplete());
    }

    @Override
    public String getStreamName() {
        return this.bkDistributedLogManager.getStreamName();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public CompletableFuture<Void> asyncAbort() {
        CompletableFuture<Void> result = super.asyncAbort();
        BKAsyncLogWriter bKAsyncLogWriter = this;
        synchronized (bKAsyncLogWriter) {
            if (this.pendingRequests != null) {
                for (PendingLogRecord pendingLogRecord : this.pendingRequests) {
                    pendingLogRecord.promise.completeExceptionally(new WriteException(this.bkDistributedLogManager.getStreamName(), "abort wring: writer has been closed due to error."));
                }
            }
        }
        return result;
    }

    public String toString() {
        return String.format("AsyncLogWriter:%s", this.getStreamName());
    }

    class LastPendingLogRecord
    extends PendingLogRecord {
        LastPendingLogRecord(LogRecord record, boolean flush) {
            super(record, flush);
        }

        @Override
        public void onSuccess(DLSN value) {
            super.onSuccess(value);
            BKAsyncLogWriter.this.rollLogSegmentAndIssuePendingRequests(this.record.getTransactionId());
        }

        @Override
        public void onFailure(Throwable cause) {
            super.onFailure(cause);
            BKAsyncLogWriter.this.errorOutPendingRequestsAndWriter(cause);
        }
    }

    class PendingLogRecord
    implements FutureEventListener<DLSN> {
        final LogRecord record;
        final CompletableFuture<DLSN> promise;
        final boolean flush;

        PendingLogRecord(LogRecord record, boolean flush) {
            this.record = record;
            this.promise = new CompletableFuture();
            this.flush = flush;
        }

        public void onSuccess(DLSN value) {
            this.promise.complete(value);
        }

        public void onFailure(Throwable cause) {
            this.promise.completeExceptionally(cause);
            BKAsyncLogWriter.this.encounteredError = true;
        }
    }
}

