/*
 * Decompiled with CFR 0.152.
 */
package org.apache.bookkeeper.statelib.impl.rocksdb;

import java.io.File;
import org.rocksdb.AbstractImmutableNativeReference;

public final class RocksUtils {
    public static void close(AbstractImmutableNativeReference ref) {
        if (null == ref) {
            return;
        }
        ref.close();
    }

    public static boolean isSstFile(File file) {
        return file.getName().endsWith(".sst");
    }

    public static String getDestCheckpointsPath(String dbPrefix) {
        return String.format("%s/checkpoints", dbPrefix);
    }

    public static String getDestCheckpointPath(String dbPrefix, String checkpointId) {
        return String.format("%s/checkpoints/%s", dbPrefix, checkpointId);
    }

    public static String getDestCheckpointMetadataPath(String dbPrefix, String checkpointId) {
        return String.format("%s/checkpoints/%s/metadata", dbPrefix, checkpointId);
    }

    public static String getDestSstsPath(String dbPrefix) {
        return String.format("%s/ssts", dbPrefix);
    }

    public static String getDestSstPath(String dbPrefix, File file) {
        return String.format("%s/ssts/%s", dbPrefix, file.getName());
    }

    public static String getDestSstPath(String dbPrefix, String fileName) {
        return String.format("%s/ssts/%s", dbPrefix, fileName);
    }

    public static String getDestTempSstPath(String dbPrefix, String checkpointId, File file) {
        return String.format("%s/checkpoints/%s/%s", dbPrefix, checkpointId, file.getName());
    }

    public static String getDestPath(String dbPrefix, String checkpointId, File file) {
        return String.format("%s/checkpoints/%s/%s", dbPrefix, checkpointId, file.getName());
    }

    private RocksUtils() {
    }
}

