/*
 * Decompiled with CFR 0.152.
 */
package org.apache.bookkeeper.benchmark;

import java.io.BufferedOutputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.nio.charset.StandardCharsets;
import java.util.Arrays;
import java.util.List;
import java.util.Random;
import java.util.Timer;
import java.util.TimerTask;
import java.util.concurrent.CountDownLatch;
import java.util.concurrent.Semaphore;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicLong;
import org.apache.bookkeeper.client.AsyncCallback;
import org.apache.bookkeeper.client.BKException;
import org.apache.bookkeeper.client.BookKeeper;
import org.apache.bookkeeper.client.LedgerHandle;
import org.apache.bookkeeper.conf.AbstractConfiguration;
import org.apache.bookkeeper.conf.ClientConfiguration;
import org.apache.bookkeeper.meta.zk.ZKMetadataDriverBase;
import org.apache.commons.cli.CommandLine;
import org.apache.commons.cli.HelpFormatter;
import org.apache.commons.cli.Options;
import org.apache.commons.cli.ParseException;
import org.apache.commons.cli.PosixParser;
import org.apache.zookeeper.CreateMode;
import org.apache.zookeeper.KeeperException;
import org.apache.zookeeper.WatchedEvent;
import org.apache.zookeeper.Watcher;
import org.apache.zookeeper.ZooDefs;
import org.apache.zookeeper.ZooKeeper;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class BenchThroughputLatency
implements AsyncCallback.AddCallback,
Runnable {
    static final Logger LOG = LoggerFactory.getLogger(BenchThroughputLatency.class);
    BookKeeper bk;
    LedgerHandle[] lh;
    AtomicLong counter;
    Semaphore sem;
    int numberOfLedgers = 1;
    final int sendLimit;
    final long[] latencies;
    Random rand = new Random();
    long previous = 0L;
    byte[] bytes;
    int lastLedger = 0;
    int latencyIndex = -1;
    AtomicLong completedRequests = new AtomicLong(0L);
    long duration = -1L;
    long throughput = -1L;
    long threshold = 20000L;
    long runningAverageCounter = 0L;
    long totalTime = 0L;

    public BenchThroughputLatency(int ensemble, int writeQuorumSize, int ackQuorumSize, byte[] passwd, int numberOfLedgers, int sendLimit, ClientConfiguration conf) throws BKException, IOException, InterruptedException {
        this.sem = new Semaphore(conf.getThrottleValue());
        this.bk = new BookKeeper(conf);
        this.counter = new AtomicLong(0L);
        this.numberOfLedgers = numberOfLedgers;
        this.sendLimit = sendLimit;
        this.latencies = new long[sendLimit];
        try {
            this.lh = new LedgerHandle[this.numberOfLedgers];
            for (int i = 0; i < this.numberOfLedgers; ++i) {
                this.lh[i] = this.bk.createLedger(ensemble, writeQuorumSize, ackQuorumSize, BookKeeper.DigestType.CRC32, passwd);
                LOG.debug("Ledger Handle: " + this.lh[i].getId());
            }
        }
        catch (BKException e) {
            e.printStackTrace();
        }
    }

    public void close() throws InterruptedException, BKException {
        for (int i = 0; i < this.numberOfLedgers; ++i) {
            this.lh[i].close();
        }
        this.bk.close();
    }

    void setEntryData(byte[] data) {
        this.bytes = data;
    }

    private int getRandomLedger() {
        return this.rand.nextInt(this.numberOfLedgers);
    }

    public synchronized long getDuration() {
        return this.duration;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void run() {
        int sent;
        LOG.info("Running...");
        long start = this.previous = System.currentTimeMillis();
        Thread reporter = new Thread(){

            @Override
            public void run() {
                try {
                    while (true) {
                        Thread.sleep(1000L);
                        LOG.info("ms: {} req: {}", (Object)System.currentTimeMillis(), (Object)BenchThroughputLatency.this.completedRequests.getAndSet(0L));
                    }
                }
                catch (InterruptedException ie) {
                    LOG.info("Caught interrupted exception, going away");
                    Thread.currentThread().interrupt();
                    return;
                }
            }
        };
        reporter.start();
        long beforeSend = System.nanoTime();
        for (sent = 0; !Thread.currentThread().isInterrupted() && sent < this.sendLimit; ++sent) {
            block12: {
                try {
                    this.sem.acquire();
                    if (sent != 10000) break block12;
                    long afterSend = System.nanoTime();
                    long time = afterSend - beforeSend;
                    LOG.info("Time to send first batch: {}s {}ns ", (Object)(time / 1000L / 1000L / 1000L), (Object)time);
                }
                catch (InterruptedException e) {
                    Thread.currentThread().interrupt();
                    break;
                }
            }
            int index = this.getRandomLedger();
            LedgerHandle h = this.lh[index];
            if (h == null) {
                LOG.error("Handle " + index + " is null!");
                continue;
            }
            long nanoTime = System.nanoTime();
            this.lh[index].asyncAddEntry(this.bytes, (AsyncCallback.AddCallback)this, (Object)new Context(sent, nanoTime));
            this.counter.incrementAndGet();
        }
        LOG.info("Sent: " + sent);
        try {
            int i = 0;
            while (this.counter.get() > 0L) {
                Thread.sleep(1000L);
                if (++i <= 30) continue;
                break;
            }
        }
        catch (InterruptedException e) {
            LOG.error("Interrupted while waiting", (Throwable)e);
            Thread.currentThread().interrupt();
        }
        BenchThroughputLatency e = this;
        synchronized (e) {
            this.duration = System.currentTimeMillis() - start;
        }
        this.throughput = (long)(sent * 1000) / this.getDuration();
        reporter.interrupt();
        try {
            reporter.join();
        }
        catch (InterruptedException ie) {
            Thread.currentThread().interrupt();
        }
        LOG.info("Finished processing in ms: " + this.getDuration() + " tp = " + this.throughput);
    }

    public long getThroughput() {
        return this.throughput;
    }

    public void addComplete(int rc, LedgerHandle lh, long entryId, Object ctx) {
        Context context = (Context)ctx;
        entryId = context.id;
        long newTime = System.nanoTime() - context.localStartTime;
        this.sem.release();
        this.counter.decrementAndGet();
        if (rc == 0) {
            this.latencies[(int)entryId] = newTime;
            this.completedRequests.incrementAndGet();
        }
    }

    public static void main(String[] args) throws KeeperException, IOException, InterruptedException, ParseException, BKException {
        int quorum;
        Options options = new Options();
        options.addOption("time", true, "Running time (seconds), default 60");
        options.addOption("entrysize", true, "Entry size (bytes), default 1024");
        options.addOption("ensemble", true, "Ensemble size, default 3");
        options.addOption("quorum", true, "Quorum size, default 2");
        options.addOption("ackQuorum", true, "Ack quorum size, default is same as quorum");
        options.addOption("throttle", true, "Max outstanding requests, default 10000");
        options.addOption("ledgers", true, "Number of ledgers, default 1");
        options.addOption("zookeeper", true, "Zookeeper ensemble, default \"localhost:2181\"");
        options.addOption("password", true, "Password used to create ledgers (default 'benchPasswd')");
        options.addOption("coordnode", true, "Coordination znode for multi client benchmarks (optional)");
        options.addOption("timeout", true, "Number of seconds after which to give up");
        options.addOption("sockettimeout", true, "Socket timeout for bookkeeper client. In seconds. Default 5");
        options.addOption("skipwarmup", false, "Skip warm up, default false");
        options.addOption("sendlimit", true, "Max number of entries to send. Default 20000000");
        options.addOption("latencyFile", true, "File to dump latencies. Default is latencyDump.dat");
        options.addOption("help", false, "This message");
        PosixParser parser = new PosixParser();
        CommandLine cmd = parser.parse(options, args);
        if (cmd.hasOption("help")) {
            HelpFormatter formatter = new HelpFormatter();
            formatter.printHelp("BenchThroughputLatency <options>", options);
            System.exit(-1);
        }
        long runningTime = Long.parseLong(cmd.getOptionValue("time", "60"));
        String servers = cmd.getOptionValue("zookeeper", "localhost:2181");
        int entrysize = Integer.parseInt(cmd.getOptionValue("entrysize", "1024"));
        int ledgers = Integer.parseInt(cmd.getOptionValue("ledgers", "1"));
        int ensemble = Integer.parseInt(cmd.getOptionValue("ensemble", "3"));
        int ackQuorum = quorum = Integer.parseInt(cmd.getOptionValue("quorum", "2"));
        if (cmd.hasOption("ackQuorum")) {
            ackQuorum = Integer.parseInt(cmd.getOptionValue("ackQuorum"));
        }
        int throttle = Integer.parseInt(cmd.getOptionValue("throttle", "10000"));
        int sendLimit = Integer.parseInt(cmd.getOptionValue("sendlimit", "20000000"));
        int sockTimeout = Integer.parseInt(cmd.getOptionValue("sockettimeout", "5"));
        String coordinationZnode = cmd.getOptionValue("coordnode");
        byte[] passwd = cmd.getOptionValue("password", "benchPasswd").getBytes(StandardCharsets.UTF_8);
        String latencyFile = cmd.getOptionValue("latencyFile", "latencyDump.dat");
        Timer timeouter = new Timer();
        if (cmd.hasOption("timeout")) {
            final long timeout = Long.parseLong(cmd.getOptionValue("timeout", "360")) * 1000L;
            timeouter.schedule(new TimerTask(){

                @Override
                public void run() {
                    System.err.println("Timing out benchmark after " + timeout + "ms");
                    System.exit(-1);
                }
            }, timeout);
        }
        LOG.warn("(Parameters received) running time: " + runningTime + ", entry size: " + entrysize + ", ensemble size: " + ensemble + ", quorum size: " + quorum + ", throttle: " + throttle + ", number of ledgers: " + ledgers + ", zk servers: " + servers + ", latency file: " + latencyFile);
        long totalTime = runningTime * 1000L;
        byte[] data = new byte[entrysize];
        Arrays.fill(data, (byte)120);
        ClientConfiguration conf = new ClientConfiguration();
        conf.setThrottleValue(throttle).setReadTimeout(sockTimeout).setZkServers(servers);
        if (!cmd.hasOption("skipwarmup")) {
            LOG.info("Starting warmup");
            long throughput = BenchThroughputLatency.warmUp(data, ledgers, ensemble, quorum, passwd, conf);
            LOG.info("Warmup tp: " + throughput);
            LOG.info("Warmup phase finished");
        }
        BenchThroughputLatency bench = new BenchThroughputLatency(ensemble, quorum, ackQuorum, passwd, ledgers, sendLimit, conf);
        bench.setEntryData(data);
        Thread thread = new Thread(bench);
        ZooKeeper zk = null;
        if (coordinationZnode != null) {
            final CountDownLatch connectLatch = new CountDownLatch(1);
            zk = new ZooKeeper(servers, 15000, new Watcher(){

                public void process(WatchedEvent event) {
                    if (event.getState() == Watcher.Event.KeeperState.SyncConnected) {
                        connectLatch.countDown();
                    }
                }
            });
            if (!connectLatch.await(10L, TimeUnit.SECONDS)) {
                LOG.error("Couldn't connect to zookeeper at " + servers);
                zk.close();
                System.exit(-1);
            }
            final CountDownLatch latch = new CountDownLatch(1);
            LOG.info("Waiting for " + coordinationZnode);
            if (zk.exists(coordinationZnode, new Watcher(){

                public void process(WatchedEvent event) {
                    if (event.getType() == Watcher.Event.EventType.NodeCreated) {
                        latch.countDown();
                    }
                }
            }) != null) {
                latch.countDown();
            }
            latch.await();
            LOG.info("Coordination znode created");
        }
        thread.start();
        Thread.sleep(totalTime);
        thread.interrupt();
        thread.join();
        LOG.info("Calculating percentiles");
        int numlat = 0;
        for (int i = 0; i < bench.latencies.length; ++i) {
            if (bench.latencies[i] <= 0L) continue;
            ++numlat;
        }
        int numcompletions = numlat;
        numlat = Math.min(bench.sendLimit, numlat);
        long[] latency = new long[numlat];
        int j = 0;
        for (int i = 0; i < bench.latencies.length && j < numlat; ++i) {
            if (bench.latencies[i] <= 0L) continue;
            latency[j++] = bench.latencies[i];
        }
        Arrays.sort(latency);
        long tp = (long)((double)numcompletions * 1000.0 / (double)bench.getDuration());
        LOG.info(numcompletions + " completions in " + bench.getDuration() + " milliseconds: " + tp + " ops/sec");
        if (zk != null) {
            zk.create(coordinationZnode + "/worker-", ("tp " + tp + " duration " + bench.getDuration()).getBytes(StandardCharsets.UTF_8), (List)ZooDefs.Ids.OPEN_ACL_UNSAFE, CreateMode.PERSISTENT_SEQUENTIAL);
            zk.close();
        }
        BufferedOutputStream fos = new BufferedOutputStream(new FileOutputStream(latencyFile));
        long[] lArray = latency;
        int n = lArray.length;
        for (int i = 0; i < n; ++i) {
            Long l = lArray[i];
            ((OutputStream)fos).write((Long.toString(l) + "\t" + l / 1000000L + "ms\n").getBytes(StandardCharsets.UTF_8));
        }
        ((OutputStream)fos).flush();
        ((OutputStream)fos).close();
        LOG.info("99th percentile latency: {}", (Object)BenchThroughputLatency.percentile(latency, 99));
        LOG.info("95th percentile latency: {}", (Object)BenchThroughputLatency.percentile(latency, 95));
        bench.close();
        timeouter.cancel();
    }

    private static double percentile(long[] latency, int percentile) {
        int size = latency.length;
        double percent = (double)percentile / 100.0;
        int sampleSize = (int)((double)size * percent);
        long total = 0L;
        int count = 0;
        for (int i = 0; i < sampleSize; ++i) {
            total += latency[i];
            ++count;
        }
        return (double)total / (double)count / 1000000.0;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static long warmUp(byte[] data, int ledgers, int ensemble, int qSize, byte[] passwd, ClientConfiguration conf) throws KeeperException, IOException, InterruptedException, BKException {
        int bookies;
        final CountDownLatch connectLatch = new CountDownLatch(1);
        String bookieRegistrationPath = ZKMetadataDriverBase.resolveZkLedgersRootPath((AbstractConfiguration)conf) + "/" + "available";
        try (ZooKeeper zk = null;){
            String servers = ZKMetadataDriverBase.resolveZkServers((AbstractConfiguration)conf);
            zk = new ZooKeeper(servers, 15000, new Watcher(){

                public void process(WatchedEvent event) {
                    if (event.getState() == Watcher.Event.KeeperState.SyncConnected) {
                        connectLatch.countDown();
                    }
                }
            });
            if (!connectLatch.await(10L, TimeUnit.SECONDS)) {
                LOG.error("Couldn't connect to zookeeper at " + servers);
                throw new IOException("Couldn't connect to zookeeper " + servers);
            }
            bookies = zk.getChildren(bookieRegistrationPath, false).size() - 1;
        }
        BenchThroughputLatency warmup = new BenchThroughputLatency(bookies, bookies, bookies, passwd, ledgers, 10000, conf);
        warmup.setEntryData(data);
        Thread thread = new Thread(warmup);
        thread.start();
        thread.join();
        warmup.close();
        return warmup.getThroughput();
    }

    static class Context {
        long localStartTime;
        long id;

        Context(long id, long time) {
            this.id = id;
            this.localStartTime = time;
        }
    }
}

