/*
 * Decompiled with CFR 0.152.
 */
package org.apache.cassandra.db.compaction.writers;

import java.util.Set;
import org.apache.cassandra.db.ColumnFamilyStore;
import org.apache.cassandra.db.Directories;
import org.apache.cassandra.db.RowIndexEntry;
import org.apache.cassandra.db.SerializationHeader;
import org.apache.cassandra.db.compaction.OperationType;
import org.apache.cassandra.db.compaction.writers.CompactionAwareWriter;
import org.apache.cassandra.db.lifecycle.LifecycleNewTracker;
import org.apache.cassandra.db.lifecycle.LifecycleTransaction;
import org.apache.cassandra.db.rows.UnfilteredRowIterator;
import org.apache.cassandra.io.sstable.Descriptor;
import org.apache.cassandra.io.sstable.format.SSTableReader;
import org.apache.cassandra.io.sstable.format.SSTableWriter;
import org.apache.cassandra.io.sstable.metadata.MetadataCollector;

public class MaxSSTableSizeWriter
extends CompactionAwareWriter {
    private final long expectedWriteSize;
    private final long maxSSTableSize;
    private final int level;
    private final long estimatedSSTables;
    private final Set<SSTableReader> allSSTables;

    public MaxSSTableSizeWriter(ColumnFamilyStore cfs, Directories directories, LifecycleTransaction txn, Set<SSTableReader> nonExpiredSSTables, long maxSSTableSize, int level) {
        this(cfs, directories, txn, nonExpiredSSTables, maxSSTableSize, level, false, false);
    }

    public MaxSSTableSizeWriter(ColumnFamilyStore cfs, Directories directories, LifecycleTransaction txn, Set<SSTableReader> nonExpiredSSTables, long maxSSTableSize, int level, boolean offline, boolean keepOriginals) {
        super(cfs, directories, txn, nonExpiredSSTables, offline, keepOriginals);
        this.allSSTables = txn.originals();
        this.level = level;
        this.maxSSTableSize = maxSSTableSize;
        long totalSize = MaxSSTableSizeWriter.getTotalWriteSize(nonExpiredSSTables, this.estimatedTotalKeys, cfs, txn.opType());
        this.expectedWriteSize = Math.min(maxSSTableSize, totalSize);
        this.estimatedSSTables = Math.max(1L, totalSize / maxSSTableSize);
    }

    private static long getTotalWriteSize(Iterable<SSTableReader> nonExpiredSSTables, long estimatedTotalKeys, ColumnFamilyStore cfs, OperationType compactionType) {
        long estimatedKeysBeforeCompaction = 0L;
        for (SSTableReader sstable : nonExpiredSSTables) {
            estimatedKeysBeforeCompaction += sstable.estimatedKeys();
        }
        estimatedKeysBeforeCompaction = Math.max(1L, estimatedKeysBeforeCompaction);
        double estimatedCompactionRatio = (double)estimatedTotalKeys / (double)estimatedKeysBeforeCompaction;
        return Math.round(estimatedCompactionRatio * (double)cfs.getExpectedCompactedFileSize(nonExpiredSSTables, compactionType));
    }

    @Override
    public boolean realAppend(UnfilteredRowIterator partition) {
        RowIndexEntry rie = this.sstableWriter.append(partition);
        if (this.sstableWriter.currentWriter().getOnDiskFilePointer() > this.maxSSTableSize) {
            this.switchCompactionLocation(this.getWriteDirectory(this.getExpectedWriteSize()));
        }
        return rie != null;
    }

    @Override
    public void switchCompactionLocation(Directories.DataDirectory location) {
        SSTableWriter writer = SSTableWriter.create(Descriptor.fromFilename(this.cfs.getSSTablePath(this.getDirectories().getLocationForDisk(location))), this.estimatedTotalKeys / this.estimatedSSTables, (Long)this.minRepairedAt, this.cfs.metadata, new MetadataCollector(this.allSSTables, this.cfs.metadata.comparator, this.level), SerializationHeader.make(this.cfs.metadata, this.nonExpiredSSTables), (LifecycleNewTracker)this.txn);
        this.sstableWriter.switchWriter(writer);
    }

    @Override
    protected long getExpectedWriteSize() {
        return this.expectedWriteSize;
    }
}

