/*
 * Decompiled with CFR 0.152.
 */
package org.apache.cassandra.db.rows;

import com.google.common.collect.Iterables;
import java.nio.ByteBuffer;
import java.security.MessageDigest;
import java.util.Objects;
import org.apache.cassandra.config.CFMetaData;
import org.apache.cassandra.db.Clustering;
import org.apache.cassandra.db.marshal.CollectionType;
import org.apache.cassandra.db.rows.Cell;
import org.apache.cassandra.db.rows.ColumnData;
import org.apache.cassandra.db.rows.ComplexColumnData;
import org.apache.cassandra.db.rows.Row;
import org.apache.cassandra.db.rows.Unfiltered;
import org.apache.cassandra.serializers.MarshalException;
import org.apache.cassandra.utils.FBUtilities;

public abstract class AbstractRow
implements Row {
    @Override
    public Unfiltered.Kind kind() {
        return Unfiltered.Kind.ROW;
    }

    @Override
    public boolean hasLiveData(int nowInSec, boolean enforceStrictLiveness) {
        if (this.primaryKeyLivenessInfo().isLive(nowInSec)) {
            return true;
        }
        if (enforceStrictLiveness) {
            return false;
        }
        return Iterables.any(this.cells(), cell -> cell.isLive(nowInSec));
    }

    @Override
    public boolean isStatic() {
        return this.clustering() == Clustering.STATIC_CLUSTERING;
    }

    @Override
    public void digest(MessageDigest digest) {
        FBUtilities.updateWithByte(digest, this.kind().ordinal());
        this.clustering().digest(digest);
        this.deletion().digest(digest);
        this.primaryKeyLivenessInfo().digest(digest);
        for (ColumnData cd : this) {
            cd.digest(digest);
        }
    }

    @Override
    public void validateData(CFMetaData metadata) {
        Clustering clustering = this.clustering();
        for (int i = 0; i < clustering.size(); ++i) {
            ByteBuffer value = clustering.get(i);
            if (value == null) continue;
            metadata.comparator.subtype(i).validate(value);
        }
        this.primaryKeyLivenessInfo().validate();
        if (this.deletion().time().localDeletionTime() < 0) {
            throw new MarshalException("A local deletion time should not be negative");
        }
        for (ColumnData cd : this) {
            cd.validate();
        }
    }

    public String toString() {
        return this.columnData().toString();
    }

    @Override
    public String toString(CFMetaData metadata) {
        return this.toString(metadata, false);
    }

    @Override
    public String toString(CFMetaData metadata, boolean fullDetails) {
        return this.toString(metadata, true, fullDetails);
    }

    @Override
    public String toString(CFMetaData metadata, boolean includeClusterKeys, boolean fullDetails) {
        StringBuilder sb = new StringBuilder();
        sb.append("Row");
        if (fullDetails) {
            sb.append("[info=").append(this.primaryKeyLivenessInfo());
            if (!this.deletion().isLive()) {
                sb.append(" del=").append(this.deletion());
            }
            sb.append(" ]");
        }
        sb.append(": ");
        if (includeClusterKeys) {
            sb.append(this.clustering().toString(metadata));
        } else {
            sb.append(this.clustering().toCQLString(metadata));
        }
        sb.append(" | ");
        boolean isFirst = true;
        for (ColumnData cd : this) {
            ComplexColumnData complexData;
            if (isFirst) {
                isFirst = false;
            } else {
                sb.append(", ");
            }
            if (fullDetails) {
                if (cd.column().isSimple()) {
                    sb.append(cd);
                    continue;
                }
                complexData = (ComplexColumnData)cd;
                if (!complexData.complexDeletion().isLive()) {
                    sb.append("del(").append(cd.column().name).append(")=").append(complexData.complexDeletion());
                }
                for (Cell cell : complexData) {
                    sb.append(", ").append(cell);
                }
                continue;
            }
            if (cd.column().isSimple()) {
                Cell cell = (Cell)cd;
                sb.append(cell.column().name).append('=');
                if (cell.isTombstone()) {
                    sb.append("<tombstone>");
                    continue;
                }
                sb.append(cell.column().type.getString(cell.value()));
                continue;
            }
            complexData = (ComplexColumnData)cd;
            CollectionType ct = (CollectionType)cd.column().type;
            sb.append(cd.column().name).append("={");
            int i = 0;
            for (Cell cell : complexData) {
                sb.append(i++ == 0 ? "" : ", ");
                sb.append(ct.nameComparator().getString(cell.path().get(0))).append("->").append(ct.valueComparator().getString(cell.value()));
            }
            sb.append('}');
        }
        return sb.toString();
    }

    public boolean equals(Object other) {
        if (!(other instanceof Row)) {
            return false;
        }
        Row that = (Row)other;
        if (!(this.clustering().equals(that.clustering()) && this.primaryKeyLivenessInfo().equals(that.primaryKeyLivenessInfo()) && this.deletion().equals(that.deletion()))) {
            return false;
        }
        return Iterables.elementsEqual((Iterable)this, (Iterable)that);
    }

    public int hashCode() {
        int hash = Objects.hash(this.clustering(), this.primaryKeyLivenessInfo(), this.deletion());
        for (ColumnData cd : this) {
            hash += 31 * cd.hashCode();
        }
        return hash;
    }
}

