/*
 * Decompiled with CFR 0.152.
 */
package org.apache.cassandra.hints;

import java.io.File;
import java.io.IOException;
import java.nio.ByteBuffer;
import java.util.zip.CRC32;
import org.apache.cassandra.hints.InputPosition;
import org.apache.cassandra.io.util.ChannelProxy;
import org.apache.cassandra.io.util.DataPosition;
import org.apache.cassandra.io.util.RandomAccessReader;
import org.apache.cassandra.utils.NativeLibrary;

public class ChecksummedDataInput
extends RandomAccessReader.RandomAccessReaderWithOwnChannel {
    private final CRC32 crc = new CRC32();
    private int crcPosition = 0;
    private boolean crcUpdateDisabled = false;
    private long limit;
    private DataPosition limitMark;

    protected ChecksummedDataInput(Builder builder) {
        super(builder);
        this.resetLimit();
    }

    public static ChecksummedDataInput open(File file) {
        return new Builder(new ChannelProxy(file)).build();
    }

    public InputPosition getSeekPosition() {
        return new Position(this.getPosition());
    }

    public void seek(InputPosition pos) {
        this.updateCrc();
        this.bufferOffset = ((Position)pos).sourcePosition;
        this.buffer.position(0).limit(0);
    }

    public void resetCrc() {
        this.crc.reset();
        this.crcPosition = this.buffer.position();
    }

    public void limit(long newLimit) {
        this.limit = newLimit;
        this.limitMark = this.mark();
    }

    protected long getSourcePosition() {
        return this.bufferOffset;
    }

    public void resetLimit() {
        this.limit = Long.MAX_VALUE;
        this.limitMark = null;
    }

    public void checkLimit(int length) throws IOException {
        if (this.limitMark == null) {
            return;
        }
        if (this.bytesPastLimit() + (long)length > this.limit) {
            throw new IOException("Digest mismatch exception");
        }
    }

    public long bytesPastLimit() {
        assert (this.limitMark != null);
        return this.bytesPastMark(this.limitMark);
    }

    public boolean checkCrc() throws IOException {
        try {
            this.updateCrc();
            this.crcUpdateDisabled = true;
            boolean bl = (int)this.crc.getValue() == this.readInt();
            return bl;
        }
        finally {
            this.crcPosition = this.buffer.position();
            this.crcUpdateDisabled = false;
        }
    }

    @Override
    public void readFully(byte[] b) throws IOException {
        this.checkLimit(b.length);
        super.readFully(b);
    }

    @Override
    public int read(byte[] b, int off, int len) throws IOException {
        this.checkLimit(len);
        return super.read(b, off, len);
    }

    @Override
    public void reBuffer() {
        this.updateCrc();
        super.reBuffer();
        this.crcPosition = this.buffer.position();
    }

    public void tryUncacheRead() {
        NativeLibrary.trySkipCache(this.getChannel().getFileDescriptor(), 0L, this.getSourcePosition(), this.getPath());
    }

    private void updateCrc() {
        if (this.crcPosition == this.buffer.position() || this.crcUpdateDisabled) {
            return;
        }
        assert (this.crcPosition >= 0 && this.crcPosition < this.buffer.position());
        ByteBuffer unprocessed = this.buffer.duplicate();
        unprocessed.position(this.crcPosition).limit(this.buffer.position());
        this.crc.update(unprocessed);
    }

    public static class Builder
    extends RandomAccessReader.Builder {
        public Builder(ChannelProxy channel) {
            super(channel);
        }

        @Override
        public ChecksummedDataInput build() {
            return new ChecksummedDataInput(this);
        }
    }

    static class Position
    implements InputPosition {
        final long sourcePosition;

        public Position(long sourcePosition) {
            this.sourcePosition = sourcePosition;
        }

        @Override
        public long subtract(InputPosition other) {
            return this.sourcePosition - ((Position)other).sourcePosition;
        }
    }
}

