/*
 * Decompiled with CFR 0.152.
 */
package org.apache.cassandra.repair;

import com.google.common.util.concurrent.AbstractFuture;
import java.net.InetAddress;
import java.util.List;
import org.apache.cassandra.dht.Range;
import org.apache.cassandra.dht.Token;
import org.apache.cassandra.repair.NodePair;
import org.apache.cassandra.repair.RepairJobDesc;
import org.apache.cassandra.repair.SyncStat;
import org.apache.cassandra.tracing.Tracing;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public abstract class SyncTask
extends AbstractFuture<SyncStat>
implements Runnable {
    private static Logger logger = LoggerFactory.getLogger(SyncTask.class);
    protected final RepairJobDesc desc;
    protected final InetAddress firstEndpoint;
    protected final InetAddress secondEndpoint;
    private final List<Range<Token>> rangesToSync;
    protected volatile SyncStat stat;

    public SyncTask(RepairJobDesc desc, InetAddress firstEndpoint, InetAddress secondEndpoint, List<Range<Token>> rangesToSync) {
        this.desc = desc;
        this.firstEndpoint = firstEndpoint;
        this.secondEndpoint = secondEndpoint;
        this.rangesToSync = rangesToSync;
    }

    @Override
    public void run() {
        this.stat = new SyncStat(new NodePair(this.firstEndpoint, this.secondEndpoint), this.rangesToSync.size());
        String format = String.format("[repair #%s] Endpoints %s and %s %%s for %s", this.desc.sessionId, this.firstEndpoint, this.secondEndpoint, this.desc.columnFamily);
        if (this.rangesToSync.isEmpty()) {
            logger.info(String.format(format, "are consistent"));
            Tracing.traceRepair("Endpoint {} is consistent with {} for {}", this.firstEndpoint, this.secondEndpoint, this.desc.columnFamily);
            this.set(this.stat);
            return;
        }
        logger.info(String.format(format, "have " + this.rangesToSync.size() + " range(s) out of sync"));
        Tracing.traceRepair("Endpoint {} has {} range(s) out of sync with {} for {}", this.firstEndpoint, this.rangesToSync.size(), this.secondEndpoint, this.desc.columnFamily);
        this.startSync(this.rangesToSync);
    }

    public SyncStat getCurrentStat() {
        return this.stat;
    }

    protected abstract void startSync(List<Range<Token>> var1);
}

