/*
 * Decompiled with CFR 0.152.
 */
package org.apache.cassandra.schema;

import com.google.common.base.Objects;
import com.google.common.collect.ImmutableMap;
import com.google.common.collect.Maps;
import java.io.IOException;
import java.lang.reflect.InvocationTargetException;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.UUID;
import java.util.stream.Collectors;
import org.apache.cassandra.config.CFMetaData;
import org.apache.cassandra.config.ColumnDefinition;
import org.apache.cassandra.cql3.statements.IndexTarget;
import org.apache.cassandra.exceptions.ConfigurationException;
import org.apache.cassandra.index.Index;
import org.apache.cassandra.io.util.DataInputPlus;
import org.apache.cassandra.io.util.DataOutputPlus;
import org.apache.cassandra.schema.UnknownIndexException;
import org.apache.cassandra.utils.FBUtilities;
import org.apache.cassandra.utils.UUIDSerializer;
import org.apache.commons.lang3.builder.ToStringBuilder;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public final class IndexMetadata {
    private static final Logger logger = LoggerFactory.getLogger(IndexMetadata.class);
    public static final Serializer serializer = new Serializer();
    public final UUID id;
    public final String name;
    public final Kind kind;
    public final Map<String, String> options;

    private IndexMetadata(String name, Map<String, String> options, Kind kind) {
        this.id = UUID.nameUUIDFromBytes(name.getBytes());
        this.name = name;
        this.options = options == null ? ImmutableMap.of() : ImmutableMap.copyOf(options);
        this.kind = kind;
    }

    public static IndexMetadata fromLegacyMetadata(CFMetaData cfm, ColumnDefinition column, String name, Kind kind, Map<String, String> options) {
        IndexTarget target;
        HashMap<String, String> newOptions = new HashMap<String, String>();
        if (options != null) {
            newOptions.putAll(options);
        }
        if (newOptions.containsKey("index_keys")) {
            newOptions.remove("index_keys");
            target = new IndexTarget(column.name, IndexTarget.Type.KEYS);
        } else if (newOptions.containsKey("index_keys_and_values")) {
            newOptions.remove("index_keys");
            target = new IndexTarget(column.name, IndexTarget.Type.KEYS_AND_VALUES);
        } else {
            target = column.type.isCollection() && !column.type.isMultiCell() ? new IndexTarget(column.name, IndexTarget.Type.FULL) : new IndexTarget(column.name, IndexTarget.Type.VALUES);
        }
        newOptions.put("target", target.asCqlString(cfm));
        return new IndexMetadata(name, newOptions, kind);
    }

    public static IndexMetadata fromSchemaMetadata(String name, Kind kind, Map<String, String> options) {
        return new IndexMetadata(name, options, kind);
    }

    public static IndexMetadata fromIndexTargets(CFMetaData cfm, List<IndexTarget> targets, String name, Kind kind, Map<String, String> options) {
        HashMap<String, String> newOptions = new HashMap<String, String>(options);
        newOptions.put("target", targets.stream().map(target -> target.asCqlString(cfm)).collect(Collectors.joining(", ")));
        return new IndexMetadata(name, newOptions, kind);
    }

    public static boolean isNameValid(String name) {
        return name != null && !name.isEmpty() && name.matches("\\w+");
    }

    public static String getDefaultIndexName(String cfName, String root) {
        if (root == null) {
            return (cfName + "_idx").replaceAll("\\W", "");
        }
        return (cfName + "_" + root + "_idx").replaceAll("\\W", "");
    }

    public void validate(CFMetaData cfm) {
        if (!IndexMetadata.isNameValid(this.name)) {
            throw new ConfigurationException("Illegal index name " + this.name);
        }
        if (this.kind == null) {
            throw new ConfigurationException("Index kind is null for index " + this.name);
        }
        if (this.kind == Kind.CUSTOM) {
            if (this.options == null || !this.options.containsKey("class_name")) {
                throw new ConfigurationException(String.format("Required option missing for index %s : %s", this.name, "class_name"));
            }
            String className = this.options.get("class_name");
            Class indexerClass = FBUtilities.classForName(className, "custom indexer");
            if (!Index.class.isAssignableFrom(indexerClass)) {
                throw new ConfigurationException(String.format("Specified Indexer class (%s) does not implement the Indexer interface", className));
            }
            this.validateCustomIndexOptions(cfm, indexerClass, this.options);
        }
    }

    private void validateCustomIndexOptions(CFMetaData cfm, Class<? extends Index> indexerClass, Map<String, String> options) throws ConfigurationException {
        try {
            Map unknownOptions;
            Map filteredOptions = Maps.filterKeys(options, key -> !key.equals("class_name"));
            if (filteredOptions.isEmpty()) {
                return;
            }
            try {
                unknownOptions = (Map)indexerClass.getMethod("validateOptions", Map.class, CFMetaData.class).invoke(null, filteredOptions, cfm);
            }
            catch (NoSuchMethodException e) {
                unknownOptions = (Map)indexerClass.getMethod("validateOptions", Map.class).invoke(null, filteredOptions);
            }
            if (!unknownOptions.isEmpty()) {
                throw new ConfigurationException(String.format("Properties specified %s are not understood by %s", unknownOptions.keySet(), indexerClass.getSimpleName()));
            }
        }
        catch (NoSuchMethodException e) {
            logger.info("Indexer {} does not have a static validateOptions method. Validation ignored", (Object)indexerClass.getName());
        }
        catch (InvocationTargetException e) {
            if (e.getTargetException() instanceof ConfigurationException) {
                throw (ConfigurationException)e.getTargetException();
            }
            throw new ConfigurationException("Failed to validate custom indexer options: " + options);
        }
        catch (ConfigurationException e) {
            throw e;
        }
        catch (Exception e) {
            throw new ConfigurationException("Failed to validate custom indexer options: " + options);
        }
    }

    public boolean isCustom() {
        return this.kind == Kind.CUSTOM;
    }

    public boolean isKeys() {
        return this.kind == Kind.KEYS;
    }

    public boolean isComposites() {
        return this.kind == Kind.COMPOSITES;
    }

    public int hashCode() {
        return Objects.hashCode((Object[])new Object[]{this.id, this.name, this.kind, this.options});
    }

    public boolean equalsWithoutName(IndexMetadata other) {
        return Objects.equal((Object)((Object)this.kind), (Object)((Object)other.kind)) && Objects.equal(this.options, other.options);
    }

    public boolean equals(Object obj) {
        if (obj == this) {
            return true;
        }
        if (!(obj instanceof IndexMetadata)) {
            return false;
        }
        IndexMetadata other = (IndexMetadata)obj;
        return Objects.equal((Object)this.id, (Object)other.id) && Objects.equal((Object)this.name, (Object)other.name) && this.equalsWithoutName(other);
    }

    public String toString() {
        return new ToStringBuilder((Object)this).append("id", (Object)this.id.toString()).append("name", (Object)this.name).append("kind", (Object)this.kind).append("options", this.options).build();
    }

    public static class Serializer {
        public void serialize(IndexMetadata metadata, DataOutputPlus out, int version) throws IOException {
            UUIDSerializer.serializer.serialize(metadata.id, out, version);
        }

        public IndexMetadata deserialize(DataInputPlus in, int version, CFMetaData cfm) throws IOException {
            UUID id = UUIDSerializer.serializer.deserialize(in, version);
            return cfm.getIndexes().get(id).orElseThrow(() -> new UnknownIndexException(cfm, id));
        }

        public long serializedSize(IndexMetadata metadata, int version) {
            return UUIDSerializer.serializer.serializedSize(metadata.id, version);
        }
    }

    public static enum Kind {
        KEYS,
        CUSTOM,
        COMPOSITES;

    }
}

