/*
 * Decompiled with CFR 0.152.
 */
package org.apache.cassandra.serializers;

import java.nio.ByteBuffer;
import org.apache.cassandra.serializers.MarshalException;
import org.apache.cassandra.serializers.TypeSerializer;
import org.apache.cassandra.utils.ByteBufferUtil;

public class ShortSerializer
implements TypeSerializer<Short> {
    public static final ShortSerializer instance = new ShortSerializer();

    @Override
    public Short deserialize(ByteBuffer bytes) {
        return bytes.remaining() == 0 ? null : Short.valueOf(ByteBufferUtil.toShort(bytes));
    }

    @Override
    public ByteBuffer serialize(Short value) {
        return value == null ? ByteBufferUtil.EMPTY_BYTE_BUFFER : ByteBufferUtil.bytes(value);
    }

    @Override
    public void validate(ByteBuffer bytes) throws MarshalException {
        if (bytes.remaining() != 2) {
            throw new MarshalException(String.format("Expected 2 bytes for a smallint (%d)", bytes.remaining()));
        }
    }

    @Override
    public String toString(Short value) {
        return value == null ? "" : String.valueOf(value);
    }

    @Override
    public Class<Short> getType() {
        return Short.class;
    }
}

