/*
 * Decompiled with CFR 0.152.
 */
package org.apache.cassandra.tracing;

import java.net.InetAddress;
import java.nio.ByteBuffer;
import java.util.Date;
import java.util.Map;
import org.apache.cassandra.config.CFMetaData;
import org.apache.cassandra.db.Mutation;
import org.apache.cassandra.db.RowUpdateBuilder;
import org.apache.cassandra.schema.KeyspaceMetadata;
import org.apache.cassandra.schema.KeyspaceParams;
import org.apache.cassandra.schema.Tables;
import org.apache.cassandra.utils.FBUtilities;
import org.apache.cassandra.utils.UUIDGen;

public final class TraceKeyspace {
    public static final String NAME = "system_traces";
    public static final long GENERATION = 1577836800000001L;
    public static final String SESSIONS = "sessions";
    public static final String EVENTS = "events";
    private static final CFMetaData Sessions = TraceKeyspace.compile("sessions", "tracing sessions", "CREATE TABLE %s (session_id uuid,command text,client inet,coordinator inet,coordinator_port int,duration int,parameters map<text, text>,request text,started_at timestamp,PRIMARY KEY ((session_id)))");
    private static final CFMetaData Events = TraceKeyspace.compile("events", "tracing events", "CREATE TABLE %s (session_id uuid,event_id timeuuid,activity text,source inet,source_port int,source_elapsed int,thread text,PRIMARY KEY ((session_id), event_id))");

    private TraceKeyspace() {
    }

    private static CFMetaData compile(String name, String description, String schema) {
        return CFMetaData.compile(String.format(schema, name), NAME).comment(description);
    }

    public static KeyspaceMetadata metadata() {
        return KeyspaceMetadata.create(NAME, KeyspaceParams.simple(2), Tables.of(Sessions, Events));
    }

    static Mutation makeStartSessionMutation(ByteBuffer sessionId, InetAddress client, Map<String, String> parameters, String request, long startedAt, String command, int ttl) {
        RowUpdateBuilder adder = new RowUpdateBuilder(Sessions, FBUtilities.timestampMicros(), ttl, (Object)sessionId).clustering(new Object[0]).add("client", (Object)client).add("coordinator", (Object)FBUtilities.getBroadcastAddress()).add("request", (Object)request).add("started_at", (Object)new Date(startedAt)).add("command", (Object)command);
        for (Map.Entry<String, String> entry : parameters.entrySet()) {
            adder.addMapEntry("parameters", entry.getKey(), entry.getValue());
        }
        return adder.build();
    }

    static Mutation makeStopSessionMutation(ByteBuffer sessionId, int elapsed, int ttl) {
        return new RowUpdateBuilder(Sessions, FBUtilities.timestampMicros(), ttl, (Object)sessionId).clustering(new Object[0]).add("duration", (Object)elapsed).build();
    }

    static Mutation makeEventMutation(ByteBuffer sessionId, String message, int elapsed, String threadName, int ttl) {
        RowUpdateBuilder adder = new RowUpdateBuilder(Events, FBUtilities.timestampMicros(), ttl, (Object)sessionId).clustering(UUIDGen.getTimeUUID());
        adder.add("activity", (Object)message);
        adder.add("source", (Object)FBUtilities.getBroadcastAddress());
        adder.add("thread", (Object)threadName);
        if (elapsed >= 0) {
            adder.add("source_elapsed", (Object)elapsed);
        }
        return adder.build();
    }
}

