/*
 * Decompiled with CFR 0.152.
 */
package org.apache.cassandra.gms;

import java.io.IOException;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.apache.cassandra.db.TypeSizes;
import org.apache.cassandra.gms.EndpointState;
import org.apache.cassandra.gms.GossipDigest;
import org.apache.cassandra.gms.GossipDigestAck;
import org.apache.cassandra.gms.GossipDigestSerializationHelper;
import org.apache.cassandra.io.IVersionedSerializer;
import org.apache.cassandra.io.util.DataInputPlus;
import org.apache.cassandra.io.util.DataOutputPlus;
import org.apache.cassandra.locator.InetAddressAndPort;

class GossipDigestAckSerializer
implements IVersionedSerializer<GossipDigestAck> {
    GossipDigestAckSerializer() {
    }

    @Override
    public void serialize(GossipDigestAck gDigestAckMessage, DataOutputPlus out, int version) throws IOException {
        GossipDigestSerializationHelper.serialize(gDigestAckMessage.gDigestList, out, version);
        out.writeInt(gDigestAckMessage.epStateMap.size());
        for (Map.Entry<InetAddressAndPort, EndpointState> entry : gDigestAckMessage.epStateMap.entrySet()) {
            InetAddressAndPort ep = entry.getKey();
            InetAddressAndPort.Serializer.inetAddressAndPortSerializer.serialize(ep, out, version);
            EndpointState.serializer.serialize(entry.getValue(), out, version);
        }
    }

    @Override
    public GossipDigestAck deserialize(DataInputPlus in, int version) throws IOException {
        List<GossipDigest> gDigestList = GossipDigestSerializationHelper.deserialize(in, version);
        int size = in.readInt();
        HashMap<InetAddressAndPort, EndpointState> epStateMap = new HashMap<InetAddressAndPort, EndpointState>(size);
        for (int i = 0; i < size; ++i) {
            InetAddressAndPort ep = InetAddressAndPort.Serializer.inetAddressAndPortSerializer.deserialize(in, version);
            EndpointState epState = (EndpointState)EndpointState.serializer.deserialize(in, version);
            epStateMap.put(ep, epState);
        }
        return new GossipDigestAck(gDigestList, epStateMap);
    }

    @Override
    public long serializedSize(GossipDigestAck ack, int version) {
        int size = GossipDigestSerializationHelper.serializedSize(ack.gDigestList, version);
        size += TypeSizes.sizeof(ack.epStateMap.size());
        for (Map.Entry<InetAddressAndPort, EndpointState> entry : ack.epStateMap.entrySet()) {
            size = (int)((long)size + (InetAddressAndPort.Serializer.inetAddressAndPortSerializer.serializedSize(entry.getKey(), version) + EndpointState.serializer.serializedSize(entry.getValue(), version)));
        }
        return size;
    }
}

