/*
 * Decompiled with CFR 0.152.
 */
package ch.obermuhlner.math.big.internal;

import ch.obermuhlner.math.big.internal.PowerIterator;
import java.math.BigDecimal;
import java.math.MathContext;

public class PowerTwoNIterator
implements PowerIterator {
    private final MathContext mathContext;
    private final BigDecimal xPowerTwo;
    private BigDecimal powerOfX;

    public PowerTwoNIterator(BigDecimal x, MathContext mathContext) {
        this.mathContext = mathContext;
        this.xPowerTwo = x.multiply(x, mathContext);
        this.powerOfX = BigDecimal.ONE;
    }

    @Override
    public BigDecimal getCurrentPower() {
        return this.powerOfX;
    }

    @Override
    public void calculateNextPower() {
        this.powerOfX = this.powerOfX.multiply(this.xPowerTwo, this.mathContext);
    }
}

