/*
 * Decompiled with CFR 0.152.
 */
package org.apache.cassandra.net;

import com.google.common.annotations.VisibleForTesting;
import io.netty.bootstrap.Bootstrap;
import io.netty.buffer.ByteBuf;
import io.netty.channel.Channel;
import io.netty.channel.ChannelFuture;
import io.netty.channel.ChannelHandler;
import io.netty.channel.ChannelHandlerContext;
import io.netty.channel.ChannelInitializer;
import io.netty.channel.ChannelOption;
import io.netty.channel.ChannelPipeline;
import io.netty.channel.EventLoop;
import io.netty.channel.socket.SocketChannel;
import io.netty.handler.codec.ByteToMessageDecoder;
import io.netty.handler.ssl.SslClosedEngineException;
import io.netty.handler.ssl.SslContext;
import io.netty.handler.ssl.SslHandler;
import io.netty.util.concurrent.Future;
import io.netty.util.concurrent.GenericFutureListener;
import io.netty.util.concurrent.Promise;
import io.netty.util.concurrent.ScheduledFuture;
import java.io.IOException;
import java.net.InetSocketAddress;
import java.net.SocketAddress;
import java.nio.channels.ClosedChannelException;
import java.security.cert.Certificate;
import java.util.List;
import java.util.concurrent.Executor;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicBoolean;
import org.apache.cassandra.auth.IInternodeAuthenticator;
import org.apache.cassandra.locator.InetAddressAndPort;
import org.apache.cassandra.net.AsyncChannelPromise;
import org.apache.cassandra.net.ConnectionType;
import org.apache.cassandra.net.FrameEncoder;
import org.apache.cassandra.net.FrameEncoderCrc;
import org.apache.cassandra.net.FrameEncoderLZ4;
import org.apache.cassandra.net.FrameEncoderUnprotected;
import org.apache.cassandra.net.FutureResult;
import org.apache.cassandra.net.GlobalBufferPoolAllocator;
import org.apache.cassandra.net.HandshakeProtocol;
import org.apache.cassandra.net.InternodeConnectionUtils;
import org.apache.cassandra.net.MessagingService;
import org.apache.cassandra.net.NoSizeEstimator;
import org.apache.cassandra.net.OutboundConnectionSettings;
import org.apache.cassandra.net.SocketFactory;
import org.apache.cassandra.security.ISslContextFactory;
import org.apache.cassandra.security.SSLFactory;
import org.apache.cassandra.utils.JVMStabilityInspector;
import org.apache.cassandra.utils.concurrent.AsyncPromise;
import org.apache.cassandra.utils.concurrent.ImmediateFuture;
import org.apache.cassandra.utils.memory.BufferPools;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class OutboundConnectionInitiator<SuccessType extends Result.Success> {
    private static final Logger logger = LoggerFactory.getLogger(OutboundConnectionInitiator.class);
    private final ConnectionType type;
    private final SslFallbackConnectionType sslConnectionType;
    private final OutboundConnectionSettings settings;
    private final Promise<Result<SuccessType>> resultPromise;
    private boolean isClosed;

    private OutboundConnectionInitiator(ConnectionType type, SslFallbackConnectionType sslConnectionType, OutboundConnectionSettings settings, Promise<Result<SuccessType>> resultPromise) {
        this.type = type;
        this.sslConnectionType = sslConnectionType;
        this.settings = settings;
        this.resultPromise = resultPromise;
    }

    public static Future<Result<Result.StreamingSuccess>> initiateStreaming(EventLoop eventLoop, OutboundConnectionSettings settings, SslFallbackConnectionType sslConnectionType) {
        return new OutboundConnectionInitiator(ConnectionType.STREAMING, sslConnectionType, settings, AsyncPromise.withExecutor((Executor)eventLoop)).initiate(eventLoop);
    }

    static Future<Result<Result.MessagingSuccess>> initiateMessaging(EventLoop eventLoop, ConnectionType type, SslFallbackConnectionType sslConnectionType, OutboundConnectionSettings settings, Promise<Result<Result.MessagingSuccess>> result) {
        return new OutboundConnectionInitiator<Result.MessagingSuccess>(type, sslConnectionType, settings, result).initiate(eventLoop);
    }

    private Future<Result<SuccessType>> initiate(EventLoop eventLoop) {
        if (logger.isTraceEnabled()) {
            logger.trace("creating outbound bootstrap to {}", (Object)this.settings);
        }
        if (!this.settings.authenticator.authenticate(this.settings.to.getAddress(), this.settings.to.getPort(), null, IInternodeAuthenticator.InternodeConnectionDirection.OUTBOUND_PRECONNECT)) {
            MessagingService.instance().interruptOutbound(this.settings.to);
            logger.error("Authentication failed to " + this.settings.connectToId());
            return ImmediateFuture.failure(new IOException("Authentication failed to " + this.settings.connectToId()));
        }
        AtomicBoolean timedout = new AtomicBoolean();
        ChannelFuture bootstrap = this.createBootstrap(eventLoop).connect().addListener(future -> eventLoop.execute(() -> {
            if (!future.isSuccess()) {
                if (future.isCancelled() && !timedout.get()) {
                    this.resultPromise.cancel(true);
                } else if (future.isCancelled()) {
                    this.resultPromise.tryFailure((Throwable)new IOException("Timeout handshaking with " + this.settings.connectToId()));
                } else {
                    this.resultPromise.tryFailure(future.cause());
                }
            }
        }));
        ScheduledFuture timeout = eventLoop.schedule(() -> OutboundConnectionInitiator.lambda$initiate$2(timedout, (Future)bootstrap), HandshakeProtocol.TIMEOUT_MILLIS, TimeUnit.MILLISECONDS);
        bootstrap.addListener(future -> timeout.cancel(true));
        return new FutureResult<Result<SuccessType>>(this.resultPromise, (Future<?>)bootstrap);
    }

    private Bootstrap createBootstrap(EventLoop eventLoop) {
        Bootstrap bootstrap = (Bootstrap)((Bootstrap)((Bootstrap)((Bootstrap)((Bootstrap)((Bootstrap)((Bootstrap)this.settings.socketFactory.newClientBootstrap(eventLoop, this.settings.tcpUserTimeoutInMS).option(ChannelOption.ALLOCATOR, (Object)GlobalBufferPoolAllocator.instance)).option(ChannelOption.CONNECT_TIMEOUT_MILLIS, (Object)this.settings.tcpConnectTimeoutInMS)).option(ChannelOption.SO_KEEPALIVE, (Object)true)).option(ChannelOption.SO_REUSEADDR, (Object)true)).option(ChannelOption.TCP_NODELAY, (Object)this.settings.tcpNoDelay)).option(ChannelOption.MESSAGE_SIZE_ESTIMATOR, (Object)NoSizeEstimator.instance)).handler((ChannelHandler)new Initializer());
        if (this.settings.socketSendBufferSizeInBytes > 0) {
            bootstrap.option(ChannelOption.SO_SNDBUF, (Object)this.settings.socketSendBufferSizeInBytes);
        }
        InetAddressAndPort remoteAddress = this.settings.connectTo;
        bootstrap.remoteAddress((SocketAddress)new InetSocketAddress(remoteAddress.getAddress(), remoteAddress.getPort()));
        return bootstrap;
    }

    private static /* synthetic */ void lambda$initiate$2(AtomicBoolean timedout, Future bootstrap) {
        timedout.set(true);
        bootstrap.cancel(false);
    }

    public static class Result<SuccessType extends Success> {
        final Outcome outcome;

        private Result(Outcome outcome) {
            this.outcome = outcome;
        }

        boolean isSuccess() {
            return this.outcome == Outcome.SUCCESS;
        }

        public SuccessType success() {
            return (SuccessType)((Success)this);
        }

        static MessagingSuccess messagingSuccess(Channel channel, int messagingVersion, FrameEncoder.PayloadAllocator allocator) {
            return new MessagingSuccess(channel, messagingVersion, allocator);
        }

        static StreamingSuccess streamingSuccess(Channel channel, int messagingVersion) {
            return new StreamingSuccess(channel, messagingVersion);
        }

        public Retry retry() {
            return (Retry)this;
        }

        static <SuccessType extends Success> Result<SuccessType> retry(int withMessagingVersion) {
            return new Retry(withMessagingVersion);
        }

        public Incompatible incompatible() {
            return (Incompatible)this;
        }

        static <SuccessType extends Success> Result<SuccessType> incompatible(int closestSupportedVersion, int maxMessagingVersion) {
            return new Incompatible(closestSupportedVersion, maxMessagingVersion);
        }

        static class Incompatible<SuccessType extends Success>
        extends Result<SuccessType> {
            final int closestSupportedVersion;
            final int maxMessagingVersion;

            Incompatible(int closestSupportedVersion, int maxMessagingVersion) {
                super(Outcome.INCOMPATIBLE);
                this.closestSupportedVersion = closestSupportedVersion;
                this.maxMessagingVersion = maxMessagingVersion;
            }
        }

        static class Retry<SuccessType extends Success>
        extends Result<SuccessType> {
            final int withMessagingVersion;

            Retry(int withMessagingVersion) {
                super(Outcome.RETRY);
                this.withMessagingVersion = withMessagingVersion;
            }
        }

        public static class MessagingSuccess
        extends Success<MessagingSuccess> {
            public final FrameEncoder.PayloadAllocator allocator;

            MessagingSuccess(Channel channel, int messagingVersion, FrameEncoder.PayloadAllocator allocator) {
                super(channel, messagingVersion);
                this.allocator = allocator;
            }
        }

        public static class StreamingSuccess
        extends Success<StreamingSuccess> {
            StreamingSuccess(Channel channel, int messagingVersion) {
                super(channel, messagingVersion);
            }
        }

        public static class Success<SuccessType extends Success>
        extends Result<SuccessType> {
            public final Channel channel;
            public final int messagingVersion;

            Success(Channel channel, int messagingVersion) {
                super(Outcome.SUCCESS);
                this.channel = channel;
                this.messagingVersion = messagingVersion;
            }
        }

        static enum Outcome {
            SUCCESS,
            RETRY,
            INCOMPATIBLE;

        }
    }

    private class Handler
    extends ByteToMessageDecoder {
        private Handler() {
        }

        public void channelActive(ChannelHandlerContext ctx) throws Exception {
            HandshakeProtocol.Initiate msg = new HandshakeProtocol.Initiate(OutboundConnectionInitiator.this.settings.acceptVersions, OutboundConnectionInitiator.this.type, OutboundConnectionInitiator.this.settings.framing, OutboundConnectionInitiator.this.settings.from);
            logger.trace("starting handshake with peer {}, msg = {}", (Object)OutboundConnectionInitiator.this.settings.connectToId(), (Object)msg);
            AsyncChannelPromise.writeAndFlush(ctx, (Object)msg.encode(), (GenericFutureListener<? extends Future<? super Void>>)((GenericFutureListener)future -> {
                if (!future.isSuccess()) {
                    this.exceptionCaught(ctx, future.cause());
                }
            }));
            ctx.fireChannelActive();
        }

        public void channelInactive(ChannelHandlerContext ctx) throws Exception {
            super.channelInactive(ctx);
            OutboundConnectionInitiator.this.resultPromise.tryFailure((Throwable)new ClosedChannelException());
        }

        protected void decode(ChannelHandlerContext ctx, ByteBuf in, List<Object> out) {
            try {
                Result.Success result;
                HandshakeProtocol.Accept msg = HandshakeProtocol.Accept.maybeDecode(in);
                if (msg == null) {
                    return;
                }
                int useMessagingVersion = msg.useMessagingVersion;
                int peerMessagingVersion = msg.maxMessagingVersion;
                logger.trace("received second handshake message from peer {}, msg = {}", (Object)OutboundConnectionInitiator.this.settings.connectTo, (Object)msg);
                FrameEncoder frameEncoder = null;
                assert (useMessagingVersion > 0);
                if (useMessagingVersion < OutboundConnectionInitiator.this.settings.acceptVersions.min || useMessagingVersion > OutboundConnectionInitiator.this.settings.acceptVersions.max) {
                    result = Result.incompatible(useMessagingVersion, peerMessagingVersion);
                } else if (OutboundConnectionInitiator.this.type.isMessaging()) {
                    switch (OutboundConnectionInitiator.this.settings.framing) {
                        case LZ4: {
                            frameEncoder = FrameEncoderLZ4.fastInstance;
                            break;
                        }
                        case CRC: {
                            frameEncoder = FrameEncoderCrc.instance;
                            break;
                        }
                        case UNPROTECTED: {
                            frameEncoder = FrameEncoderUnprotected.instance;
                        }
                    }
                    result = Result.messagingSuccess(ctx.channel(), useMessagingVersion, frameEncoder.allocator());
                } else {
                    result = Result.streamingSuccess(ctx.channel(), useMessagingVersion);
                }
                ChannelPipeline pipeline = ctx.pipeline();
                if (result.isSuccess()) {
                    BufferPools.forNetworking().setRecycleWhenFreeForCurrentThread(false);
                    if (OutboundConnectionInitiator.this.type.isMessaging()) {
                        assert (frameEncoder != null);
                        pipeline.addLast("frameEncoder", (ChannelHandler)frameEncoder);
                    }
                    pipeline.remove((ChannelHandler)this);
                } else {
                    pipeline.close();
                }
                if (!OutboundConnectionInitiator.this.resultPromise.trySuccess((Object)result) && result.isSuccess()) {
                    ((Result.Success)result.success()).channel.close();
                }
            }
            catch (Throwable t) {
                this.exceptionCaught(ctx, t);
            }
        }

        public void exceptionCaught(ChannelHandlerContext ctx, Throwable cause) {
            if (OutboundConnectionInitiator.this.isClosed && cause instanceof SslClosedEngineException) {
                return;
            }
            try {
                JVMStabilityInspector.inspectThrowable(cause);
                OutboundConnectionInitiator.this.resultPromise.tryFailure(cause);
                if (SocketFactory.isCausedByConnectionReset(cause)) {
                    logger.info("Failed to connect to peer {}", (Object)OutboundConnectionInitiator.this.settings.connectToId(), (Object)cause);
                } else {
                    logger.error("Failed to handshake with peer {}", (Object)OutboundConnectionInitiator.this.settings.connectToId(), (Object)cause);
                }
                OutboundConnectionInitiator.this.isClosed = true;
                ctx.close();
            }
            catch (Throwable t) {
                logger.error("Unexpected exception in {}.exceptionCaught", (Object)((Object)((Object)this)).getClass().getSimpleName(), (Object)t);
            }
        }
    }

    @VisibleForTesting
    static class ServerAuthenticationHandler
    extends ByteToMessageDecoder {
        final OutboundConnectionSettings settings;

        ServerAuthenticationHandler(OutboundConnectionSettings settings) {
            this.settings = settings;
        }

        protected void decode(ChannelHandlerContext channelHandlerContext, ByteBuf byteBuf, List<Object> list) throws Exception {
            Certificate[] certificates = InternodeConnectionUtils.certificates(channelHandlerContext.channel());
            if (!this.settings.authenticator.authenticate(this.settings.to.getAddress(), this.settings.to.getPort(), certificates, IInternodeAuthenticator.InternodeConnectionDirection.OUTBOUND)) {
                MessagingService.instance().interruptOutbound(this.settings.to);
                logger.error("Authentication failed to " + this.settings.connectToId());
                channelHandlerContext.pipeline().replace((ChannelHandler)this, InternodeConnectionUtils.DISCARD_HANDLER_NAME, (ChannelHandler)new InternodeConnectionUtils.ByteBufDiscardHandler());
                channelHandlerContext.pipeline().close();
            } else {
                channelHandlerContext.pipeline().remove((ChannelHandler)this);
            }
        }
    }

    private class Initializer
    extends ChannelInitializer<SocketChannel> {
        private Initializer() {
        }

        public void initChannel(SocketChannel channel) throws Exception {
            ChannelPipeline pipeline = channel.pipeline();
            if (OutboundConnectionInitiator.this.sslConnectionType == SslFallbackConnectionType.SERVER_CONFIG && OutboundConnectionInitiator.this.settings.withEncryption() || OutboundConnectionInitiator.this.sslConnectionType == SslFallbackConnectionType.SSL || OutboundConnectionInitiator.this.sslConnectionType == SslFallbackConnectionType.MTLS) {
                SslContext sslContext = this.getSslContext(OutboundConnectionInitiator.this.sslConnectionType);
                InetAddressAndPort address = OutboundConnectionInitiator.this.settings.to;
                InetSocketAddress peer = OutboundConnectionInitiator.this.settings.encryption.require_endpoint_verification ? new InetSocketAddress(address.getAddress(), address.getPort()) : null;
                SslHandler sslHandler = SocketFactory.newSslHandler((Channel)channel, sslContext, peer);
                logger.trace("creating outbound netty SslContext: context={}, engine={}", (Object)sslContext.getClass().getName(), (Object)sslHandler.engine().getClass().getName());
                pipeline.addFirst(InternodeConnectionUtils.SSL_HANDLER_NAME, (ChannelHandler)sslHandler);
            }
            pipeline.addLast("server-authentication", (ChannelHandler)new ServerAuthenticationHandler(OutboundConnectionInitiator.this.settings));
            pipeline.addLast("handshake", (ChannelHandler)new Handler());
        }

        private SslContext getSslContext(SslFallbackConnectionType connectionType) throws IOException {
            boolean requireClientAuth = false;
            if (connectionType == SslFallbackConnectionType.MTLS || connectionType == SslFallbackConnectionType.SSL) {
                requireClientAuth = true;
            } else if (connectionType == SslFallbackConnectionType.SERVER_CONFIG) {
                requireClientAuth = OutboundConnectionInitiator.this.settings.withEncryption();
            }
            return SSLFactory.getOrCreateSslContext(OutboundConnectionInitiator.this.settings.encryption, requireClientAuth, ISslContextFactory.SocketType.CLIENT, InternodeConnectionUtils.SSL_FACTORY_CONTEXT_DESCRIPTION);
        }
    }

    public static enum SslFallbackConnectionType {
        SERVER_CONFIG,
        MTLS,
        SSL,
        NO_SSL;

    }
}

