/*
 * Decompiled with CFR 0.152.
 */
package org.apache.cassandra.service;

import com.google.common.annotations.VisibleForTesting;
import com.google.common.collect.ImmutableSet;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.TimeoutException;
import org.apache.cassandra.concurrent.ExecutorFactory;
import org.apache.cassandra.concurrent.SequentialExecutorPlus;
import org.apache.cassandra.db.Keyspace;
import org.apache.cassandra.locator.AbstractReplicationStrategy;
import org.apache.cassandra.schema.Schema;
import org.apache.cassandra.service.PendingRangeCalculatorServiceDiagnostics;
import org.apache.cassandra.service.StorageService;
import org.apache.cassandra.utils.Clock;
import org.apache.cassandra.utils.ExecutorUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class PendingRangeCalculatorService {
    public static final PendingRangeCalculatorService instance = new PendingRangeCalculatorService();
    private static final Logger logger = LoggerFactory.getLogger(PendingRangeCalculatorService.class);
    private final SequentialExecutorPlus executor = (SequentialExecutorPlus)ExecutorFactory.Global.executorFactory().withJmxInternal().configureSequential("PendingRangeCalculator").withRejectedExecutionHandler((r, e) -> {}).build();
    private final SequentialExecutorPlus.AtLeastOnceTrigger update = this.executor.atLeastOnceTrigger(() -> {
        PendingRangeCalculatorServiceDiagnostics.taskStarted(1);
        long start = Clock.Global.currentTimeMillis();
        ImmutableSet<String> keyspaces = Schema.instance.distributedKeyspaces().names();
        for (String keyspaceName : keyspaces) {
            PendingRangeCalculatorService.calculatePendingRanges(Keyspace.open(keyspaceName).getReplicationStrategy(), keyspaceName);
        }
        if (logger.isTraceEnabled()) {
            logger.trace("Finished PendingRangeTask for {} keyspaces in {}ms", (Object)keyspaces.size(), (Object)(Clock.Global.currentTimeMillis() - start));
        }
        PendingRangeCalculatorServiceDiagnostics.taskFinished();
    });

    public void update() {
        boolean success = this.update.trigger();
        if (!success) {
            PendingRangeCalculatorServiceDiagnostics.taskRejected(1);
        } else {
            PendingRangeCalculatorServiceDiagnostics.taskCountChanged(1);
        }
    }

    public void blockUntilFinished() {
        this.update.sync();
    }

    public void executeWhenFinished(Runnable runnable) {
        this.update.runAfter(runnable);
    }

    public static void calculatePendingRanges(AbstractReplicationStrategy strategy, String keyspaceName) {
        StorageService.instance.getTokenMetadata().calculatePendingRanges(strategy, keyspaceName);
    }

    @VisibleForTesting
    public void shutdownAndWait(long timeout, TimeUnit unit) throws InterruptedException, TimeoutException {
        ExecutorUtils.shutdownNowAndWait(timeout, unit, this.executor);
    }
}

