/*
 * Decompiled with CFR 0.152.
 */
package com.datastax.oss.driver.internal.mapper.processor.entity;

import com.datastax.oss.driver.api.core.CqlIdentifier;
import com.datastax.oss.driver.api.core.metadata.schema.KeyspaceMetadata;
import com.datastax.oss.driver.api.core.metadata.schema.TableMetadata;
import com.datastax.oss.driver.api.core.type.DataType;
import com.datastax.oss.driver.api.core.type.UserDefinedType;
import com.datastax.oss.driver.api.core.type.reflect.GenericType;
import com.datastax.oss.driver.api.mapper.annotations.SchemaHint;
import com.datastax.oss.driver.internal.mapper.processor.MethodGenerator;
import com.datastax.oss.driver.internal.mapper.processor.dao.LoggingGenerator;
import com.datastax.oss.driver.internal.mapper.processor.entity.EntityDefinition;
import com.datastax.oss.driver.internal.mapper.processor.entity.EntityHelperGenerator;
import com.datastax.oss.driver.internal.mapper.processor.entity.PropertyDefinition;
import com.squareup.javapoet.CodeBlock;
import com.squareup.javapoet.MethodSpec;
import com.squareup.javapoet.TypeName;
import java.util.ArrayList;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.stream.Collectors;
import javax.lang.model.element.Modifier;
import javax.lang.model.element.TypeElement;

public class EntityHelperSchemaValidationMethodGenerator
implements MethodGenerator {
    private final EntityDefinition entityDefinition;
    private TypeElement entityTypeElement;
    private LoggingGenerator loggingGenerator;
    private EntityHelperGenerator entityHelperGenerator;

    public EntityHelperSchemaValidationMethodGenerator(EntityDefinition entityDefinition, TypeElement entityTypeElement, LoggingGenerator loggingGenerator, EntityHelperGenerator entityHelperGenerator) {
        this.entityDefinition = entityDefinition;
        this.entityTypeElement = entityTypeElement;
        this.loggingGenerator = loggingGenerator;
        this.entityHelperGenerator = entityHelperGenerator;
    }

    @Override
    public Optional<MethodSpec> generate() {
        MethodSpec.Builder methodBuilder = MethodSpec.methodBuilder((String)"validateEntityFields").addAnnotation(Override.class).addModifiers(new Modifier[]{Modifier.PUBLIC}).returns(TypeName.VOID);
        Optional<SchemaHint.TargetElement> targetElement = Optional.ofNullable(this.entityTypeElement.getAnnotation(SchemaHint.class)).map(SchemaHint::targetElement);
        if (targetElement.isPresent() && targetElement.get() == SchemaHint.TargetElement.NONE) {
            methodBuilder.addComment("Nothing to do, validation was disabled with @SchemaHint(targetElement = NONE)", new Object[0]);
        } else {
            methodBuilder.addStatement("$1T keyspaceId = this.keyspaceId != null ? this.keyspaceId : context.getSession().getKeyspace().orElse(null)", new Object[]{CqlIdentifier.class});
            methodBuilder.addStatement("String entityClassName = $S", new Object[]{this.entityDefinition.getClassName()});
            this.generateKeyspaceNull(methodBuilder);
            this.generateKeyspaceNameWrong(methodBuilder);
            methodBuilder.addStatement("$1T<$2T> keyspace = context.getSession().getMetadata().getKeyspace(keyspaceId)", new Object[]{Optional.class, KeyspaceMetadata.class});
            List expectedCqlNames = this.entityDefinition.getAllColumns().stream().map(PropertyDefinition::getCqlName).collect(Collectors.toList());
            methodBuilder.addStatement("$1T<$2T> expectedCqlNames = new $3T<>()", new Object[]{List.class, CqlIdentifier.class, ArrayList.class});
            for (CodeBlock expectedCqlName : expectedCqlNames) {
                methodBuilder.addStatement("expectedCqlNames.add($1T.fromCql($2L))", new Object[]{CqlIdentifier.class, expectedCqlName});
            }
            methodBuilder.addStatement("$1T<$2T> tableMetadata = keyspace.flatMap(v -> v.getTable(tableId))", new Object[]{Optional.class, TableMetadata.class});
            methodBuilder.addStatement("$1T<$2T> userDefinedType = keyspace.flatMap(v -> v.getUserDefinedType(tableId))", new Object[]{Optional.class, UserDefinedType.class});
            this.generateValidationChecks(methodBuilder, targetElement);
            this.logMissingMetadata(methodBuilder);
        }
        return Optional.of(methodBuilder.build());
    }

    private void logMissingMetadata(MethodSpec.Builder methodBuilder) {
        methodBuilder.addComment("warn if there is not keyspace.table for defined entity - it means that table is missing, or schema it out of date.", new Object[0]);
        methodBuilder.beginControlFlow("else", new Object[0]);
        this.loggingGenerator.warn(methodBuilder, "[{}] There is no ks.table or UDT: {}.{} for the entity class: {}, or metadata is out of date.", CodeBlock.of((String)"context.getSession().getName()", (Object[])new Object[0]), CodeBlock.of((String)"keyspaceId", (Object[])new Object[0]), CodeBlock.of((String)"tableId", (Object[])new Object[0]), CodeBlock.of((String)"entityClassName", (Object[])new Object[0]));
        methodBuilder.endControlFlow();
    }

    private void generateKeyspaceNameWrong(MethodSpec.Builder methodBuilder) {
        methodBuilder.beginControlFlow("if(!keyspaceNamePresent(context.getSession().getMetadata().getKeyspaces(), keyspaceId))", new Object[0]);
        this.loggingGenerator.warn(methodBuilder, "[{}] Unable to validate table: {} for the entity class: {} because the session metadata has no information about the keyspace: {}.", CodeBlock.of((String)"context.getSession().getName()", (Object[])new Object[0]), CodeBlock.of((String)"tableId", (Object[])new Object[0]), CodeBlock.of((String)"entityClassName", (Object[])new Object[0]), CodeBlock.of((String)"keyspaceId", (Object[])new Object[0]));
        methodBuilder.addStatement("return", new Object[0]);
        methodBuilder.endControlFlow();
    }

    private void generateKeyspaceNull(MethodSpec.Builder methodBuilder) {
        methodBuilder.beginControlFlow("if (keyspaceId == null)", new Object[0]);
        this.loggingGenerator.warn(methodBuilder, "[{}] Unable to validate table: {} for the entity class: {} because the keyspace is unknown (the entity does not declare a default keyspace, and neither the session nor the DAO were created with a keyspace). The DAO will only work if it uses fully-qualified queries with @Query or @QueryProvider.", CodeBlock.of((String)"context.getSession().getName()", (Object[])new Object[0]), CodeBlock.of((String)"tableId", (Object[])new Object[0]), CodeBlock.of((String)"entityClassName", (Object[])new Object[0]));
        methodBuilder.addStatement("return", new Object[0]);
        methodBuilder.endControlFlow();
    }

    private void generateValidationChecks(MethodSpec.Builder methodBuilder, Optional<SchemaHint.TargetElement> targetElement) {
        if (!targetElement.isPresent()) {
            this.validateColumnsInTable(methodBuilder);
            this.validateColumnsInUdt(methodBuilder, true);
        } else if (targetElement.get().equals((Object)SchemaHint.TargetElement.TABLE)) {
            this.validateColumnsInTable(methodBuilder);
        } else if (targetElement.get().equals((Object)SchemaHint.TargetElement.UDT)) {
            this.validateColumnsInUdt(methodBuilder, false);
        }
    }

    private void validateColumnsInTable(MethodSpec.Builder methodBuilder) {
        methodBuilder.beginControlFlow("if (tableMetadata.isPresent())", new Object[0]);
        this.generateMissingClusteringColumnsCheck(methodBuilder);
        this.generateMissingPKsCheck(methodBuilder);
        this.generateMissingColumnsCheck(methodBuilder);
        this.generateColumnsTypeCheck(methodBuilder);
        methodBuilder.endControlFlow();
    }

    private void generateColumnsTypeCheck(MethodSpec.Builder methodBuilder) {
        methodBuilder.addComment("validation of types", new Object[0]);
        this.generateExpectedTypesPerColumn(methodBuilder);
        methodBuilder.addStatement("$1T<$2T> missingTableTypes = findTypeMismatches(expectedTypesPerColumn, tableMetadata.get().getColumns(), context.getSession().getContext().getCodecRegistry())", new Object[]{List.class, String.class});
        methodBuilder.addStatement("throwMissingTableTypesIfNotEmpty(missingTableTypes, keyspaceId, tableId, entityClassName)", new Object[0]);
    }

    private void generateMissingColumnsCheck(MethodSpec.Builder methodBuilder) {
        methodBuilder.addComment("validation of all columns", new Object[0]);
        methodBuilder.addStatement("$1T<$2T> missingTableCqlNames = findMissingCqlIdentifiers(expectedCqlNames, tableMetadata.get().getColumns().keySet())", new Object[]{List.class, CqlIdentifier.class});
        CodeBlock missingCqlColumnExceptionMessage = CodeBlock.of((String)"String.format(\"The CQL ks.table: %s.%s has missing columns: %s that are defined in the entity class: %s\", keyspaceId, tableId, missingTableCqlNames, entityClassName)", (Object[])new Object[0]);
        methodBuilder.beginControlFlow("if (!missingTableCqlNames.isEmpty())", new Object[0]);
        methodBuilder.addStatement("throw new $1T($2L)", new Object[]{IllegalArgumentException.class, missingCqlColumnExceptionMessage});
        methodBuilder.endControlFlow();
    }

    private void generateMissingPKsCheck(MethodSpec.Builder methodBuilder) {
        methodBuilder.addComment("validation of missing PKs", new Object[0]);
        List expectedCqlPKs = this.entityDefinition.getPartitionKey().stream().map(PropertyDefinition::getCqlName).collect(Collectors.toList());
        methodBuilder.addStatement("$1T<$2T> expectedCqlPKs = new $3T<>()", new Object[]{List.class, CqlIdentifier.class, ArrayList.class});
        for (CodeBlock expectedCqlName : expectedCqlPKs) {
            methodBuilder.addStatement("expectedCqlPKs.add($1T.fromCql($2L))", new Object[]{CqlIdentifier.class, expectedCqlName});
        }
        methodBuilder.addStatement("$1T<$2T> missingTablePksNames = findMissingColumns(expectedCqlPKs, tableMetadata.get().getPartitionKey())", new Object[]{List.class, CqlIdentifier.class});
        CodeBlock missingCqlColumnExceptionMessage = CodeBlock.of((String)"String.format(\"The CQL ks.table: %s.%s has missing Primary Key columns: %s that are defined in the entity class: %s\", keyspaceId, tableId, missingTablePksNames, entityClassName)", (Object[])new Object[0]);
        methodBuilder.beginControlFlow("if (!missingTablePksNames.isEmpty())", new Object[0]);
        methodBuilder.addStatement("throw new $1T($2L)", new Object[]{IllegalArgumentException.class, missingCqlColumnExceptionMessage});
        methodBuilder.endControlFlow();
    }

    private void generateMissingClusteringColumnsCheck(MethodSpec.Builder methodBuilder) {
        List expectedCqlClusteringColumns = this.entityDefinition.getClusteringColumns().stream().map(PropertyDefinition::getCqlName).collect(Collectors.toList());
        if (!expectedCqlClusteringColumns.isEmpty()) {
            methodBuilder.addComment("validation of missing Clustering Columns", new Object[0]);
            methodBuilder.addStatement("$1T<$2T> expectedCqlClusteringColumns = new $3T<>()", new Object[]{List.class, CqlIdentifier.class, ArrayList.class});
            for (CodeBlock expectedCqlName : expectedCqlClusteringColumns) {
                methodBuilder.addStatement("expectedCqlClusteringColumns.add($1T.fromCql($2L))", new Object[]{CqlIdentifier.class, expectedCqlName});
            }
            methodBuilder.addStatement("$1T<$2T> missingTableClusteringColumnNames = findMissingColumns(expectedCqlClusteringColumns, tableMetadata.get().getClusteringColumns().keySet())", new Object[]{List.class, CqlIdentifier.class});
            CodeBlock missingCqlColumnExceptionMessage = CodeBlock.of((String)"String.format(\"The CQL ks.table: %s.%s has missing Clustering columns: %s that are defined in the entity class: %s\", keyspaceId, tableId, missingTableClusteringColumnNames, entityClassName)", (Object[])new Object[0]);
            methodBuilder.beginControlFlow("if (!missingTableClusteringColumnNames.isEmpty())", new Object[0]);
            methodBuilder.addStatement("throw new $1T($2L)", new Object[]{IllegalArgumentException.class, missingCqlColumnExceptionMessage});
            methodBuilder.endControlFlow();
        }
    }

    private void validateColumnsInUdt(MethodSpec.Builder methodBuilder, boolean generateElse) {
        if (generateElse) {
            methodBuilder.beginControlFlow("else if (userDefinedType.isPresent())", new Object[0]);
        } else {
            methodBuilder.beginControlFlow("if (userDefinedType.isPresent())", new Object[0]);
        }
        this.generateUdtMissingColumnsCheck(methodBuilder);
        this.generateUdtColumnsTypeCheck(methodBuilder);
        methodBuilder.endControlFlow();
    }

    private void generateUdtColumnsTypeCheck(MethodSpec.Builder methodBuilder) {
        methodBuilder.addComment("validation of UDT types", new Object[0]);
        this.generateExpectedTypesPerColumn(methodBuilder);
        methodBuilder.addStatement("$1T<$2T> expectedColumns = userDefinedType.get().getFieldNames()", new Object[]{List.class, CqlIdentifier.class});
        methodBuilder.addStatement("$1T<$2T> expectedTypes = userDefinedType.get().getFieldTypes()", new Object[]{List.class, DataType.class});
        methodBuilder.addStatement("$1T<$2T> missingTableTypes = findTypeMismatches(expectedTypesPerColumn, expectedColumns, expectedTypes, context.getSession().getContext().getCodecRegistry())", new Object[]{List.class, String.class});
        methodBuilder.addStatement("throwMissingUdtTypesIfNotEmpty(missingTableTypes, keyspaceId, tableId, entityClassName)", new Object[0]);
    }

    private void generateUdtMissingColumnsCheck(MethodSpec.Builder methodBuilder) {
        methodBuilder.addComment("validation of UDT columns", new Object[0]);
        methodBuilder.addStatement("$1T<$2T> columns = userDefinedType.get().getFieldNames()", new Object[]{List.class, CqlIdentifier.class});
        methodBuilder.addStatement("$1T<$2T> missingTableCqlNames = findMissingCqlIdentifiers(expectedCqlNames, columns)", new Object[]{List.class, CqlIdentifier.class});
        CodeBlock missingCqlUdtExceptionMessage = CodeBlock.of((String)"String.format(\"The CQL ks.udt: %s.%s has missing columns: %s that are defined in the entity class: %s\", keyspaceId, tableId, missingTableCqlNames, entityClassName)", (Object[])new Object[0]);
        methodBuilder.beginControlFlow("if (!missingTableCqlNames.isEmpty())", new Object[0]);
        methodBuilder.addStatement("throw new $1T($2L)", new Object[]{IllegalArgumentException.class, missingCqlUdtExceptionMessage});
        methodBuilder.endControlFlow();
    }

    private void generateExpectedTypesPerColumn(MethodSpec.Builder methodBuilder) {
        methodBuilder.addStatement("$1T<$2T, $3T<?>> expectedTypesPerColumn = new $4T<>()", new Object[]{Map.class, CqlIdentifier.class, GenericType.class, LinkedHashMap.class});
        Map<CodeBlock, TypeName> expectedTypesPerColumn = this.entityDefinition.getAllColumns().stream().collect(Collectors.toMap(PropertyDefinition::getCqlName, v -> v.getType().asRawTypeName()));
        for (Map.Entry<CodeBlock, TypeName> expected : expectedTypesPerColumn.entrySet()) {
            methodBuilder.addStatement("expectedTypesPerColumn.put($1T.fromCql($2L), $3L)", new Object[]{CqlIdentifier.class, expected.getKey(), this.entityHelperGenerator.addGenericTypeConstant(expected.getValue().box())});
        }
    }
}

