/*
 * Decompiled with CFR 0.152.
 */
package foundrylogic.vpp;

import foundrylogic.vpp.VPPConfig;
import foundrylogic.vpp.VPPCopy;
import java.io.File;
import org.apache.tools.ant.BuildException;
import org.apache.tools.ant.taskdefs.Delete;
import org.apache.tools.ant.taskdefs.Javac;
import org.apache.tools.ant.types.FileSet;
import org.apache.tools.ant.types.Mapper;
import org.apache.tools.ant.types.Path;
import org.apache.tools.ant.types.PatternSet;
import org.apache.tools.ant.types.selectors.FileSelector;

public class VPPJavac
extends Javac {
    private boolean preprocess = true;
    private boolean keep = true;
    private File prepdir;
    private VPPCopy vppCopy;

    public boolean getPreprocess() {
        return this.preprocess;
    }

    public void setPreprocess(boolean bl) {
        this.preprocess = bl;
    }

    public boolean getKeep() {
        return this.keep;
    }

    public void setKeep(boolean bl) {
        this.keep = bl;
    }

    public File getPrepdir() {
        return this.prepdir;
    }

    public void setPrepdir(File file) {
        this.prepdir = file;
    }

    public void execute() throws BuildException {
        if (!this.getPreprocess()) {
            super.execute();
            return;
        }
        Path path = this.getSrcdir();
        if (path == null) {
            throw new BuildException("srcdir attribute must be set!", this.getLocation());
        }
        String[] stringArray = path.list();
        if (stringArray.length == 0) {
            throw new BuildException("srcdir attribute must be set!", this.getLocation());
        }
        File file = this.getDestdir();
        if (file != null && !file.isDirectory()) {
            throw new BuildException("destination directory '" + file + "' does not exist or is not a directory", this.getLocation());
        }
        this.preprocess();
        this.recreateSrc();
        this.setSrcdir(new Path(this.getProject(), this.prepdir.getAbsolutePath()));
        super.execute();
        if (!this.keep) {
            this.deletePrepdir();
        }
    }

    private void preprocess() {
        String string;
        this.preparePrepdir();
        this.vppCopy.init();
        FileSelector[] fileSelectorArray = this.getSelectors(this.getProject());
        String[] stringArray = this.getSrcdir().list();
        for (int i = 0; i < stringArray.length; ++i) {
            string = stringArray[i];
            FileSet fileSet = new FileSet();
            fileSet.setDir(new File(string));
            this.vppCopy.addFileset(fileSet);
            for (int j = 0; j < fileSelectorArray.length; ++j) {
                FileSelector fileSelector = fileSelectorArray[j];
                fileSet.appendSelector(fileSelector);
            }
        }
        this.vppCopy.setTodir(this.prepdir);
        Mapper mapper = this.vppCopy.createMapper();
        mapper.setFrom("*.java");
        mapper.setTo("*.java");
        string = new Mapper.MapperType();
        string.setValue("glob");
        mapper.setType((Mapper.MapperType)string);
        this.vppCopy.execute();
    }

    protected void preparePrepdir() {
        if (this.prepdir == null) {
            String string = this.getProject().getBaseDir().getAbsolutePath() + File.separator + "vppjavac.out";
            this.prepdir = new File(string);
        }
        if (!this.prepdir.exists()) {
            this.prepdir.mkdirs();
        }
    }

    protected void deletePrepdir() {
        if (this.prepdir.exists()) {
            FileSet fileSet = new FileSet();
            fileSet.setDir(this.prepdir);
            PatternSet.NameEntry nameEntry = fileSet.createInclude();
            nameEntry.setName("**");
            Delete delete2 = new Delete();
            delete2.setTaskName(this.getTaskName());
            delete2.setProject(this.getProject());
            delete2.setIncludeEmptyDirs(true);
            delete2.setFailOnError(false);
            delete2.setVerbose(false);
            delete2.addFileset(fileSet);
            delete2.execute();
        }
    }

    public void init() {
        if (this.vppCopy == null) {
            this.vppCopy = new VPPCopy();
            this.vppCopy.setProject(this.getProject());
            this.vppCopy.setTaskName(this.getTaskName());
            this.vppCopy.setLocation(this.getLocation());
        }
    }

    public void addConfiguredConfig(VPPConfig vPPConfig) {
        this.vppCopy.addConfiguredConfig(vPPConfig);
    }
}

