/*
 * Decompiled with CFR 0.152.
 */
package org.apache.cayenne.lifecycle.id;

import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import org.apache.cayenne.ObjectId;
import org.apache.cayenne.Persistent;
import org.apache.cayenne.lifecycle.id.EntityIdCoder;
import org.apache.cayenne.map.EntityResolver;
import org.apache.cayenne.map.ObjEntity;

public class IdCoder {
    protected EntityResolver entityResolver;
    protected Map<String, EntityIdCoder> coders;

    public IdCoder(EntityResolver entityResolver) {
        this.entityResolver = entityResolver;
        this.coders = new ConcurrentHashMap<String, EntityIdCoder>();
    }

    public ObjectId getObjectId(String id) {
        String entityName = EntityIdCoder.getEntityName(id);
        EntityIdCoder coder = this.getCoder(entityName);
        return coder.toObjectId(id);
    }

    public String getStringId(Persistent referenceable) {
        if (referenceable == null) {
            throw new NullPointerException("Null object");
        }
        ObjectId id = referenceable.getObjectId();
        EntityIdCoder coder = this.getCoder(id.getEntityName());
        return coder.toStringId(id);
    }

    protected EntityIdCoder getCoder(String entityName) {
        EntityIdCoder coder = this.coders.get(entityName);
        if (coder == null) {
            coder = this.createCoder(entityName);
            this.coders.put(entityName, coder);
        }
        return coder;
    }

    protected EntityIdCoder createCoder(String entityName) {
        ObjEntity entity = this.entityResolver.getObjEntity(entityName);
        if (entity == null) {
            throw new IllegalArgumentException("Entity '" + entityName + "' is not mapped");
        }
        return new EntityIdCoder(entity);
    }
}

