/*
 * Decompiled with CFR 0.152.
 */
package org.apache.cayenne.project.validation;

import java.util.Iterator;
import org.apache.cayenne.exp.Expression;
import org.apache.cayenne.exp.ExpressionException;
import org.apache.cayenne.map.DataMap;
import org.apache.cayenne.map.Entity;
import org.apache.cayenne.map.QueryDescriptor;
import org.apache.cayenne.map.SelectQueryDescriptor;
import org.apache.cayenne.project.validation.BaseQueryValidator;
import org.apache.cayenne.query.Ordering;
import org.apache.cayenne.util.CayenneMapEntry;
import org.apache.cayenne.validation.ValidationResult;

class SelectQueryValidator
extends BaseQueryValidator {
    SelectQueryValidator() {
    }

    void validate(SelectQueryDescriptor query, ValidationResult validationResult) {
        this.validateName(query, validationResult);
        this.validateCacheGroup(query, validationResult);
        Entity root = this.validateRoot(query, validationResult);
        if (root != null) {
            this.validateQualifier(root, query.getQualifier(), validationResult);
            for (Ordering ordering : query.getOrderings()) {
                this.validateOrdering(query, root, ordering, validationResult);
            }
            if (query.getPrefetchesMap() != null) {
                for (String prefetchPath : query.getPrefetchesMap().keySet()) {
                    this.validatePrefetch(root, prefetchPath, validationResult);
                }
            }
        }
    }

    void validatePrefetch(Entity root, String path, ValidationResult validationResult) {
    }

    void validateOrdering(QueryDescriptor query, Entity root, Ordering ordering, ValidationResult validationResult) {
        String path = ordering.getSortSpecString();
        Iterator<CayenneMapEntry> it = root.resolvePathComponents(path);
        while (it.hasNext()) {
            try {
                it.next();
            }
            catch (ExpressionException e) {
                this.addFailure(validationResult, query, "Invalid ordering path: '%s'", path);
            }
        }
    }

    void validateQualifier(Entity root, Expression qualifier, ValidationResult validationResult) {
    }

    Entity validateRoot(QueryDescriptor query, ValidationResult validationResult) {
        DataMap parent;
        DataMap map = query.getDataMap();
        if (query.getRoot() == null && map != null) {
            this.addFailure(validationResult, query, "Query '%s' has no root", query.getName());
            return null;
        }
        if (query.getRoot() == map) {
            return null;
        }
        if (map == null) {
            return query.getRoot() instanceof Entity ? (Entity)query.getRoot() : null;
        }
        if (query.getRoot() instanceof Entity) {
            return (Entity)query.getRoot();
        }
        if (query.getRoot() instanceof Class) {
            return null;
        }
        if (query.getRoot() instanceof String && (parent = query.getDataMap()) != null) {
            return parent.getNamespace().getObjEntity((String)query.getRoot());
        }
        return null;
    }
}

