/*
 * Decompiled with CFR 0.152.
 */
package org.apache.cayenne.crypto.cipher;

import java.security.NoSuchAlgorithmException;
import java.util.Map;
import javax.crypto.Cipher;
import javax.crypto.NoSuchPaddingException;
import org.apache.cayenne.crypto.CayenneCryptoException;
import org.apache.cayenne.crypto.cipher.CipherFactory;
import org.apache.cayenne.di.Inject;

public class DefaultCipherFactory
implements CipherFactory {
    protected String transformation;
    protected int blockSize;

    public DefaultCipherFactory(@Inject(value="cayenne.crypto.properties") Map<String, String> properties) {
        String algorithm = properties.get("cayenne.crypto.cipher.algorithm");
        if (algorithm == null) {
            throw new CayenneCryptoException("Cipher algorithm is not set. Property name: cayenne.crypto.cipher.algorithm", new Object[0]);
        }
        String mode = properties.get("cayenne.crypto.cipher.mode");
        if (mode == null) {
            throw new CayenneCryptoException("Cipher mode is not set. Property name: cayenne.crypto.cipher.mode", new Object[0]);
        }
        String padding = properties.get("cayenne.crypto.cipher.padding");
        if (padding == null) {
            throw new CayenneCryptoException("Cipher padding is not set. Property name: cayenne.crypto.cipher.padding", new Object[0]);
        }
        this.transformation = algorithm + "/" + mode + "/" + padding;
    }

    @Override
    public Cipher cipher() {
        try {
            return Cipher.getInstance(this.transformation);
        }
        catch (NoSuchAlgorithmException e) {
            throw new CayenneCryptoException("Error instantiating a cipher - no such algorithm: " + this.transformation, e, new Object[0]);
        }
        catch (NoSuchPaddingException e) {
            throw new CayenneCryptoException("Error instantiating a cipher - no such padding: " + this.transformation, e, new Object[0]);
        }
    }

    @Override
    public int blockSize() {
        if (this.blockSize == 0) {
            this.blockSize = this.cipher().getBlockSize();
        }
        return this.blockSize;
    }
}

