/*
 * Decompiled with CFR 0.152.
 */
package org.apache.commons.beanutils2;

import java.beans.IntrospectionException;
import java.beans.PropertyDescriptor;
import java.util.Arrays;
import java.util.HashSet;
import java.util.Set;
import org.apache.commons.beanutils2.IntrospectionContext;
import org.apache.commons.beanutils2.SuppressPropertiesBeanIntrospector;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.Test;

public class SuppressPropertiesBeanIntrospectorTest {
    @Test
    public void testGetSuppressedPropertiesModify() {
        SuppressPropertiesBeanIntrospector introspector = new SuppressPropertiesBeanIntrospector(Arrays.asList("p1", "p2"));
        Set properties = introspector.getSuppressedProperties();
        Assertions.assertThrows(UnsupportedOperationException.class, () -> properties.add("anotherProperty"));
    }

    @Test
    public void testInitNoPropertyNames() {
        Assertions.assertThrows(NullPointerException.class, () -> new SuppressPropertiesBeanIntrospector(null));
    }

    @Test
    public void testPropertyNamesDefensiveCopy() throws IntrospectionException {
        HashSet<String> properties = new HashSet<String>();
        properties.add("prop1");
        SuppressPropertiesBeanIntrospector introspector = new SuppressPropertiesBeanIntrospector(properties);
        properties.add("prop2");
        IntrospectionContextTestImpl context = new IntrospectionContextTestImpl();
        introspector.introspect((IntrospectionContext)context);
        Assertions.assertEquals((int)1, (int)context.getRemovedProperties().size(), (String)"Wrong number of removed properties");
        Assertions.assertTrue((boolean)context.getRemovedProperties().contains("prop1"), (String)"Wrong removed property");
    }

    @Test
    public void testRemovePropertiesDuringIntrospection() throws IntrospectionException {
        String[] properties = new String[]{"test", "other", "oneMore"};
        SuppressPropertiesBeanIntrospector introspector = new SuppressPropertiesBeanIntrospector(Arrays.asList(properties));
        IntrospectionContextTestImpl context = new IntrospectionContextTestImpl();
        introspector.introspect((IntrospectionContext)context);
        Assertions.assertEquals((int)properties.length, (int)context.getRemovedProperties().size(), (String)"Wrong number of removed properties");
        for (String property : properties) {
            Assertions.assertTrue((boolean)context.getRemovedProperties().contains(property), (String)("Property not removed: " + property));
        }
    }

    private static class IntrospectionContextTestImpl
    implements IntrospectionContext {
        private final Set<String> removedProperties = new HashSet<String>();

        private IntrospectionContextTestImpl() {
        }

        public void addPropertyDescriptor(PropertyDescriptor desc) {
            throw new UnsupportedOperationException("Unexpected method call!");
        }

        public void addPropertyDescriptors(PropertyDescriptor[] descriptors) {
            throw new UnsupportedOperationException("Unexpected method call!");
        }

        public PropertyDescriptor getPropertyDescriptor(String name) {
            throw new UnsupportedOperationException("Unexpected method call!");
        }

        public Set<String> getRemovedProperties() {
            return this.removedProperties;
        }

        public Class<?> getTargetClass() {
            throw new UnsupportedOperationException("Unexpected method call!");
        }

        public boolean hasProperty(String name) {
            throw new UnsupportedOperationException("Unexpected method call!");
        }

        public Set<String> propertyNames() {
            throw new UnsupportedOperationException("Unexpected method call!");
        }

        public void removePropertyDescriptor(String name) {
            this.removedProperties.add(name);
        }
    }
}

