/*
 * Decompiled with CFR 0.152.
 */
package org.apache.datasketches.tuple.arrayofdoubles;

import java.lang.foreign.MemorySegment;
import java.lang.foreign.ValueLayout;
import org.apache.datasketches.common.Family;
import org.apache.datasketches.common.SketchesArgumentException;
import org.apache.datasketches.tuple.SerializerDeserializer;
import org.apache.datasketches.tuple.arrayofdoubles.ArrayOfDoublesQuickSelectSketch;
import org.apache.datasketches.tuple.arrayofdoubles.ArrayOfDoublesUnion;
import org.apache.datasketches.tuple.arrayofdoubles.DirectArrayOfDoublesQuickSelectSketch;
import org.apache.datasketches.tuple.arrayofdoubles.DirectArrayOfDoublesQuickSelectSketchR;
import org.apache.datasketches.tuple.arrayofdoubles.DirectArrayOfDoublesUnionR;

class DirectArrayOfDoublesUnion
extends ArrayOfDoublesUnion {
    final MemorySegment seg_;

    DirectArrayOfDoublesUnion(int nomEntries, int numValues, long seed, MemorySegment dstSeg) {
        super(new DirectArrayOfDoublesQuickSelectSketch(nomEntries, 3, 1.0f, numValues, seed, dstSeg.asSlice(16L, dstSeg.byteSize() - 16L)));
        this.seg_ = dstSeg;
        this.seg_.set(ValueLayout.JAVA_BYTE, 0L, (byte)1);
        this.seg_.set(ValueLayout.JAVA_BYTE, 1L, (byte)1);
        this.seg_.set(ValueLayout.JAVA_BYTE, 2L, (byte)Family.TUPLE.getID());
        this.seg_.set(ValueLayout.JAVA_BYTE, 3L, (byte)SerializerDeserializer.SketchType.ArrayOfDoublesUnion.ordinal());
        this.seg_.set(ValueLayout.JAVA_LONG_UNALIGNED, 8L, this.gadget_.getThetaLong());
    }

    DirectArrayOfDoublesUnion(ArrayOfDoublesQuickSelectSketch gadget, MemorySegment seg) {
        super(gadget);
        this.seg_ = seg;
        this.unionThetaLong_ = seg.get(ValueLayout.JAVA_LONG_UNALIGNED, 8L);
    }

    @Override
    void setUnionThetaLong(long thetaLong) {
        super.setUnionThetaLong(thetaLong);
        this.seg_.set(ValueLayout.JAVA_LONG_UNALIGNED, 8L, thetaLong);
    }

    static ArrayOfDoublesUnion wrapUnion(MemorySegment seg, long seed, boolean isWritable) {
        byte version = seg.get(ValueLayout.JAVA_BYTE, 1L);
        if (version != 1) {
            throw new SketchesArgumentException("Serial version mismatch. Expected: 1, actual: " + version);
        }
        SerializerDeserializer.validateFamily(seg.get(ValueLayout.JAVA_BYTE, 2L), seg.get(ValueLayout.JAVA_BYTE, 0L));
        SerializerDeserializer.validateType(seg.get(ValueLayout.JAVA_BYTE, 3L), SerializerDeserializer.SketchType.ArrayOfDoublesUnion);
        if (isWritable) {
            MemorySegment sketchSeg = seg.asSlice(16L, seg.byteSize() - 16L);
            return new DirectArrayOfDoublesUnion(new DirectArrayOfDoublesQuickSelectSketch(sketchSeg, seed), seg);
        }
        MemorySegment sketchSeg = seg.asSlice(16L, seg.byteSize() - 16L);
        return new DirectArrayOfDoublesUnionR(new DirectArrayOfDoublesQuickSelectSketchR(sketchSeg, seed), seg);
    }
}

