/*
 * Decompiled with CFR 0.152.
 */
package org.apache.datasketches.memory.internal;

import java.nio.ByteBuffer;
import java.nio.ByteOrder;
import org.apache.datasketches.memory.Buffer;
import org.apache.datasketches.memory.Memory;
import org.apache.datasketches.memory.MemoryBoundsException;
import org.apache.datasketches.memory.ReadOnlyException;
import org.apache.datasketches.memory.Resource;
import org.apache.datasketches.memory.WritableBuffer;
import org.apache.datasketches.memory.WritableMemory;
import org.apache.datasketches.memory.internal.ResourceImpl;
import org.apache.datasketches.memory.internal.Util;
import org.testng.Assert;
import org.testng.annotations.Test;

public class NativeWritableBufferImplTest {
    @Test
    public void checkNativeCapacityAndClose() {
        int memCapacity = 64;
        WritableMemory wmem = WritableMemory.allocateDirect((long)memCapacity);
        WritableBuffer wbuf = wmem.asWritableBuffer();
        Assert.assertEquals((long)wbuf.getCapacity(), (long)memCapacity);
        wmem.close();
        Assert.assertFalse((boolean)wbuf.isAlive());
    }

    @Test
    public void checkByteArray() {
        byte[] srcArray = new byte[]{1, -2, 3, -4, 5, -6, 7, -8};
        byte[] dstArray = new byte[8];
        Buffer buf = Memory.wrap((byte[])srcArray).asBuffer();
        buf.getByteArray(dstArray, 0, 8);
        for (int i = 0; i < 8; ++i) {
            Assert.assertEquals((byte)dstArray[i], (byte)srcArray[i]);
        }
        WritableBuffer wbuf = WritableMemory.writableWrap((byte[])srcArray).asWritableBuffer();
        wbuf.getByteArray(dstArray, 0, 8);
        for (int i = 0; i < 8; ++i) {
            Assert.assertEquals((byte)dstArray[i], (byte)srcArray[i]);
        }
    }

    @Test
    public void checkCharArray() {
        char[] srcArray = new char[]{'\u0001', '\u0002', '\u0003', '\u0004', '\u0005', '\u0006', '\u0007', '\b'};
        char[] dstArray = new char[8];
        Buffer buf = Memory.wrap((char[])srcArray).asBuffer();
        buf.getCharArray(dstArray, 0, 8);
        for (int i = 0; i < 8; ++i) {
            Assert.assertEquals((char)dstArray[i], (char)srcArray[i]);
        }
        WritableBuffer wbuf = WritableMemory.writableWrap((char[])srcArray).asWritableBuffer();
        wbuf.getCharArray(dstArray, 0, 8);
        for (int i = 0; i < 8; ++i) {
            Assert.assertEquals((char)dstArray[i], (char)srcArray[i]);
        }
    }

    @Test
    public void checkShortArray() {
        short[] srcArray = new short[]{1, -2, 3, -4, 5, -6, 7, -8};
        short[] dstArray = new short[8];
        Buffer buf = Memory.wrap((short[])srcArray).asBuffer();
        buf.getShortArray(dstArray, 0, 8);
        for (int i = 0; i < 8; ++i) {
            Assert.assertEquals((short)dstArray[i], (short)srcArray[i]);
        }
        WritableBuffer wbuf = WritableMemory.writableWrap((short[])srcArray).asWritableBuffer();
        wbuf.getShortArray(dstArray, 0, 8);
        for (int i = 0; i < 8; ++i) {
            Assert.assertEquals((short)dstArray[i], (short)srcArray[i]);
        }
    }

    @Test
    public void checkIntArray() {
        int[] srcArray = new int[]{1, -2, 3, -4, 5, -6, 7, -8};
        int[] dstArray = new int[8];
        Buffer buf = Memory.wrap((int[])srcArray).asBuffer();
        buf.getIntArray(dstArray, 0, 8);
        for (int i = 0; i < 8; ++i) {
            Assert.assertEquals((int)dstArray[i], (int)srcArray[i]);
        }
        WritableBuffer wbuf = WritableMemory.writableWrap((int[])srcArray).asWritableBuffer();
        wbuf.getIntArray(dstArray, 0, 8);
        for (int i = 0; i < 8; ++i) {
            Assert.assertEquals((int)dstArray[i], (int)srcArray[i]);
        }
    }

    @Test
    public void checkLongArray() {
        long[] srcArray = new long[]{1L, -2L, 3L, -4L, 5L, -6L, 7L, -8L};
        long[] dstArray = new long[8];
        Buffer buf = Memory.wrap((long[])srcArray).asBuffer();
        buf.getLongArray(dstArray, 0, 8);
        for (int i = 0; i < 8; ++i) {
            Assert.assertEquals((long)dstArray[i], (long)srcArray[i]);
        }
        WritableBuffer wbuf = WritableMemory.writableWrap((long[])srcArray).asWritableBuffer();
        wbuf.getLongArray(dstArray, 0, 8);
        for (int i = 0; i < 8; ++i) {
            Assert.assertEquals((long)dstArray[i], (long)srcArray[i]);
        }
    }

    @Test
    public void checkFloatArray() {
        float[] srcArray = new float[]{1.0f, -2.0f, 3.0f, -4.0f, 5.0f, -6.0f, 7.0f, -8.0f};
        float[] dstArray = new float[8];
        Buffer buf = Memory.wrap((float[])srcArray).asBuffer();
        buf.getFloatArray(dstArray, 0, 8);
        for (int i = 0; i < 8; ++i) {
            Assert.assertEquals((float)dstArray[i], (float)srcArray[i]);
        }
        WritableBuffer wbuf = WritableMemory.writableWrap((float[])srcArray).asWritableBuffer();
        wbuf.getFloatArray(dstArray, 0, 8);
        for (int i = 0; i < 8; ++i) {
            Assert.assertEquals((float)dstArray[i], (float)srcArray[i]);
        }
    }

    @Test
    public void checkDoubleArray() {
        double[] srcArray = new double[]{1.0, -2.0, 3.0, -4.0, 5.0, -6.0, 7.0, -8.0};
        double[] dstArray = new double[8];
        Buffer buf = Memory.wrap((double[])srcArray).asBuffer();
        buf.getDoubleArray(dstArray, 0, 8);
        for (int i = 0; i < 8; ++i) {
            Assert.assertEquals((double)dstArray[i], (double)srcArray[i]);
        }
        WritableBuffer wbuf = WritableMemory.writableWrap((double[])srcArray).asWritableBuffer();
        wbuf.getDoubleArray(dstArray, 0, 8);
        for (int i = 0; i < 8; ++i) {
            Assert.assertEquals((double)dstArray[i], (double)srcArray[i]);
        }
    }

    @Test
    public void checkNativeBaseBound() {
        int memCapacity = 64;
        try (WritableMemory wmem = WritableMemory.allocateDirect((long)memCapacity);){
            WritableBuffer wbuf = wmem.asWritableBuffer();
            wbuf.toString("Bounds Exception", (long)memCapacity, 8, true);
            Assert.fail((String)"Should have thrown MemoryBoundsException");
        }
        catch (MemoryBoundsException memoryBoundsException) {
            // empty catch block
        }
    }

    @Test
    public void checkNativeSrcArrayBound() {
        long memCapacity = 64L;
        try (WritableMemory wmem = WritableMemory.allocateDirect((long)memCapacity);){
            WritableBuffer wbuf = wmem.asWritableBuffer();
            byte[] srcArray = new byte[]{1, -2, 3, -4};
            wbuf.putByteArray(srcArray, 0, 5);
            Assert.fail((String)"Should have thrown MemoryBoundsException");
        }
        catch (MemoryBoundsException memoryBoundsException) {
            // empty catch block
        }
    }

    @Test(expectedExceptions={MemoryBoundsException.class})
    public void checkRegionBounds() {
        int memCapacity = 64;
        try (WritableMemory wmem = WritableMemory.allocateDirect((long)memCapacity);){
            WritableBuffer wbuf = wmem.asWritableBuffer();
            wbuf.writableRegion(1L, 64L, wbuf.getTypeByteOrder());
        }
    }

    @Test
    public void checkByteBufferWrap() {
        int memCapacity = 64;
        ByteBuffer byteBuf = ByteBuffer.allocate(memCapacity);
        byteBuf.order(ByteOrder.nativeOrder());
        for (int i = 0; i < memCapacity; ++i) {
            byteBuf.put(i, (byte)i);
        }
        WritableBuffer wbuf = WritableBuffer.writableWrap((ByteBuffer)byteBuf);
        for (int i = 0; i < memCapacity; ++i) {
            Assert.assertEquals((byte)wbuf.getByte(), (byte)byteBuf.get(i));
        }
        Assert.assertTrue((boolean)wbuf.hasByteBuffer());
        ByteBuffer byteBuf2 = ((ResourceImpl)wbuf).getByteBuffer();
        Assert.assertEquals((Object)byteBuf2, (Object)byteBuf);
    }

    @Test
    public void checkWrapWithBBReadonly1() {
        int memCapacity = 64;
        ByteBuffer byteBuf = ByteBuffer.allocate(memCapacity);
        byteBuf.order(ByteOrder.nativeOrder());
        for (int i = 0; i < memCapacity; ++i) {
            byteBuf.put(i, (byte)i);
        }
        WritableBuffer buf = WritableBuffer.writableWrap((ByteBuffer)byteBuf);
        for (int i = 0; i < memCapacity; ++i) {
            Assert.assertEquals((byte)buf.getByte(), (byte)byteBuf.get(i));
        }
    }

    @Test(expectedExceptions={ReadOnlyException.class})
    public void checkWrapWithBBReadonly2() {
        int memCapacity = 64;
        ByteBuffer byteBuf = ByteBuffer.allocate(memCapacity);
        byteBuf.order(ByteOrder.nativeOrder());
        ByteBuffer byteBufRO = byteBuf.asReadOnlyBuffer();
        byteBufRO.order(ByteOrder.nativeOrder());
        Assert.assertTrue((boolean)true);
        WritableBuffer wbuf = WritableBuffer.writableWrap((ByteBuffer)byteBufRO);
        Assert.assertTrue((boolean)wbuf.isReadOnly());
    }

    @Test
    public void checkWrapWithDirectBBReadonly() {
        int memCapacity = 64;
        ByteBuffer byteBuf = ByteBuffer.allocateDirect(memCapacity);
        byteBuf.order(ByteOrder.nativeOrder());
        for (int i = 0; i < memCapacity; ++i) {
            byteBuf.put(i, (byte)i);
        }
        ByteBuffer byteBufRO = byteBuf.asReadOnlyBuffer();
        byteBufRO.order(ByteOrder.nativeOrder());
        Buffer buf = Buffer.wrap((ByteBuffer)byteBufRO);
        for (int i = 0; i < memCapacity; ++i) {
            Assert.assertEquals((byte)buf.getByte(), (byte)byteBuf.get(i));
        }
    }

    @Test(expectedExceptions={ReadOnlyException.class})
    public void checkWrapWithDirectBBReadonlyPut() {
        int memCapacity = 64;
        ByteBuffer byteBuf = ByteBuffer.allocateDirect(memCapacity);
        ByteBuffer byteBufRO = byteBuf.asReadOnlyBuffer();
        byteBufRO.order(ByteOrder.nativeOrder());
        WritableBuffer.writableWrap((ByteBuffer)byteBufRO);
    }

    @Test
    public void checkByteBufferWrapDirectAccess() {
        int memCapacity = 64;
        ByteBuffer byteBuf = ByteBuffer.allocateDirect(memCapacity);
        byteBuf.order(ByteOrder.nativeOrder());
        for (int i = 0; i < memCapacity; ++i) {
            byteBuf.put(i, (byte)i);
        }
        Buffer buf = Buffer.wrap((ByteBuffer)byteBuf);
        for (int i = 0; i < memCapacity; ++i) {
            Assert.assertEquals((byte)buf.getByte(), (byte)byteBuf.get(i));
        }
    }

    @Test
    public void checkIsDirect() {
        int memCapacity = 64;
        WritableBuffer mem = WritableMemory.allocate((int)memCapacity).asWritableBuffer();
        Assert.assertFalse((boolean)mem.isDirect());
        try (WritableMemory mem2 = WritableMemory.allocateDirect((long)memCapacity);){
            WritableBuffer wbuf = mem2.asWritableBuffer();
            Assert.assertTrue((boolean)wbuf.isDirect());
        }
    }

    @Test
    public void checkIsReadOnly() {
        long[] srcArray = new long[]{1L, -2L, 3L, -4L, 5L, -6L, 7L, -8L};
        WritableBuffer wbuf = WritableMemory.writableWrap((long[])srcArray).asWritableBuffer();
        Assert.assertFalse((boolean)wbuf.isReadOnly());
        WritableBuffer buf = wbuf;
        Assert.assertFalse((boolean)buf.isReadOnly());
        for (int i = 0; i < srcArray.length; ++i) {
            Assert.assertEquals((long)buf.getLong(), (long)srcArray[i]);
        }
    }

    @Test
    public void checkGoodBounds() {
        ResourceImpl.checkBounds((long)50L, (long)50L, (long)100L);
    }

    @Test
    public void checkCompareToHeap() {
        byte[] arr1 = new byte[]{0, 1, 2, 3};
        byte[] arr2 = new byte[]{0, 1, 2, 4};
        byte[] arr3 = new byte[]{0, 1, 2, 3, 4};
        Buffer buf1 = Memory.wrap((byte[])arr1).asBuffer();
        Buffer buf2 = Memory.wrap((byte[])arr2).asBuffer();
        Buffer buf3 = Memory.wrap((byte[])arr3).asBuffer();
        int comp = buf1.compareTo(0L, 3L, buf2, 0L, 3L);
        Assert.assertEquals((int)comp, (int)0);
        comp = buf1.compareTo(0L, 4L, buf2, 0L, 4L);
        Assert.assertEquals((int)comp, (int)-1);
        comp = buf2.compareTo(0L, 4L, buf1, 0L, 4L);
        Assert.assertEquals((int)comp, (int)1);
        comp = buf1.compareTo(0L, 4L, buf3, 0L, 5L);
        Assert.assertEquals((int)comp, (int)-1);
        comp = buf3.compareTo(0L, 5L, buf1, 0L, 4L);
        Assert.assertEquals((int)comp, (int)1);
    }

    @Test
    public void checkCompareToDirect() {
        byte[] arr1 = new byte[]{0, 1, 2, 3};
        byte[] arr2 = new byte[]{0, 1, 2, 4};
        byte[] arr3 = new byte[]{0, 1, 2, 3, 4};
        try (WritableMemory mem1 = WritableMemory.allocateDirect((long)4L);
             WritableMemory mem2 = WritableMemory.allocateDirect((long)4L);
             WritableMemory mem3 = WritableMemory.allocateDirect((long)5L);){
            mem1.putByteArray(0L, arr1, 0, 4);
            mem2.putByteArray(0L, arr2, 0, 4);
            mem3.putByteArray(0L, arr3, 0, 5);
            Buffer buf1 = mem1.asBuffer();
            Buffer buf2 = mem2.asBuffer();
            Buffer buf3 = mem3.asBuffer();
            int comp = buf1.compareTo(0L, 3L, buf2, 0L, 3L);
            Assert.assertEquals((int)comp, (int)0);
            comp = buf1.compareTo(0L, 4L, buf2, 0L, 4L);
            Assert.assertEquals((int)comp, (int)-1);
            comp = buf2.compareTo(0L, 4L, buf1, 0L, 4L);
            Assert.assertEquals((int)comp, (int)1);
            comp = buf1.compareTo(0L, 4L, buf3, 0L, 5L);
            Assert.assertEquals((int)comp, (int)-1);
            comp = buf3.compareTo(0L, 5L, buf1, 0L, 4L);
            Assert.assertEquals((int)comp, (int)1);
        }
    }

    @Test
    public void checkAsBuffer() {
        WritableMemory wmem = WritableMemory.allocate((int)64);
        WritableBuffer wbuf = wmem.asWritableBuffer();
        wbuf.setPosition(32L);
        for (int i = 32; i < 64; ++i) {
            wbuf.putByte((byte)i);
        }
        Buffer buf = wmem.asBuffer();
        buf.setPosition(32L);
        for (int i = 32; i < 64; ++i) {
            Assert.assertEquals((int)buf.getByte(), (int)i);
        }
    }

    @Test
    public void checkDuplicate() {
        WritableMemory wmem = WritableMemory.allocate((int)64);
        for (int i = 0; i < 64; ++i) {
            wmem.putByte((long)i, (byte)i);
        }
        WritableBuffer wbuf = wmem.asWritableBuffer().writableDuplicate();
        ((ResourceImpl)wbuf).checkValidAndBounds(0L, 64L);
        for (int i = 0; i < 64; ++i) {
            Assert.assertEquals((int)wbuf.getByte(), (int)i);
        }
        Buffer buf = wmem.asBuffer().duplicate();
        for (int i = 0; i < 64; ++i) {
            Assert.assertEquals((int)buf.getByte(), (int)i);
        }
        WritableMemory wmem2 = wbuf.asWritableMemory();
        for (int i = 0; i < 64; ++i) {
            Assert.assertEquals((int)wmem2.getByte((long)i), (int)i);
        }
        WritableMemory wmem3 = wbuf.asWritableMemory();
        ((ResourceImpl)wmem3).checkValidAndBounds(0L, 64L);
    }

    @Test
    public void checkCumAndRegionOffset() {
        WritableMemory wmem = WritableMemory.allocate((int)64);
        WritableMemory reg = wmem.writableRegion(32L, 32L);
        WritableBuffer buf = reg.asWritableBuffer();
        Assert.assertEquals((long)buf.getRelativeOffset(), (long)32L);
        Assert.assertEquals((long)((ResourceImpl)buf).getCumulativeOffset(0L), (long)48L);
    }

    @Test
    public void checkIsSameResource() {
        byte[] byteArr = new byte[64];
        WritableBuffer wbuf1 = WritableMemory.writableWrap((byte[])byteArr).asWritableBuffer();
        WritableBuffer wbuf2 = WritableMemory.writableWrap((byte[])byteArr).asWritableBuffer();
        Assert.assertTrue((boolean)wbuf1.isSameResource((Resource)wbuf2));
    }

    @Test
    public void checkDegenerateRegionReturn() {
        Memory mem = Memory.wrap((byte[])new byte[0]);
        Buffer buf = mem.asBuffer();
        Buffer reg = buf.region();
        Assert.assertEquals((long)reg.getCapacity(), (long)0L);
    }

    @Test
    public void checkAsWritableMemoryRO() {
        ByteBuffer bb = ByteBuffer.allocate(64);
        WritableBuffer wbuf = WritableBuffer.writableWrap((ByteBuffer)bb);
        WritableMemory wmem = wbuf.asWritableMemory();
        Assert.assertNotNull((Object)wmem);
        try {
            Buffer buf = Buffer.wrap((ByteBuffer)bb.asReadOnlyBuffer());
            wbuf = (WritableBuffer)buf;
            wmem = wbuf.asWritableMemory();
            Assert.fail((String)"Should have thrown exception");
        }
        catch (ReadOnlyException readOnlyException) {
            // empty catch block
        }
    }

    @Test
    public void checkWritableDuplicateRO() {
        ByteBuffer bb = ByteBuffer.allocate(64);
        WritableBuffer wbuf = WritableBuffer.writableWrap((ByteBuffer)bb);
        WritableBuffer wdup = wbuf.writableDuplicate();
        try {
            Buffer buf = Buffer.wrap((ByteBuffer)bb);
            wbuf = (WritableBuffer)buf;
            WritableBuffer wdup2 = wbuf.writableDuplicate();
            Assert.fail((String)"Should have thrown exception");
        }
        catch (ReadOnlyException readOnlyException) {
            // empty catch block
        }
    }

    @Test
    public void checkWritableRegionRO() {
        ByteBuffer bb = ByteBuffer.allocate(64);
        WritableBuffer wbuf = WritableBuffer.writableWrap((ByteBuffer)bb);
        WritableBuffer wreg = wbuf.writableRegion();
        try {
            Buffer buf = Buffer.wrap((ByteBuffer)bb);
            wbuf = (WritableBuffer)buf;
            WritableBuffer wreg2 = wbuf.writableRegion();
            Assert.fail((String)"Should have thrown exception");
        }
        catch (ReadOnlyException readOnlyException) {
            // empty catch block
        }
    }

    @Test
    public void checkWritableRegionWithParamsRO() {
        ByteBuffer bb = ByteBuffer.allocate(64);
        WritableBuffer wbuf = WritableBuffer.writableWrap((ByteBuffer)bb);
        WritableBuffer wreg = wbuf.writableRegion(0L, 1L, wbuf.getTypeByteOrder());
        try {
            Buffer buf = Buffer.wrap((ByteBuffer)bb);
            wbuf = (WritableBuffer)buf;
            WritableBuffer wreg2 = wbuf.writableRegion(0L, 1L, wbuf.getTypeByteOrder());
            Assert.fail((String)"Should have thrown exception");
        }
        catch (ReadOnlyException readOnlyException) {
            // empty catch block
        }
    }

    @Test
    public void checkZeroBuffer() {
        WritableMemory wmem = WritableMemory.allocate((int)8);
        WritableBuffer wbuf = wmem.asWritableBuffer();
        WritableBuffer reg = wbuf.writableRegion(0L, 0L, wbuf.getTypeByteOrder());
        Assert.assertEquals((long)reg.getCapacity(), (long)0L);
    }

    @Test
    public void checkDuplicateNonNative() {
        WritableMemory wmem = WritableMemory.allocate((int)64);
        wmem.putShort(0L, (short)1);
        Buffer buf = wmem.asWritableBuffer().duplicate(Util.NON_NATIVE_BYTE_ORDER);
        Assert.assertEquals((int)buf.getShort(0L), (int)256);
    }

    @Test
    public void printlnTest() {
        NativeWritableBufferImplTest.println("PRINTING: " + this.getClass().getName());
    }

    static void println(String s) {
    }
}

